/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SlideShowCanvas;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SlideShowView;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class SlideShowUI
extends JScrollPane
implements MouseMotionListener {
    private static final Point ORIGIN = new Point(-1, -1);
    private SlideShowCanvas canvas;
    private boolean adjusting;
    private JProgressBar progressBar;
    private JPanel statusPane;
    private JComponent currentComp;
    private SlideShowView model;

    private void initComponents() {
        this.canvas = new SlideShowCanvas();
        this.canvas.addPropertyChangeListener(this.model);
        this.getVerticalScrollBar().addMouseMotionListener(this);
        this.getHorizontalScrollBar().addMouseMotionListener(this);
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setFont(this.progressBar.getFont().deriveFont(1));
        this.statusPane = new JPanel();
        this.statusPane.setOpaque(false);
        this.statusPane.setLayout(new BoxLayout(this.statusPane, 1));
        this.statusPane.add(this.progressBar);
        this.statusPane.add(UIUtilities.setTextFont("Loading...", 1, 14));
        this.currentComp = this.statusPane;
    }

    private void buildGUI() {
        this.getViewport().setViewPosition(ORIGIN);
        this.getViewport().setLayout(null);
        this.getViewport().add(this.statusPane);
        this.getViewport().setBackground(UIUtilities.BACKGROUND);
    }

    private boolean scrollbarsVisible() {
        JScrollBar hBar = this.getHorizontalScrollBar();
        JScrollBar vBar = this.getVerticalScrollBar();
        if (hBar.isVisible()) {
            return true;
        }
        return vBar.isVisible();
    }

    SlideShowUI(SlideShowView model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void setProgress(boolean hide, int value) {
        if (hide) {
            this.getViewport().removeAll();
            this.getViewport().add(this.canvas);
            this.currentComp = this.canvas;
            this.getViewport().revalidate();
        } else {
            this.progressBar.setValue(value);
        }
    }

    void paintImage(BufferedImage image) {
        this.canvas.paintImage(image);
        this.getViewport().setViewPosition(ORIGIN);
        this.canvas.repaint();
        this.setBounds(this.getBounds());
    }

    public void mouseDragged(MouseEvent e) {
        this.adjusting = true;
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (!this.scrollbarsVisible() && this.adjusting) {
            this.adjusting = false;
        }
        if (this.adjusting) {
            return;
        }
        Rectangle r = this.getViewport().getViewRect();
        Dimension d = this.currentComp.getPreferredSize();
        int xLoc = (r.width - d.width) / 2;
        int yLoc = (r.height - d.height) / 2;
        this.currentComp.setBounds(xLoc, yLoc, d.width, d.height);
    }

    public void mouseMoved(MouseEvent e) {
    }
}

