/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellFieldsView;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class WellFieldsCanvas
extends JPanel {
    private static final Color LINE_COLOR = Color.BLACK;
    private static final int UNIT = 100;
    private static final int TICK = 2;
    private WellFieldsView parent;
    private Map<Rectangle, WellSampleNode> locations;

    private void drawGrid(Graphics2D g2D, int x, int y) {
        int i;
        int i2;
        double f = this.parent.getMagnification();
        int w = (int)(512.0 * f);
        int h = (int)(512.0 * f);
        g2D.setColor(UIUtilities.LIGHT_GREY);
        for (i2 = 0; i2 < h; i2 += 8) {
            g2D.drawLine(0, i2, w, i2);
        }
        for (i2 = 0; i2 < w; i2 += 8) {
            g2D.drawLine(i2, 0, i2, h);
        }
        g2D.setColor(LINE_COLOR);
        g2D.drawLine(0, h / 2, w, h / 2);
        int n = h / 2;
        if (x != 0) {
            n /= x;
        }
        for (i = 1; i <= n; ++i) {
            g2D.drawLine(w / 2 + x * i, h / 2 - 2, w / 2 + x * i, h / 2 + 2);
            g2D.drawLine(w / 2 - x * i, h / 2 - 2, w / 2 - x * i, h / 2 + 2);
        }
        g2D.drawLine(w / 2, 0, w / 2, h);
        n = h / 2;
        if (y != 0) {
            n /= y;
        }
        for (i = 1; i <= n; ++i) {
            g2D.drawLine(w / 2 - 2, h / 2 + y * i, w / 2 + 2, h / 2 + y * i);
            g2D.drawLine(w / 2 - 2, h / 2 - y * i, w / 2 + 2, h / 2 - y * i);
        }
        if (f > 0.25) {
            String s = "100";
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int fs = fm.stringWidth(s);
            g2D.drawString(s, w / 2 + x - fs / 2, h / 2 - 6);
            g2D.drawString(s, w / 2 + 4, h / 2 - y + 4);
            s = "-100";
            fs = fm.stringWidth(s);
            g2D.drawString(s, w / 2 - x - fs / 2, h / 2 - 6);
            g2D.drawString(s, w / 2 + 4, h / 2 + y + 4);
        }
        g2D.drawRect(0, 0, w, h);
    }

    private void setFont() {
        Font f = this.getFont();
        int size = (int)((double)(f.getSize() - 4) * this.parent.getMagnification());
        this.setFont(f.deriveFont(f.getStyle(), size));
    }

    WellFieldsCanvas(WellFieldsView parent) {
        this.parent = parent;
        this.setDoubleBuffered(true);
        this.setPreferredSize(new Dimension(512, 512));
        this.setSize(this.getPreferredSize());
        this.locations = new HashMap<Rectangle, WellSampleNode>();
        this.setFont();
    }

    WellSampleNode getNode(Point p) {
        for (Rectangle r : this.locations.keySet()) {
            if (!r.contains(p)) continue;
            return this.locations.get(r);
        }
        return null;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.locations.clear();
        List<WellSampleNode> l = this.parent.getNodes();
        if (l == null || l.size() == 0) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g;
        ImagePaintingFactory.setGraphicRenderingSettings(g2D);
        Iterator<WellSampleNode> i = l.iterator();
        double f = this.parent.getMagnification();
        double factor = this.parent.getMagnificationUnscaled();
        switch (this.parent.getLayoutFields()) {
            default: {
                int w = 0;
                int h = 0;
                double ff = f * factor;
                while (i.hasNext()) {
                    WellSampleNode n = i.next();
                    BufferedImage img = n.getThumbnail().getFullScaleThumb();
                    if (ff != 1.0) {
                        img = Factory.magnifyImage(ff, img);
                    }
                    if (img == null) continue;
                    if ((double)(w + img.getWidth()) > 512.0 * ff) {
                        w = 0;
                        h += img.getHeight() + 1;
                    }
                    Rectangle r = new Rectangle(w, h, img.getWidth(), img.getHeight());
                    this.locations.put(r, n);
                    g2D.drawImage(img, null, w, h);
                    w += img.getWidth() + 1;
                }
                break;
            }
            case 1: {
                BufferedImage img;
                WellSampleNode n;
                int x = 0;
                int y = 0;
                int xMin = Integer.MAX_VALUE;
                int yMin = Integer.MAX_VALUE;
                int xMax = Integer.MIN_VALUE;
                int yMax = Integer.MIN_VALUE;
                int width = 0;
                int height = 0;
                while (i.hasNext()) {
                    n = i.next();
                    img = n.getThumbnail().getFullScaleThumb();
                    if (img == null) continue;
                    if (width < img.getWidth()) {
                        width = img.getWidth();
                    }
                    if (height < img.getHeight()) {
                        height = img.getHeight();
                    }
                    x = (int)n.getPositionX();
                    y = (int)n.getPositionY();
                    if (x < xMin) {
                        xMin = x;
                    }
                    if (y < yMin) {
                        yMin = y;
                    }
                    if (xMax < x) {
                        xMax = x;
                    }
                    if (yMax >= y) continue;
                    yMax = y;
                }
                int xc = Math.abs(xMin);
                int yc = Math.abs(yMin);
                i = l.iterator();
                int vx = 0;
                int vy = 0;
                int wMax = xc + xMax + (int)((double)width * f);
                int hMax = yc + yMax + (int)((double)height * f);
                double rx = 512.0 * f / (double)wMax;
                double ry = 512.0 * f / (double)hMax;
                this.drawGrid(g2D, (int)(100.0 * rx), (int)(100.0 * ry));
                while (i.hasNext()) {
                    n = i.next();
                    img = n.getThumbnail().getFullScaleThumb();
                    if (img == null) continue;
                    x = (int)n.getPositionX();
                    y = (int)n.getPositionY();
                    vx = (int)((double)(x + xc) * rx);
                    vy = (int)(512.0 * f) - (int)((double)(y + yc) * ry);
                    int w = (int)((double)width * rx * f * factor);
                    int h = (int)((double)height * ry * f);
                    vy -= h;
                    h = (int)((double)h * factor);
                    BufferedImage scaled = Factory.scaleBufferedImage(img, w, h);
                    Rectangle r = new Rectangle(vx, vy, w, h);
                    g2D.drawImage(scaled, null, r.x, r.y);
                    this.locations.put(r, n);
                }
                break block0;
            }
        }
        g2D.dispose();
    }
}

