/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.visitor;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import pojos.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetNodesVisitor
implements ImageDisplayVisitor {
    private Collection<ImageDisplay> nodes;
    private Collection<DataObject> visibleImages;
    private boolean reset;

    public ResetNodesVisitor(Collection<ImageDisplay> nodes, boolean reset) {
        if (nodes == null && reset) {
            throw new IllegalArgumentException("No nodes to find.");
        }
        this.nodes = nodes;
        this.visibleImages = new ArrayList<DataObject>();
        this.reset = reset;
    }

    public Collection<DataObject> getVisibleImages() {
        return this.visibleImages;
    }

    @Override
    public void visit(ImageNode node) {
    }

    @Override
    public void visit(ImageSet node) {
        block4: {
            if (!node.containsImages()) break block4;
            JComponent desktop = node.getInternalDesktop();
            if (this.reset) {
                desktop.removeAll();
                for (ImageDisplay child : this.nodes) {
                    DataObject ho;
                    ImageDisplay parent = child.getParentDisplay();
                    if (parent != null && node != parent || this.visibleImages.contains(ho = (DataObject)child.getHierarchyObject())) continue;
                    this.visibleImages.add(ho);
                    desktop.add(child);
                }
            } else {
                Component[] comps = desktop.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component comp = comps[i];
                    if (!(comp instanceof ImageDisplay)) continue;
                    ImageDisplay child = (ImageDisplay)comp;
                    this.visibleImages.add((DataObject)child.getHierarchyObject());
                }
            }
        }
    }
}

