/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor;

import java.io.File;
import org.openmicroscopy.shoola.agents.editor.EditorLoader;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.DataObject;
import pojos.FileAnnotationData;

public class FileSaver
extends EditorLoader {
    public static final int PROTOCOL = 0;
    public static final int EXPERIMENT = 1;
    public static final int OTHER = 3;
    private CallHandle handle;
    private File file;
    private FileAnnotationData fileAnnotationData;
    private int index;
    private DataObject linkTo;

    public FileSaver(Editor viewer, File file, FileAnnotationData data, int index, DataObject linkTo) {
        super(viewer);
        if (file == null) {
            throw new IllegalArgumentException("No file to save.");
        }
        if (data == null) {
            throw new IllegalArgumentException("No file Annotation.");
        }
        this.file = file;
        this.fileAnnotationData = data;
        this.linkTo = linkTo;
        switch (index) {
            case 0: 
            case 1: {
                this.index = index;
                break;
            }
            default: {
                this.index = 3;
            }
        }
    }

    public void load() {
        this.handle = this.mhView.saveFile(this.fileAnnotationData, this.file, this.index, this.linkTo, this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 16) {
            return;
        }
        this.viewer.onFileSave((FileAnnotationData)result);
        String message = "Cannot delete the file.";
        if (this.file.delete()) {
            message = "File deleted.";
        }
        this.registry.getLogger().info((Object)this, message);
    }
}

