/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.agents.editor.actions.EditorAction;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.util.filter.file.EditorFileFilter;
import org.openmicroscopy.shoola.util.filter.file.XMLFilter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

public class OpenLocalFileAction
extends EditorAction
implements PropertyChangeListener {
    private static final String NAME = "Open File";
    private static final String DESCRIPTION = "Open a Local File on your computer";
    private List<FileFilter> filters;
    private FileChooser chooser;

    public OpenLocalFileAction(Editor model) {
        super(model);
        this.setEnabled(true);
        this.setName(NAME);
        this.setDescription(DESCRIPTION);
        this.setIcon(52);
        this.filters = new ArrayList<FileFilter>();
        this.filters.add(new EditorFileFilter());
        this.filters.add(new XMLFilter());
    }

    public void actionPerformed(ActionEvent e) {
        this.chooser = new FileChooser(null, 0, NAME, "Choose a file to open in the Editor", this.filters);
        this.chooser.addPropertyChangeListener("approveSelection", this);
        UIUtilities.centerAndShow(this.chooser);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("approveSelection".equals(name)) {
            File f = (File)evt.getNewValue();
            FileFilter filter = this.chooser.getSelectedFilter();
            if (filter.accept(f)) {
                this.model.openLocalFile(f);
            }
        }
    }
}

