/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.actions;

import java.awt.event.ActionEvent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.browser.Browser;
import org.openmicroscopy.shoola.agents.editor.browser.actions.BrowserAction;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.TreeEdit;
import org.openmicroscopy.shoola.agents.events.editor.CopyEvent;
import org.openmicroscopy.shoola.env.config.Registry;

public class CopyFieldsAction
extends BrowserAction
implements TreeSelectionListener,
TreeEdit {
    protected JTree treeUI;

    protected void onStateChange() {
        this.refreshState();
    }

    private void refreshState() {
        if (this.treeUI != null) {
            this.setEnabled(this.treeUI.getSelectionCount() > 0);
        } else {
            this.setEnabled(false);
        }
    }

    public CopyFieldsAction(Browser model) {
        super(model);
        this.setName("Copy Selected Steps");
        this.setDescription("Copy the selected steps to the clipboard");
        this.setIcon(67);
    }

    public void setTree(JTree tree) {
        if (tree == null) {
            return;
        }
        if (this.treeUI != null) {
            this.treeUI.removeTreeSelectionListener(this);
        }
        this.treeUI = tree;
        this.treeUI.addTreeSelectionListener(this);
        this.refreshState();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.treeUI == null) {
            return;
        }
        TreePath[] paths = this.treeUI.getSelectionPaths();
        Object[] nodes = new Object[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            nodes[i] = TreeModelMethods.duplicateNode(node);
        }
        Registry reg = EditorAgent.getRegistry();
        reg.getEventBus().post(new CopyEvent(nodes));
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.refreshState();
    }
}

