/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JToolBar;
import javax.swing.border.MatteBorder;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AbstractParamEditor;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomButton;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ParamToolBar
extends AbstractParamEditor
implements ActionListener {
    private static final String REQUIRED = "required";
    private static final String NOT_REQUIRED = "notRequired";
    private static final String DELETE_PARAM = "deleteParam";

    private void buildUI() {
        IAttributes parameter = this.getParameter();
        IconManager iM = IconManager.getInstance();
        JToolBar leftToolBar = new JToolBar();
        leftToolBar.setBackground(null);
        leftToolBar.setFloatable(false);
        MatteBorder bottomRight = BorderFactory.createMatteBorder(0, 0, 1, 1, UIUtilities.LIGHT_GREY);
        leftToolBar.setBorder(bottomRight);
        Icon red = iM.getIcon(74);
        Icon grey = iM.getIcon(83);
        CustomButton requiredButton = new CustomButton(grey);
        requiredButton.addActionListener(this);
        if (parameter.isAttributeTrue("paramRequired")) {
            requiredButton.setToolTipText("This parameter is 'required'");
            requiredButton.setIcon(red);
            requiredButton.setActionCommand(NOT_REQUIRED);
        } else {
            requiredButton.setToolTipText("Mark this as a 'required' parameter");
            requiredButton.setActionCommand(REQUIRED);
        }
        leftToolBar.add(requiredButton);
        Icon info = iM.getIcon(75);
        CustomButton infoButton = new CustomButton(info);
        infoButton.setEnabled(false);
        leftToolBar.add(infoButton);
        String paramDesc = parameter.getAttribute("paramDescription");
        if (paramDesc != null) {
            infoButton.setToolTipText("<html><div style='width:250px; padding:2px'>Parameter Description:<br>" + paramDesc + "</div></html>");
            infoButton.setEnabled(true);
        } else {
            infoButton.setToolTipText("No parameter description");
        }
        JToolBar rightToolBar = new JToolBar();
        rightToolBar.setBackground(null);
        rightToolBar.setFloatable(false);
        MatteBorder bottomLeft = BorderFactory.createMatteBorder(0, 1, 1, 0, UIUtilities.LIGHT_GREY);
        rightToolBar.setBorder(bottomLeft);
        Icon delete = iM.getIcon(84);
        CustomButton deleteButton = new CustomButton(delete);
        deleteButton.setActionCommand(DELETE_PARAM);
        deleteButton.addActionListener(this);
        deleteButton.setToolTipText("Delete this parameter");
        rightToolBar.add(deleteButton);
        this.setLayout(new BorderLayout());
        this.setBackground(null);
        this.setBorder(null);
        this.add((Component)leftToolBar, "West");
        this.add((Component)rightToolBar, "East");
    }

    public ParamToolBar(IParam parameter) {
        super(parameter);
        this.buildUI();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (REQUIRED.equals(cmd)) {
            this.attributeEdited("paramRequired", "true");
        } else if (NOT_REQUIRED.equals(cmd)) {
            this.attributeEdited("paramRequired", "false");
        } else if (DELETE_PARAM.equals(cmd)) {
            this.firePropertyChange("paramType", null, "No Param");
        }
    }

    public String getEditDisplayName() {
        return "Edit 'Required' status";
    }
}

