/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AbstractParamEditor;
import org.openmicroscopy.shoola.agents.editor.model.params.EditorLinkParam;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomButton;
import org.openmicroscopy.shoola.agents.editor.uiComponents.PopupMenuButton;
import org.openmicroscopy.shoola.agents.events.editor.EditFileEvent;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.filter.file.EditorFileFilter;
import org.openmicroscopy.shoola.util.ui.InputDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

public class ProtocolLinkEditor
extends AbstractParamEditor
implements ActionListener,
PropertyChangeListener {
    private Icon editorLinkIcon;
    private Icon brokenLinkIcon;
    private JButton linkButton;
    private JButton getLinkButton;
    private Long fileID;
    private String filePath;

    private void initialise() {
        IconManager imF = IconManager.getInstance();
        this.editorLinkIcon = imF.getIcon(57);
        this.brokenLinkIcon = imF.getIcon(23);
        Icon chooseLinkIcon = imF.getIcon(24);
        this.linkButton = new CustomButton();
        this.linkButton.addActionListener(this);
        this.linkButton.setCursor(new Cursor(12));
        this.linkButton.setForeground(Color.BLUE);
        Action[] getLinkActions = new Action[]{new GetIDAction(), new GetLinkPathAction()};
        this.getLinkButton = new PopupMenuButton("Choose a link an Ediot  or local file", chooseLinkIcon, getLinkActions);
    }

    private void buildUI() {
        this.add(this.linkButton);
        this.add(this.getLinkButton);
    }

    private void updateLink() {
        String editorLink = this.getParameter().getAttribute("value");
        if (editorLink == null) {
            this.linkButton.setText("");
            this.linkButton.setToolTipText("No link set");
            this.linkButton.setEnabled(false);
            return;
        }
        if (EditorLinkParam.isLinkValidId(editorLink)) {
            this.fileID = new Long(editorLink);
        } else {
            this.filePath = editorLink;
        }
        if (this.filePath != null) {
            int len = this.filePath.length();
            this.linkButton.setText(len < 30 ? this.filePath : "..." + this.filePath.substring(len - 29, len));
            this.linkButton.setToolTipText("Open the local Editor file: " + this.filePath);
            this.linkButton.setEnabled(true);
            File linkedFile = new File(this.filePath);
            if (!linkedFile.exists()) {
                this.linkButton.setIcon(this.brokenLinkIcon);
                this.linkButton.setEnabled(false);
                this.linkButton.setToolTipText("FILE NOT FOUND: " + this.filePath);
            }
            return;
        }
        if (this.fileID > 0L) {
            this.linkButton.setText("File ID: " + this.fileID);
            this.linkButton.setToolTipText("Open the Editor file on the server, ID: " + this.fileID);
            this.linkButton.setEnabled(true);
        }
    }

    public ProtocolLinkEditor(IParam param) {
        super(param);
        this.initialise();
        this.buildUI();
        this.updateLink();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.filePath != null) {
            File f = new File(this.filePath);
            if (f.exists()) {
                EditorAgent.openLocalFile(f);
            }
        } else if (this.fileID > 0L) {
            EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
            bus.post(new EditFileEvent(this.fileID));
        }
    }

    public void attributeEdited(String attributeName, Object newValue) {
        super.attributeEdited(attributeName, newValue);
        this.firePropertyChange("sizeChangedPropery", null, null);
    }

    public String getEditDisplayName() {
        return "Edit Link";
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("approveSelection".equals(evt.getPropertyName())) {
            File f = (File)evt.getNewValue();
            this.attributeEdited("value", f.getAbsolutePath());
        }
    }

    private class GetLinkPathAction
    extends AbstractAction {
        public GetLinkPathAction() {
            this.putValue("Name", "Set Link to local file");
            this.putValue("ShortDescription", "Choose a file, that will be linked from this file");
            this.putValue("SmallIcon", ProtocolLinkEditor.this.editorLinkIcon);
        }

        public void actionPerformed(ActionEvent e) {
            ArrayList<FileFilter> filters = new ArrayList<FileFilter>();
            filters.add(new EditorFileFilter());
            FileChooser chooser = new FileChooser(null, 0, "Open File", "Choose a file to open in the Editor", filters);
            chooser.addPropertyChangeListener("approveSelection", ProtocolLinkEditor.this);
            UIUtilities.centerAndShow(chooser);
        }
    }

    private class GetIDAction
    extends AbstractAction {
        public GetIDAction() {
            boolean server = EditorAgent.isServerAvailable();
            this.putValue("Name", "File on Server");
            this.putValue("ShortDescription", server ? "Choose the ID of a file on the server." : "Server not available");
            this.putValue("SmallIcon", ProtocolLinkEditor.this.editorLinkIcon);
            this.setEnabled(server);
        }

        public void actionPerformed(ActionEvent e) {
            JFrame f = EditorAgent.getRegistry().getTaskBar().getFrame();
            InputDialog dialog = new InputDialog(f, "Enter ID of Editor File on Server", "");
            int option = dialog.centerMsgBox();
            if (option == 1) {
                String newFileID = dialog.getText();
                if (EditorLinkParam.isLinkValidId(newFileID)) {
                    ProtocolLinkEditor.this.attributeEdited("value", newFileID);
                } else {
                    UserNotifier un = EditorAgent.getRegistry().getUserNotifier();
                    un.notifyInfo("Not valid ID", "Did not enter a valid Editor file ID");
                }
            }
        }
    }
}

