/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.params;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.model.params.FieldParamsFactory;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParam
implements IParam {
    public static final String PARAM_TYPE = "paramType";
    public static final String PARAM_NAME = "paramName";
    public static final String DEFAULT_PARAM_NAME = "param";
    public static final String PARAM_REQUIRED = "paramRequired";
    public static final String PARAM_DESC = "paramDescription";
    private HashMap<String, String> valueAttributesMap = new HashMap();
    private List<Object> paramValues;
    private static String[] commonUnits;

    public AbstractParam(String fieldType) {
        this.valueAttributesMap.put(PARAM_TYPE, fieldType);
        this.paramValues = new ArrayList<Object>();
    }

    public static String[] getCommonUnits() {
        if (commonUnits == null) {
            String units = (String)EditorAgent.getRegistry().lookup("/model/units");
            commonUnits = units.split(",");
            int unitsCount = commonUnits.length;
            for (int i = 0; i < unitsCount; ++i) {
                AbstractParam.commonUnits[i] = commonUnits[i].trim();
            }
        }
        return commonUnits;
    }

    public HashMap<String, String> getAllAttributes() {
        return this.valueAttributesMap;
    }

    public void setAllAttributes(HashMap<String, String> newAttributes) {
        this.valueAttributesMap = newAttributes;
    }

    @Override
    public boolean isParamFilled() {
        String textValue = this.getParamValue();
        return textValue != null && textValue.trim().length() > 0;
    }

    public String getFieldType() {
        return this.getAttribute(PARAM_TYPE);
    }

    @Override
    public String getAttribute(String name) {
        if ("value".equals(name)) {
            return this.getParamValue();
        }
        return this.valueAttributesMap.get(name);
    }

    @Override
    public boolean isAttributeTrue(String attributeName) {
        return Boolean.valueOf(this.getAttribute(attributeName));
    }

    @Override
    public void setAttribute(String name, String value) {
        if ("value".equals(name)) {
            this.setValueAt(0, value);
        }
        this.valueAttributesMap.put(name, value);
    }

    @Override
    public int getValueCount() {
        return this.paramValues.size();
    }

    @Override
    public Object getValueAt(int index) {
        if (index < 0 || index + 1 > this.paramValues.size()) {
            return null;
        }
        return this.paramValues.get(index);
    }

    @Override
    public void setValueAt(int index, Object value) {
        if (index < 0) {
            return;
        }
        while (index + 1 > this.paramValues.size()) {
            this.paramValues.add("");
        }
        this.paramValues.set(index, value);
    }

    @Override
    public void insertValue(int index, Object value) {
        if (index < 0) {
            return;
        }
        while (index > this.paramValues.size()) {
            this.paramValues.add("");
        }
        this.paramValues.add(index, value);
    }

    @Override
    public void removeValueAt(int index) {
        if (index < 0) {
            return;
        }
        if (index > this.paramValues.size() + 1) {
            return;
        }
        this.paramValues.remove(index);
    }

    @Override
    public String toString() {
        String name = this.getAttribute(PARAM_NAME);
        if (name == null) {
            name = this.getAttribute(PARAM_TYPE);
            name = FieldParamsFactory.getTypeForDisplay(name);
        }
        return name == null ? "" : name;
    }

    @Override
    public String getParamValue() {
        if (this.getValueAt(0) == null) {
            return null;
        }
        return this.getValueAt(0) + "";
    }

    @Override
    public IParam cloneParam() {
        String paramType = this.getAttribute(PARAM_TYPE);
        IParam newParam = FieldParamsFactory.getFieldParam(paramType);
        for (String name : this.valueAttributesMap.keySet()) {
            String value = this.getAttribute(name);
            if (value == null) continue;
            newParam.setAttribute(name, value);
        }
        int index = 0;
        for (Object object : this.paramValues) {
            newParam.setValueAt(index++, object);
        }
        return newParam;
    }
}

