/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesEdit
extends AbstractUndoableEdit {
    private IAttributes attributes;
    private Map<String, String> newValues;
    private Map<String, String> oldValues;
    private String displayName;
    private JTree tree;
    private TreeNode node;

    private void notifySelectStartEdit() {
        this.notifyNodeChanged();
        TreeModelMethods.selectNode(this.node, this.tree);
        DefaultMutableTreeNode dmtNode = (DefaultMutableTreeNode)this.node;
        this.tree.startEditingAtPath(new TreePath(dmtNode.getPath()));
    }

    private void notifyNodeChanged() {
        if (this.tree != null && this.node != null) {
            DefaultMutableTreeNode dmtNode = (DefaultMutableTreeNode)this.node;
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            treeModel.nodeChanged(this.node);
        }
    }

    private void doEdit() {
        if (this.canDo()) {
            for (String key : this.newValues.keySet()) {
                this.oldValues.put(key, this.attributes.getAttribute(key));
                this.attributes.setAttribute(key, this.newValues.get(key));
            }
            this.notifyNodeChanged();
        }
    }

    public AttributesEdit(IAttributes attributes, String displayName, HashMap<String, String> newValues, JTree tree, TreeNode node) {
        this.displayName = displayName;
        this.attributes = attributes;
        this.newValues = new HashMap<String, String>(newValues);
        this.oldValues = new HashMap<String, String>();
        this.tree = tree;
        this.node = node;
        this.doEdit();
    }

    public boolean canDo() {
        return this.attributes != null && this.newValues != null;
    }

    @Override
    public void undo() {
        for (String key : this.oldValues.keySet()) {
            this.attributes.setAttribute(key, this.oldValues.get(key));
        }
        this.notifySelectStartEdit();
    }

    @Override
    public void redo() {
        for (String key : this.newValues.keySet()) {
            this.attributes.setAttribute(key, this.newValues.get(key));
        }
        this.notifySelectStartEdit();
    }

    @Override
    public String getPresentationName() {
        return this.displayName;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }
}

