/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.IFieldContent;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.UndoableTreeEdit;

public class ChangeParamEdit
extends UndoableTreeEdit {
    private TreeNode node;
    private IField field;
    private IFieldContent newParam;
    private IFieldContent oldParam;
    private String oldParamName;
    private int paramIndex;

    private void notifySelectStartEdit() {
        this.notifyNodeChanged();
        TreeModelMethods.selectNode(this.node, this.tree);
        DefaultMutableTreeNode dmtNode = (DefaultMutableTreeNode)this.node;
        this.tree.startEditingAtPath(new TreePath(dmtNode.getPath()));
    }

    private void notifyNodeChanged() {
        if (this.tree != null && this.node != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            treeModel.nodeChanged(this.node);
        }
    }

    public ChangeParamEdit(IParam newParam, IParam oldParam, IField field, JTree tree, TreeNode node) {
        super(tree);
        this.field = field;
        this.newParam = newParam;
        this.node = node;
        this.oldParam = oldParam;
        this.doEdit();
    }

    public ChangeParamEdit(IParam newParam, IField field, int index, JTree tree, TreeNode node) {
        super(tree);
        this.field = field;
        this.newParam = newParam;
        this.paramIndex = index;
        this.node = node;
        if (field.getContentCount() <= this.paramIndex) {
            throw new RuntimeException("ChangeParam edit index out of bounds");
        }
        this.oldParam = field.getContentAt(this.paramIndex);
        this.doEdit();
    }

    public boolean canDo() {
        return this.field != null;
    }

    public void doEdit() {
        if (!this.canDo()) {
            return;
        }
        if (this.oldParam != null) {
            this.oldParamName = this.oldParam.getAttribute("paramName");
            this.paramIndex = this.field.removeContent(this.oldParam);
        }
        if (this.newParam != null) {
            this.newParam.setAttribute("paramName", this.oldParamName);
            this.field.addContent(this.paramIndex, this.newParam);
        }
        this.notifySelectStartEdit();
    }

    public void undo() {
        if (!this.canDo()) {
            return;
        }
        if (this.newParam != null) {
            this.field.removeContent(this.newParam);
        }
        if (this.oldParam != null) {
            this.field.addContent(this.paramIndex, this.oldParam);
        }
        this.notifySelectStartEdit();
    }

    public void redo() {
        if (!this.canDo()) {
            return;
        }
        if (this.oldParam != null) {
            this.field.removeContent(this.oldParam);
        }
        if (this.newParam != null) {
            this.field.addContent(this.paramIndex, this.newParam);
        }
        this.notifySelectStartEdit();
    }

    public String getPresentationName() {
        if (this.newParam == null) {
            return "Delete Paramter";
        }
        return "Change Parameter";
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }
}

