/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.UndoableTreeEdit;

public class IndentRightEdit
extends UndoableTreeEdit {
    private List<DefaultMutableTreeNode> movedNodes = new ArrayList<DefaultMutableTreeNode>();

    public IndentRightEdit(JTree tree) {
        super(tree);
    }

    public static boolean canDo(TreePath[] paths) {
        if (paths == null) {
            return false;
        }
        if (paths.length == 0) {
            return false;
        }
        TreePath selectedPath = paths[0];
        DefaultMutableTreeNode firstNode = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
        DefaultMutableTreeNode previousSibling = firstNode.getPreviousSibling();
        return previousSibling != null;
    }

    public void doEdit() {
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        if (!IndentRightEdit.canDo(selectedPaths)) {
            return;
        }
        if (selectedPaths.length > 0) {
            for (int i = 0; i < selectedPaths.length; ++i) {
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)selectedPaths[i].getLastPathComponent();
                this.movedNodes.add(currentNode);
            }
        }
        this.redo();
    }

    public void undo() {
        TreeModelMethods.indentNodesLeft(this.movedNodes, this.treeModel);
        TreeModelMethods.selectDNodes(this.movedNodes, this.tree);
    }

    public void redo() {
        TreeModelMethods.indentNodesRight(this.movedNodes, this.treeModel);
        TreeModelMethods.selectDNodes(this.movedNodes, this.tree);
    }

    public String getPresentationName() {
        return "Indent Fields to Right";
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }
}

