/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.UndoableTreeEdit;

public class MoveDownEdit
extends UndoableTreeEdit {
    private List<DefaultMutableTreeNode> movedNodes = new ArrayList<DefaultMutableTreeNode>();

    public MoveDownEdit(JTree tree) {
        super(tree);
    }

    public static boolean canDo(TreePath[] paths) {
        if (paths == null) {
            return false;
        }
        int selectionCount = paths.length;
        if (selectionCount == 0) {
            return false;
        }
        TreePath selectedPath = paths[selectionCount - 1];
        DefaultMutableTreeNode lastNode = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
        DefaultMutableTreeNode nextSibling = lastNode.getNextSibling();
        return nextSibling != null;
    }

    public void doEdit() {
        if (this.tree == null) {
            return;
        }
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        if (!MoveDownEdit.canDo(selectedPaths)) {
            return;
        }
        if (selectedPaths.length > 0) {
            for (int i = 0; i < selectedPaths.length; ++i) {
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)selectedPaths[i].getLastPathComponent();
                this.movedNodes.add(currentNode);
            }
        }
        this.redo();
    }

    public void undo() {
        TreeModelMethods.moveFieldsUp(this.movedNodes, this.treeModel);
        TreeModelMethods.selectDNodes(this.movedNodes, this.tree);
    }

    public void redo() {
        TreeModelMethods.moveFieldsDown(this.movedNodes, this.treeModel);
        TreeModelMethods.selectDNodes(this.movedNodes, this.tree);
    }

    public String getPresentationName() {
        return "Move Fields Down";
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }
}

