/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.uiComponents;

import java.awt.Dimension;
import javax.swing.JTextField;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomFont;
import org.openmicroscopy.shoola.agents.editor.uiComponents.UIUtilities;

public class CustomTextField
extends JTextField {
    private int customMinWidth = 0;

    public CustomTextField(String text) {
        super(text);
        this.init();
    }

    public CustomTextField() {
        this.init();
    }

    public CustomTextField(int minWidth) {
        this.init();
        this.setMinWidth(minWidth);
    }

    private void init() {
        this.setFont(new CustomFont());
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        int h = (int)size.getHeight();
        int w = (int)size.getWidth();
        int minW = this.customMinWidth > 0 ? this.customMinWidth : UIUtilities.getInstance().getDimension(UIUtilities.TEXT_FIELD_MIN_WIDTH);
        w = Math.max(w, minW);
        size.setSize(w, h);
        return size;
    }

    public void setMinWidth(int minWidth) {
        this.customMinWidth = minWidth;
    }
}

