/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.uiComponents;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;
import javax.swing.text.MaskFormatter;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomFont;
import org.openmicroscopy.shoola.agents.editor.uiComponents.UIUtilities;
import org.openmicroscopy.shoola.env.log.LogMessage;

public class DoubleDigitField
extends JFormattedTextField {
    public static final Color BLUE_HIGHLIGHT = new Color(181, 213, 255);
    public static final String DIGIT_VALUE_PROPERTY = "digitValueProperty";
    Border selectedBorder;
    Border unSelectedBorder;
    private int minValue;
    private int maxValue;
    private String oldValue;

    public DoubleDigitField(int maxValue) {
        this(0, maxValue);
    }

    public DoubleDigitField(int minValue, int maxValue) {
        super(DoubleDigitField.createFormatter("##"));
        this.minValue = minValue;
        this.maxValue = maxValue;
        int padding = 2;
        LineBorder blackBorder = new LineBorder(Color.black);
        LineBorder whiteBorder = new LineBorder(Color.gray);
        EmptyBorder emptyBorder = new EmptyBorder(padding, padding, padding, padding);
        this.selectedBorder = BorderFactory.createCompoundBorder(blackBorder, emptyBorder);
        this.unSelectedBorder = BorderFactory.createCompoundBorder(whiteBorder, emptyBorder);
        UIUtilities r = UIUtilities.getInstance();
        int width = r.getDimension(UIUtilities.DOUBLE_DIGIT_FIELD_W);
        int height = r.getDimension(UIUtilities.SINGLE_ROW_HEiGHT);
        Dimension fieldSize = new Dimension(width, height);
        this.setPreferredSize(fieldSize);
        this.setMaximumSize(fieldSize);
        this.setFont(new CustomFont());
        this.setBorder(this.unSelectedBorder);
        this.setSelectionColor(BLUE_HIGHLIGHT);
        this.setSelectedTextColor(Color.black);
        this.addFocusListener(new FieldFocusListener());
    }

    public String checkRange(String value) {
        int val = new Integer(value);
        val = Math.max(val, this.minValue);
        val = Math.min(val, this.maxValue);
        return val + "";
    }

    public void setText(String text) {
        this.oldValue = text;
        if (text.length() == 1) {
            text = "0" + text;
        }
        super.setText(text);
    }

    protected static MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            LogMessage msg = new LogMessage();
            msg.print("createFormatter");
            msg.print(exc);
            EditorAgent.getRegistry().getLogger().error(DoubleDigitField.class, msg);
        }
        return formatter;
    }

    public class FieldFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent e) {
            JTextComponent source = (JTextComponent)e.getSource();
            source.setBorder(DoubleDigitField.this.selectedBorder);
            source.setSelectionStart(0);
            source.setSelectionEnd(2);
        }

        public void focusLost(FocusEvent e) {
            String oldVal = DoubleDigitField.this.oldValue;
            String newValue = DoubleDigitField.this.checkRange(DoubleDigitField.this.getText().trim());
            DoubleDigitField.this.setText(newValue);
            if (!newValue.equals(oldVal)) {
                DoubleDigitField.this.firePropertyChange(DoubleDigitField.DIGIT_VALUE_PROPERTY, oldVal, newValue);
            }
            JTextComponent source = (JTextComponent)e.getSource();
            source.setBorder(DoubleDigitField.this.unSelectedBorder);
            source.setSelectionStart(0);
            source.setSelectionEnd(0);
        }
    }
}

