/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.actions.EditorAction;
import org.openmicroscopy.shoola.agents.editor.view.EditorControl;
import org.openmicroscopy.shoola.agents.editor.view.EditorFactory;
import org.openmicroscopy.shoola.agents.editor.view.EditorModel;
import org.openmicroscopy.shoola.agents.editor.view.EditorStatusBar;
import org.openmicroscopy.shoola.agents.editor.view.EditorToolBar;
import org.openmicroscopy.shoola.agents.editor.view.NoFileOpenUI;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.TopWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class EditorUI
extends TopWindow {
    private EditorControl controller;
    private EditorModel model;
    private EditorToolBar toolBar;
    private Box toolBarContainer;
    private EditorStatusBar statusBar;
    private JPanel splashScreen;

    private JMenu createMenu() {
        JMenu menu = new JMenu("File");
        this.addMenuItem(EditorControl.OPEN_LOCAL_FILE, menu, 79);
        this.addMenuItem(EditorControl.OPEN_WWW_FILE, menu, 0);
        this.addMenuItem(EditorControl.SAVE_FILE, menu, 83);
        this.addMenuItem(EditorControl.SAVE_FILE_LOCALLY, menu, 0);
        this.addMenuItem(EditorControl.SAVE_FILE_SERVER, menu, 0);
        this.addMenuItem(EditorControl.SAVE_AS_PROTOCOL, menu, 0);
        this.addMenuItem(EditorControl.NEW_BLANK_FILE, menu, 78);
        this.addMenuItem(EditorControl.CLOSE_EDITOR, menu, 87);
        return menu;
    }

    private void addMenuItem(int actionId, JMenu menu, int key) {
        EditorAction a = this.controller.getAction(actionId);
        JMenuItem item = new JMenuItem(a);
        if (key != 0) {
            EditorUI.setMenuItemAccelerator(item, key);
        }
        menu.add(item);
    }

    private JMenuBar createMenuBar() {
        int i;
        TaskBar tb = EditorAgent.getRegistry().getTaskBar();
        JMenu menu = this.createMenu();
        JMenuBar bar = tb.getTaskBarMenuBar();
        JMenu[] existingMenus = new JMenu[bar.getMenuCount()];
        for (i = 0; i < existingMenus.length; ++i) {
            existingMenus[i] = bar.getMenu(i);
        }
        bar.removeAll();
        bar.add(menu);
        for (i = 0; i < existingMenus.length; ++i) {
            bar.add(existingMenus[i]);
        }
        return bar;
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        JPanel toolBarBoxAlign = new JPanel(new BorderLayout());
        toolBarBoxAlign.setBackground(null);
        this.toolBarContainer = Box.createHorizontalBox();
        this.toolBarContainer.setBorder(new EmptyBorder(4, 4, 4, 4));
        toolBarBoxAlign.add((Component)this.toolBarContainer, "West");
        c.add((Component)toolBarBoxAlign, "North");
        this.splashScreen = new NoFileOpenUI(this.controller);
        c.add(this.splashScreen);
        this.toolBarContainer.add(this.toolBar);
        c.add((Component)this.statusBar, "South");
    }

    private static void setMenuItemAccelerator(JMenuItem menuItem, int key) {
        if (UIUtilities.isMacOS()) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke(key, 4));
        } else {
            menuItem.setAccelerator(KeyStroke.getKeyStroke(key, 128));
        }
    }

    EditorUI(String title) {
        super(title);
    }

    void initialize(EditorControl controller, EditorModel model) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.toolBar = new EditorToolBar(controller);
        this.statusBar = new EditorStatusBar();
        this.setJMenuBar(this.createMenuBar());
        this.buildGUI();
        this.setOnScreen();
    }

    void setStatus(String text, boolean hide) {
        this.statusBar.setStatus(text);
        this.statusBar.setProgress(hide);
    }

    void displayFile(String contents) {
        this.remove(this.splashScreen);
        JTextPane pane = new JTextPane();
        pane.setEditable(false);
        pane.setText(contents);
        this.add((Component)new JScrollPane(pane), "Center");
        this.setTitle(this.model.getFileName());
        this.validate();
        this.repaint();
    }

    void displayFile() {
        this.remove(this.splashScreen);
        this.add((Component)this.model.getBrowser().getUI(), "Center");
        this.toolBarContainer.add(new JSeparator(1));
        this.toolBarContainer.add(this.model.getBrowser().getToolBar());
        this.setTitle(this.model.getFileName());
        this.validate();
        this.repaint();
    }

    public void setOnScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w = 8 * (screenSize.width / 10);
        int h = 8 * (screenSize.height / 10);
        w = Math.min(1100, w);
        h = Math.min(600, h);
        int x = screenSize.width / 9;
        int y = screenSize.height / 10;
        int windowCount = EditorFactory.getEditorCount();
        int offset = windowCount * 20;
        this.setSize(w, h);
        this.setLocation(x += offset, y += offset);
    }
}

