/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.chooser;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.FileElement;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ImportDialog;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.treetable.renderers.StringCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileSelectionTable
extends JPanel
implements ActionListener {
    static final String ADD_PROPERTY = "add";
    static final String REMOVE_PROPERTY = "remove";
    private static final int ADD = 0;
    private static final int REMOVE = 1;
    private static final int REMOVE_ALL = 2;
    private static final int FILE_INDEX = 0;
    private static final int SELECTED_INDEX = 1;
    private static final Vector<String> COLUMNS = new Vector(2);
    private JButton addButton;
    private JButton removeButton;
    private JButton removeAllButton;
    private JXTable table;
    private ImportDialog model;

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        this.addButton = new JButton(icons.getIcon(86));
        this.addButton.setToolTipText("Add the selected files to the queue.");
        this.addButton.setEnabled(false);
        this.removeButton = new JButton(icons.getIcon(87));
        this.removeButton.setToolTipText("Remove the selected files from the queue.");
        this.removeButton.setEnabled(false);
        this.removeAllButton = new JButton(icons.getIcon(85));
        this.removeAllButton.setToolTipText("Remove all files from the queue.");
        this.removeAllButton.setEnabled(false);
        this.addButton.setActionCommand("0");
        this.addButton.addActionListener(this);
        this.removeButton.setActionCommand("1");
        this.removeButton.addActionListener(this);
        this.removeAllButton.setActionCommand("2");
        this.removeAllButton.addActionListener(this);
        this.table = new JXTable((TableModel)new FileTableModel(COLUMNS));
        TableColumnModel tcm = this.table.getColumnModel();
        TableColumn tc = tcm.getColumn(1);
        tc.setCellEditor(this.table.getDefaultEditor(Boolean.class));
        tc.setCellRenderer(this.table.getDefaultRenderer(Boolean.class));
        Highlighter h = HighlighterFactory.createAlternateStriping((Color)UIUtilities.BACKGROUND_COLOUR_EVEN, (Color)UIUtilities.BACKGROUND_COLOUR_ODD);
        this.table.addHighlighter(h);
        StringCellRenderer renderer = new StringCellRenderer();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            tcm.getColumn(i).setHeaderRenderer(renderer);
        }
    }

    JPanel buildControls() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        p.add(this.addButton);
        p.add(Box.createVerticalStrut(5));
        p.add(this.removeButton);
        p.add(Box.createVerticalStrut(5));
        p.add(this.removeAllButton);
        return p;
    }

    private JPanel buildTablePane() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        p.add(Box.createVerticalStrut(5));
        p.add(new JScrollPane((Component)this.table));
        return p;
    }

    private void builGUI() {
        double[][] size = new double[][]{{-2.0, 10.0, -1.0}, {-1.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])size));
        this.add((Component)this.buildTablePane(), "2, 0");
    }

    private void removeSelectedFiles() {
        int[] rows = this.table.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        Vector<Vector> v = model.getDataVector();
        for (int i = 0; i < rows.length; ++i) {
            v.remove(rows[i]);
        }
        this.table.repaint();
        int n = this.table.getRowCount();
        this.firePropertyChange(REMOVE_PROPERTY, n - 1, n);
        this.enabledControl(this.table.getRowCount() > 0);
    }

    private void enabledControl(boolean value) {
        this.removeButton.setEnabled(value);
        this.removeAllButton.setEnabled(value);
        if (value) {
            // empty if block
        }
    }

    FileSelectionTable(ImportDialog model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initComponents();
        this.builGUI();
    }

    boolean hasFilesToImport() {
        return this.table.getRowCount() > 0;
    }

    Map<FileElement, Boolean> getFilesToImport() {
        HashMap<FileElement, Boolean> files = new HashMap<FileElement, Boolean>();
        int n = this.table.getRowCount();
        DefaultTableModel dtm = (DefaultTableModel)this.table.getModel();
        int count = this.table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            FileElement element = (FileElement)dtm.getValueAt(i, 0);
            Boolean b = (Boolean)dtm.getValueAt(i, 1);
            files.put(element, b);
        }
        return files;
    }

    void allowAddition(boolean value) {
        this.addButton.setEnabled(value);
    }

    void removeAllFiles() {
        int n = this.table.getRowCount();
        if (n == 0) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.getDataVector().clear();
        this.table.repaint();
        this.firePropertyChange(REMOVE_PROPERTY, -1, 0);
        this.enabledControl(false);
    }

    void addFiles(List<File> files) {
        FileElement element;
        if (files == null || files.size() == 0) {
            return;
        }
        this.addButton.setEnabled(false);
        this.enabledControl(true);
        DefaultTableModel dtm = (DefaultTableModel)this.table.getModel();
        ArrayList<String> inQueue = new ArrayList<String>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            element = (FileElement)dtm.getValueAt(i, 0);
            inQueue.add(element.getFile().getAbsolutePath());
        }
        for (File f : files) {
            if (inQueue.contains(f.getAbsolutePath())) continue;
            element = new FileElement(f);
            element.setName(f.getName());
            dtm.addRow(new Object[]{element, this.model.isArchived()});
        }
    }

    void resetFilesName() {
        int n = this.table.getRowCount();
        if (n == 0) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        for (int i = 0; i < n; ++i) {
            FileElement element = (FileElement)model.getValueAt(i, 0);
            element.setName(element.getFile().getAbsolutePath());
        }
        this.table.repaint();
    }

    void applyToAll() {
        int n = this.table.getRowCount();
        DefaultTableModel dtm = (DefaultTableModel)this.table.getModel();
        for (int i = 0; i < n; ++i) {
            FileElement element = (FileElement)dtm.getValueAt(i, 0);
            if (element.isDirectory()) continue;
            element.setName(this.model.getDisplayedFileName(element.getFile().getAbsolutePath()));
        }
        this.table.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int index = Integer.parseInt(evt.getActionCommand());
        switch (index) {
            case 0: {
                this.firePropertyChange(ADD_PROPERTY, (Object)false, (Object)true);
                break;
            }
            case 1: {
                this.removeSelectedFiles();
                break;
            }
            case 2: {
                this.removeAllFiles();
            }
        }
    }

    static {
        COLUMNS.add("File or Folder");
        COLUMNS.add("Archived");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileTableModel
    extends DefaultTableModel {
        FileTableModel(Vector<String> columns) {
            super(null, columns);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            switch (column) {
                case 0: {
                    return true;
                }
                case 1: {
                    return FileSelectionTable.this.model.canArchived();
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            FileElement f = (FileElement)this.getValueAt(row, 0);
            if (value instanceof String) {
                f.setName((String)value);
            }
            if (value instanceof Boolean) {
                super.setValueAt(value, row, col);
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

