/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.view;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.agents.fsimporter.DataImporterLoader;
import org.openmicroscopy.shoola.agents.fsimporter.DirectoryMonitor;
import org.openmicroscopy.shoola.agents.fsimporter.TagsLoader;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ImportableObject;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import pojos.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImporterModel {
    private int state = 1;
    protected Importer component;
    private DataObject container;
    private DataImporterLoader currentLoader;
    private Collection tags;

    ImporterModel() {
    }

    void initialize(Importer component) {
        this.component = component;
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    void discard() {
        this.cancel();
        this.state = 3;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 2;
    }

    void setContainer(DataObject container) {
        this.container = container;
    }

    DataObject getContainer() {
        return this.container;
    }

    List<FileFilter> getSupportedFormats() {
        return new ArrayList<FileFilter>();
    }

    void fireImportData(ImportableObject data) {
    }

    void fireMonitorDirectory(File directory) {
        if (this.currentLoader != null) {
            this.cancel();
        }
        this.currentLoader = new DirectoryMonitor(this.component, directory, this.container);
        this.currentLoader.load();
        this.state = 4;
    }

    Collection getTags() {
        return this.tags;
    }

    void setTags(Collection tags) {
        this.tags = tags;
    }

    void fireTagsLoading() {
        if (this.tags != null) {
            return;
        }
        TagsLoader loader = new TagsLoader(this.component);
        loader.load();
    }
}

