/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ROIToolAction
extends ViewerAction
implements MouseListener {
    private static final String NAME = "Measurement...";
    private static final String DESCRIPTION = "Bring up the Measurement tool.";
    private Point point;

    protected void onTabSelection() {
        this.setEnabled(this.model.getSelectedIndex() != 2);
    }

    protected void onStateChange(ChangeEvent e) {
        if (this.model.getState() == 6) {
            this.setEnabled(this.model.getSelectedIndex() != 2);
        }
    }

    public ROIToolAction(ImViewer model) {
        super(model, NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager icons = IconManager.getInstance();
        this.putValue("SmallIcon", icons.getIcon(37));
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
    }

    public void mouseReleased(MouseEvent me) {
        Object source = me.getSource();
        if (this.point == null) {
            this.point = me.getPoint();
        }
        if (source instanceof Component && this.isEnabled()) {
            SwingUtilities.convertPointToScreen(this.point, (Component)source);
            this.model.showMeasurementTool(this.point);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

