/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.util.saver.ImgSaver;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class SaveAction
extends ViewerAction {
    private static final String NAME = "Save As...";
    public static final String DESCRIPTION = "Save the image as TIFF, JPEG, PNG, etc.";

    protected void onTabSelection() {
        this.setEnabled(true);
    }

    protected void onStateChange(ChangeEvent e) {
        if (this.model.getState() == 6) {
            this.onTabSelection();
        } else {
            this.setEnabled(false);
        }
    }

    public SaveAction(ImViewer model) {
        super(model, NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager icons = IconManager.getInstance();
        this.putValue("SmallIcon", icons.getIcon(2));
    }

    public void actionPerformed(ActionEvent e) {
        int index = 2;
        if (this.model.getMaxC() > 1 && !this.model.isBigImage()) {
            index = 1;
        }
        if (this.model.hasLens()) {
            index = 0;
        }
        int value = 0;
        switch (this.model.getSelectedIndex()) {
            case 2: {
                value = 2;
                break;
            }
            case 1: {
                value = 1;
            }
        }
        ImgSaver saver = new ImgSaver(this.model.getUI(), this.model, index, value, this.model.includeROI());
        UIUtilities.setLocationRelativeToAndShow(this.model.getUI(), saver);
    }
}

