/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.GLUT;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLJPanel;
import javax.media.opengl.glu.GLU;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;

class GLImageCanvas
extends GLJPanel
implements GLEventListener {
    static final int FONT = 6;
    private static GLCapabilities CAPS = new GLCapabilities();
    protected GLU glu;
    protected GLUT glut;
    protected BrowserModel model;
    protected BrowserUI view;
    protected Texture texture;
    protected String paintedString;
    protected boolean savedFile;
    protected BufferedImage image;

    private int[] copyFrame(GL gl) {
        Dimension s = this.getSize();
        int w = s.width;
        int h = s.height;
        ByteBuffer buffer = BufferUtil.newByteBuffer((int)(w * h * 3));
        gl.glReadBuffer(1029);
        gl.glPixelStorei(3333, 1);
        gl.glReadPixels(0, 0, w, h, 6407, 5121, (Buffer)buffer);
        int[] pixels = new int[w * h];
        int p = w * h * 3;
        int i = 0;
        int w3 = w * 3;
        for (int row = 0; row < h; ++row) {
            int q = p -= w3;
            for (int col = 0; col < w; ++col) {
                byte r = buffer.get(q++);
                byte g = buffer.get(q++);
                byte b = buffer.get(q++);
                pixels[i++] = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
            }
        }
        return pixels;
    }

    protected void saveDisplayedImage(GL gl) {
        if (gl == null || this.savedFile) {
            return;
        }
        Dimension s = this.getSize();
        int w = s.width;
        int h = s.height;
        this.image = new BufferedImage(w, h, 2);
        this.image.setRGB(0, 0, w, h, this.copyFrame(gl), 0, w);
        this.savedFile = false;
    }

    protected void drawScaleBar(GL gl, int width) {
        float s = (float)this.model.getOriginalUnitBarSize() / (float)width;
        Color c = this.model.getUnitBarColor();
        gl.glColor3f((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
        float x1 = 0.99f - s;
        float x2 = 0.99f;
        float y1 = 0.98f;
        float y2 = 0.983f;
        if (this.model.getZoomFactor() > 0.25) {
            String text = this.model.getUnitBarValue();
            int length = 0;
            if (text != null) {
                length = this.getFontMetrics(this.getFont()).stringWidth(text);
            }
            float t = (float)length / (float)width;
            float xText = x1 + (s - t) / 2.0f + 0.01f;
            float yText = 0.97f;
            gl.glRasterPos2f(xText, yText);
            this.glut.glutBitmapString(6, text);
        }
        gl.glBegin(9);
        gl.glVertex3f(x1, y1, 0.0f);
        gl.glVertex3f(x2, y1, 0.0f);
        gl.glVertex3f(x2, y2, 0.0f);
        gl.glVertex3f(x1, y2, 0.0f);
        gl.glEnd();
    }

    protected void onDisplay(GLAutoDrawable drawable, TextureData data) {
        GL gl = drawable.getGL();
        gl.glClear(16640);
        if (data == null) {
            return;
        }
        if (this.texture == null) {
            this.texture = TextureIO.newTexture((TextureData)data);
        } else {
            this.texture.updateImage(data);
        }
        if (this.texture != null) {
            float x = 1.0f;
            float y = 1.0f;
            if (this.model.isUnitBar()) {
                this.drawScaleBar(gl, data.getWidth());
            }
            this.texture.enable();
            this.texture.bind();
            gl.glTexEnvi(8960, 8704, 7681);
            TextureCoords coords = new TextureCoords(0.0f, 0.0f, 1.0f, 1.0f);
            Color c = Color.green;
            gl.glColor3f((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
            gl.glBegin(7);
            gl.glTexCoord2f(coords.left(), coords.bottom());
            gl.glVertex3f(0.0f, 0.0f, 0.0f);
            gl.glTexCoord2f(coords.right(), coords.bottom());
            gl.glVertex3d((double)x, 0.0, 0.0);
            gl.glTexCoord2f(coords.right(), coords.top());
            gl.glVertex3f(x, y, 0.0f);
            gl.glTexCoord2f(coords.left(), coords.top());
            gl.glVertex3f(0.0f, y, 0.0f);
            gl.glEnd();
            this.saveDisplayedImage(gl);
            this.texture.disable();
            gl.glFlush();
        }
    }

    GLImageCanvas(BrowserModel model, BrowserUI view) {
        super(CAPS, null, null);
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.model = model;
        this.view = view;
        this.setOpaque(true);
        this.glu = new GLU();
        this.glut = new GLUT();
        this.addGLEventListener(this);
        this.paintedString = null;
    }

    BufferedImage getImageToSave() {
        return this.image;
    }

    void activeSave() {
        this.savedFile = true;
    }

    void setPaintedString(int pressedZ, int pressedT) {
        this.paintedString = pressedZ < 0 || pressedT < 0 ? null : "z=" + pressedZ + ", t=" + pressedT;
        this.repaint();
    }

    public void init(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        Color c = this.getBackground();
        if (c == null) {
            c = Color.LIGHT_GRAY;
        }
        float[] array = new float[4];
        array = c.getRGBColorComponents(array);
        gl.glClearColor(array[0], array[1], array[2], array[3]);
        gl.glEnable(2929);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glScaled(1.0, -1.0, 1.0);
        this.glu.gluOrtho2D(0.0, 1.0, 0.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL gl = drawable.getGL();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glScaled(1.0, -1.0, 1.0);
        this.glu.gluOrtho2D(0.0, 1.0, 0.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    public void display(GLAutoDrawable drawable) {
    }

    public void dispose(GLAutoDrawable drawable) {
    }

    public void displayChanged(GLAutoDrawable drawable, boolean a, boolean b) {
    }

    static {
        CAPS.setAlphaBits(8);
        CAPS.setRedBits(8);
        CAPS.setGreenBits(8);
        CAPS.setBlueBits(8);
    }
}

