/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserBICanvas;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;

class ImageCanvasListener
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final Point DEFAULT_POINT = new Point(0, 0);
    private BrowserModel model;
    private BrowserUI view;
    private JComponent canvas;
    private boolean mouseOnCanvas;
    private Rectangle area;
    private Point pressedPoint;
    private boolean handleKeyDown;

    ImageCanvasListener(BrowserUI view, BrowserModel model, JComponent canvas) {
        if (model == null) {
            throw new NullPointerException("No Model.");
        }
        if (canvas == null) {
            throw new NullPointerException("No canvas.");
        }
        if (view == null) {
            throw new NullPointerException("No View.");
        }
        this.model = model;
        this.canvas = canvas;
        this.view = view;
        this.area = new Rectangle(0, 0, 0, 0);
        canvas.addMouseWheelListener(this);
        this.handleKeyDown = false;
    }

    void setHandleKeyDown(boolean handleKeyDown) {
        this.handleKeyDown = handleKeyDown;
    }

    void setAreaSize(int width, int height) {
        this.area.setBounds(0, 0, width, height);
    }

    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
        if (this.handleKeyDown) {
            if (e.isShiftDown()) {
                SwingUtilities.convertPointToScreen(p, this.canvas);
                if (p.y < this.pressedPoint.y) {
                    this.model.zoom(true);
                } else if (p.y > this.pressedPoint.y) {
                    this.model.zoom(false);
                }
                this.pressedPoint = p;
                return;
            }
            if (e.isAltDown()) {
                SwingUtilities.convertPointToScreen(p, this.canvas);
                int vMove = p.y - this.pressedPoint.y;
                int hMove = p.x - this.pressedPoint.x;
                this.view.scrollTo(vMove, hMove);
                this.pressedPoint = p;
                return;
            }
        }
        int maxZ = this.model.getMaxZ();
        int maxT = this.model.getMaxT();
        if (maxZ <= 0 && maxT <= 0) {
            return;
        }
        int pressedZ = -1;
        int pressedT = -1;
        pressedZ = p.y * maxZ / this.area.height;
        if (pressedZ < 0) {
            return;
        }
        if ((pressedZ = maxZ - pressedZ) > maxZ) {
            pressedZ = -1;
        }
        if ((pressedT = p.x * maxT / this.area.width) < 0) {
            return;
        }
        if (pressedT > maxT) {
            return;
        }
        this.model.setSelectedXYPlane(pressedZ, pressedT);
        if (this.canvas instanceof BrowserBICanvas) {
            ((BrowserBICanvas)this.canvas).setPaintedString(pressedZ, pressedT);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.pressedPoint = e.getPoint();
        SwingUtilities.convertPointToScreen(this.pressedPoint, this.canvas);
        if (this.canvas instanceof BrowserBICanvas) {
            ((BrowserBICanvas)this.canvas).setPaintedString(this.model.getDefaultZ(), this.model.getDefaultT());
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.pressedPoint = DEFAULT_POINT;
        SwingUtilities.convertPointToScreen(this.pressedPoint, this.canvas);
        if (this.canvas instanceof BrowserBICanvas) {
            ((BrowserBICanvas)this.canvas).setPaintedString(-1, -1);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (!this.mouseOnCanvas) {
            return;
        }
        int maxZ = this.model.getMaxZ();
        int maxT = this.model.getMaxT();
        if (maxZ <= 0 && maxT <= 0) {
            return;
        }
        boolean up = true;
        if (e.getWheelRotation() > 0) {
            up = false;
        }
        if (e.getScrollType() == 0) {
            int v = this.model.getDefaultZ() - e.getWheelRotation();
            if (up) {
                if (v <= maxZ) {
                    this.model.setSelectedXYPlane(v, -1);
                    if (this.canvas instanceof BrowserBICanvas) {
                        ((BrowserBICanvas)this.canvas).setPaintedString(v, this.model.getDefaultT());
                    }
                } else if (this.canvas instanceof BrowserBICanvas) {
                    ((BrowserBICanvas)this.canvas).setPaintedString(-1, -1);
                }
            } else if (v >= 0) {
                this.model.setSelectedXYPlane(v, -1);
                if (this.canvas instanceof BrowserBICanvas) {
                    ((BrowserBICanvas)this.canvas).setPaintedString(v, this.model.getDefaultT());
                }
            } else if (this.canvas instanceof BrowserBICanvas) {
                ((BrowserBICanvas)this.canvas).setPaintedString(-1, -1);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseOnCanvas = this.area.contains(e.getPoint());
    }

    public void mouseExited(MouseEvent e) {
        this.mouseOnCanvas = false;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

