/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class InfoPane
extends JPanel {
    private static final String MICRONS = "(in \u00b5)";
    private static final String SIZE_X = "Size X";
    private static final String SIZE_Y = "Size Y";
    private static final String PIXEL_SIZE_X = "Pixel size X (in \u00b5)";
    private static final String PIXEL_SIZE_Y = "Pixel size Y (in \u00b5)";
    private static final String PIXEL_SIZE_Z = "Pixel size Z (in \u00b5)";
    private BrowserModel model;
    private boolean build;

    private JTextField createTextField(String value) {
        JTextField area = new JTextField(value);
        area.setEditable(false);
        return area;
    }

    InfoPane(BrowserModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.build = false;
    }

    void buildGUI() {
        if (this.build) {
            return;
        }
        this.build = true;
        double[][] tl = new double[][]{{-1.0, 5.0, 100.0}, {-1.0, 5.0, -1.0, 5.0, -1.0, 5.0, -1.0, 5.0, -1.0}};
        JPanel content = new JPanel();
        content.setLayout((LayoutManager)new TableLayout((double[][])tl));
        JLabel label = UIUtilities.setTextFont(SIZE_X);
        content.add((Component)label, "0, 0");
        JTextField area = this.createTextField("" + this.model.getMaxX());
        content.add((Component)area, "2, 0");
        label = UIUtilities.setTextFont(SIZE_Y);
        content.add((Component)label, "0, 2");
        area = this.createTextField("" + this.model.getMaxY());
        content.add((Component)area, "2, 2");
        label = UIUtilities.setTextFont(PIXEL_SIZE_X);
        content.add((Component)label, "0, 4");
        area = this.createTextField("" + this.model.getPixelsSizeX());
        content.add((Component)area, "2, 4");
        label = UIUtilities.setTextFont(PIXEL_SIZE_Y);
        content.add((Component)label, "0, 6");
        area = this.createTextField("" + this.model.getPixelsSizeY());
        content.add((Component)area, "2, 6");
        label = UIUtilities.setTextFont(PIXEL_SIZE_Z);
        content.add((Component)label, "0, 8");
        area = this.createTextField("" + this.model.getPixelsSizeZ());
        content.add((Component)area, "2, 8");
        this.setLayout(new FlowLayout(1));
        this.add(content);
    }
}

