/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.actions.MeasurementViewerAction;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class DeleteROIAction
extends MeasurementViewerAction {
    private static final String NAME = "Delete ROI";
    private static final String DESCRIPTION = "Delete all your ROIs on this image.";

    protected void onStateChange() {
        if (this.model.getState() == 5) {
            this.setEnabled(this.model.isImageWritable() && this.model.hasROIToDelete());
        } else {
            this.setEnabled(false);
        }
    }

    public DeleteROIAction(MeasurementViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager icons = IconManager.getInstance();
        this.putValue("SmallIcon", icons.getIcon(43));
    }

    public void actionPerformed(ActionEvent e) {
        MessageBox msg = new MessageBox(this.model.getUI(), NAME, "Do you want to delete all your ROIs on this image.");
        int option = msg.centerMsgBox();
        if (option == 1) {
            this.model.deleteAllROIs();
        }
    }
}

