/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelSummaryModel
extends AbstractTableModel {
    private Double[][] data;
    private int numColumns;
    private int numRows;
    private List<String> columnNames;
    private List<String> rowNames;

    public ChannelSummaryModel(List<String> rowNames, List<String> columnNames, Double[][] data) {
        this.data = data;
        this.rowNames = rowNames;
        this.columnNames = columnNames;
        this.setColumnCount(columnNames.size());
        this.setRowCount(rowNames.size());
        this.numColumns = columnNames.size() + 1;
        this.numRows = rowNames.size();
    }

    public List<String> getRowNames() {
        return this.rowNames;
    }

    @Override
    public int getColumnCount() {
        return this.numColumns;
    }

    @Override
    public int getRowCount() {
        return this.numRows;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "";
        }
        return this.columnNames.get(col - 1);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col >= this.numColumns || row >= this.numRows) {
            return null;
        }
        if (col == 0) {
            return this.rowNames.get(row);
        }
        if (this.data[col - 1][row] != null) {
            return UIUtilities.formatToDecimal(this.data[col - 1][row]);
        }
        return null;
    }

    public void setColumnCount(int col) {
        this.numColumns = col;
    }

    public void setRowCount(int row) {
        this.numRows = row;
    }
}

