/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jhotdraw.draw.AttributeKey;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.model.AttributeField;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKey;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FigureTableModel
extends AbstractTableModel {
    private static final String NA = "N/A";
    private ROIFigure figure;
    private List<String> columnNames;
    private List<AttributeKey> keys;
    private List values;
    private List<AttributeField> fieldList;

    public FigureTableModel(List<AttributeField> fieldList, List<String> columnNames) {
        if (fieldList == null) {
            throw new IllegalArgumentException("No fields specified.");
        }
        if (columnNames == null) {
            throw new IllegalArgumentException("No column's names specified.");
        }
        this.fieldList = fieldList;
        this.columnNames = columnNames;
        this.keys = new ArrayList<AttributeKey>();
        this.values = new ArrayList();
    }

    public void clearData() {
        this.keys.clear();
        this.values.clear();
        this.fireTableDataChanged();
    }

    public void setData(ROIFigure figure) {
        if (figure == null) {
            throw new IllegalArgumentException("No figure.");
        }
        this.figure = figure;
        this.keys.clear();
        this.values.clear();
        for (AttributeField fieldName : this.fieldList) {
            AttributeKey key2;
            boolean found = false;
            for (AttributeKey key2 : figure.getAttributes().keySet()) {
                if (!key2.equals((Object)fieldName.getKey())) continue;
                if (MeasurementAttributes.TEXT.equals((Object)key2) || MeasurementAttributes.WIDTH.equals((Object)key2) || MeasurementAttributes.HEIGHT.equals((Object)key2)) {
                    fieldName.setEditable(!figure.isReadOnly());
                }
                this.keys.add(key2);
                this.values.add(figure.getAttribute(key2));
                found = true;
                break;
            }
            if (found) continue;
            key2 = fieldName.getKey();
            this.keys.add(key2);
            if (AnnotationKeys.NAMESPACE.equals(key2)) {
                this.values.add(EditorUtil.getWorkflowForDisplay((String)figure.getROI().getAnnotation((AnnotationKey)key2)));
                continue;
            }
            if (key2 instanceof AnnotationKey) {
                this.values.add(figure.getROI().getAnnotation((AnnotationKey)key2));
                continue;
            }
            this.values.add(NA);
        }
        this.fireTableDataChanged();
    }

    public ROIFigure getFigure() {
        return this.figure;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames.get(col);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public int getRowCount() {
        return this.keys.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.fieldList.get(rowIndex).getName();
        }
        return this.values.get(rowIndex);
    }

    public AttributeField getFieldAt(int rowIndex) {
        return this.fieldList.get(rowIndex);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            return;
        }
        AttributeKey key = this.keys.get(row);
        if (this.figure.getAttribute(key) instanceof Double) {
            if (value instanceof Double) {
                this.figure.setAttribute(this.keys.get(row), (Double)value);
            }
            if (value instanceof String) {
                try {
                    this.figure.setAttribute(this.keys.get(row), new Double((String)value));
                }
                catch (Exception e) {
                    MeasurementAgent.getRegistry().getUserNotifier().notifyInfo("Value for field invalid", "The value of " + value + " is invalid for " + key.toString());
                    return;
                }
            }
        } else {
            this.figure.setAttribute(this.keys.get(row), value);
        }
        this.values.set(row, value);
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        if (this.values.get(row) instanceof String && NA.equals(this.values.get(row))) {
            return false;
        }
        return this.fieldList.get(row).isEditable();
    }
}

