/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.workflow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.util.workflow.CreateWorkflowDialog;
import org.openmicroscopy.shoola.agents.measurement.util.workflow.WorkflowModel;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.WorkflowData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WorkflowView
implements ActionListener,
ListSelectionListener {
    private static String DIALOGTITLE = "New Workflow Dialog";
    private static String SAVEACTION = "Save";
    private static String DELETEACTION = "Delete";
    private static String CANCELACTION = "Cancel";
    private static String CLOSEACTION = "Close";
    private static String CREATEACTION = "Create";
    private CreateWorkflowDialog parent;
    private JDialog dialog;
    private WorkflowModel model;
    private JList workflowList;
    private JButton saveButton;
    private JButton createButton;
    private JButton cancelButton;
    private JButton deleteButton;
    private JButton closeButton;
    private JTextField namespaceText;
    private JTextArea keywordsText;
    private WorkflowData currentWorkflow;
    private boolean newWorkflow;

    private void init(CreateWorkflowDialog parent, WorkflowModel model) {
        this.parent = parent;
        this.model = model;
        this.currentWorkflow = null;
        this.newWorkflow = false;
    }

    private void buildUI(WorkflowModel model) {
        this.dialog = new JDialog();
        this.dialog.setTitle(DIALOGTITLE);
        this.dialog.setSize(650, 400);
        this.dialog.setModal(true);
        this.dialog.getContentPane().add(this.createContent());
    }

    private JPanel createContent() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.createInfoPanel());
        panel.add(this.createWorkflowPanel());
        panel.add(this.createButtonPanel());
        return panel;
    }

    private JPanel createInfoPanel() {
        TitlePanel infoPanel = new TitlePanel("Workflow Assistant", "The Workflow Assistant allows the creation of new workflows  \nto annotate ROI as being for a particular class andkeywords \n Defining the subclasses.", IconManager.getInstance().getIcon(10));
        return infoPanel;
    }

    private JPanel createWorkflowPanel() {
        JPanel workflowPanel = new JPanel();
        workflowPanel.setLayout(new BoxLayout(workflowPanel, 0));
        workflowPanel.add(this.createWorkflowListPanel());
        workflowPanel.add(this.createWorkflowKeywordsPanel());
        return workflowPanel;
    }

    private JPanel createWorkflowListPanel() {
        JPanel workflowListPanel = new JPanel();
        JPanel namespacePanel = new JPanel();
        namespacePanel.setLayout(new BoxLayout(namespacePanel, 0));
        JLabel namespaceLabel = new JLabel("Namespace");
        namespacePanel.add(namespaceLabel);
        namespacePanel.add(Box.createHorizontalGlue());
        workflowListPanel.setSize(new Dimension(150, 400));
        workflowListPanel.setLayout(new BoxLayout(workflowListPanel, 1));
        workflowListPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.workflowList = new JList();
        this.workflowList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.workflowList.setModel(this.model.getListModel());
        this.workflowList.addListSelectionListener(this);
        workflowListPanel.add(namespacePanel);
        workflowListPanel.add(this.workflowList);
        workflowListPanel.add(Box.createVerticalGlue());
        return workflowListPanel;
    }

    private JPanel createWorkflowKeywordsPanel() {
        JPanel panel = new JPanel();
        JLabel namespaceLabel = new JLabel("Namespace");
        JLabel keywordsLabel = new JLabel("Keywords");
        this.namespaceText = new JTextField();
        this.keywordsText = new JTextArea();
        this.keywordsText.setBorder(BorderFactory.createLoweredBevelBorder());
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel namespacePanel = new JPanel();
        namespacePanel.setLayout(new BoxLayout(namespacePanel, 0));
        namespacePanel.add(namespaceLabel);
        namespacePanel.add(Box.createHorizontalGlue());
        JPanel keywordsPanel = new JPanel();
        keywordsPanel.setLayout(new BoxLayout(keywordsPanel, 0));
        keywordsPanel.add(keywordsLabel);
        keywordsPanel.add(Box.createHorizontalGlue());
        JPanel nsPanel = new JPanel();
        nsPanel.setLayout(new BorderLayout());
        nsPanel.add((Component)this.namespaceText, "Center");
        JPanel keyPanel = new JPanel();
        keyPanel.setLayout(new BoxLayout(keyPanel, 0));
        keyPanel.add(this.keywordsText);
        panel.add(namespacePanel);
        panel.add(nsPanel);
        panel.add(Box.createVerticalGlue());
        panel.add(keywordsPanel);
        panel.add(keyPanel);
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        this.saveButton = new JButton(SAVEACTION);
        this.saveButton.addActionListener(this);
        this.deleteButton = new JButton(DELETEACTION);
        this.deleteButton.addActionListener(this);
        this.cancelButton = new JButton(CANCELACTION);
        this.cancelButton.addActionListener(this);
        this.closeButton = new JButton(CLOSEACTION);
        this.closeButton.addActionListener(this);
        this.createButton = new JButton(CREATEACTION);
        this.createButton.addActionListener(this);
        panel.setLayout(new BoxLayout(panel, 2));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        panel.add(Box.createHorizontalGlue());
        panel.add(this.createButton);
        panel.add(Box.createRigidArea(new Dimension(10, 0)));
        panel.add(this.saveButton);
        panel.add(Box.createRigidArea(new Dimension(10, 0)));
        panel.add(this.deleteButton);
        panel.add(Box.createRigidArea(new Dimension(10, 0)));
        panel.add(this.cancelButton);
        panel.add(Box.createRigidArea(new Dimension(10, 0)));
        panel.add(this.closeButton);
        return panel;
    }

    private void saveAction() {
        if (this.currentWorkflow == null) {
            return;
        }
        this.currentWorkflow.setKeywords(this.CSVToList(this.keywordsText.getText()));
        if (this.newWorkflow) {
            this.currentWorkflow.setNamespace(this.namespaceText.getText());
            this.model.addItem(this.currentWorkflow);
        }
    }

    private void deleteAction() {
    }

    private void cancelAction() {
        this.parent.cancel();
    }

    private void closeAction() {
        this.dialog.setVisible(false);
    }

    private List<String> CSVToList(String str) {
        String[] valueString;
        ArrayList<String> list = new ArrayList<String>();
        for (String keyword : valueString = str.split(",")) {
            if (keyword.equals("[]")) continue;
            list.add(keyword);
        }
        return list;
    }

    WorkflowView(CreateWorkflowDialog parent, WorkflowModel model) {
        this.init(parent, model);
        this.buildUI(model);
    }

    public void show() {
        UIUtilities.centerAndShow(this.dialog);
    }

    private void createAction() {
        this.currentWorkflow = new WorkflowData();
        this.newWorkflow = true;
    }

    private void setNamespaceKeywords() {
        this.newWorkflow = false;
        this.namespaceText.setText(this.currentWorkflow.getNameSpace());
        this.keywordsText.setText(this.currentWorkflow.getKeywords());
    }

    private void clearNamespaceKeywordsFields() {
        this.currentWorkflow = null;
        this.newWorkflow = false;
        this.namespaceText.setText("");
        this.keywordsText.setText("");
    }

    private void clearWorkflowSelection() {
        if (this.currentWorkflow != null && this.currentWorkflow.isDirty()) {
            String action = this.checkToClear();
            if (action == CANCELACTION) {
                return;
            }
            if (action == SAVEACTION) {
                this.saveAction();
            }
        }
        this.clearNamespaceKeywordsFields();
    }

    private void setWorkflowSelection(int index) {
        this.currentWorkflow = this.model.getItem(index);
        this.setNamespaceKeywords();
    }

    private String checkToClear() {
        int result = JOptionPane.showConfirmDialog(this.dialog, "Do you want to save the workflow?", "Save confirmation", 1, 3);
        if (result == 2) {
            return CANCELACTION;
        }
        if (result == 0) {
            return SAVEACTION;
        }
        return DELETEACTION;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == SAVEACTION) {
            this.saveAction();
        } else if (cmd == DELETEACTION) {
            this.deleteAction();
        } else if (cmd == CANCELACTION) {
            this.cancelAction();
        } else if (cmd == CLOSEACTION) {
            this.closeAction();
        } else if (cmd == CREATEACTION) {
            this.createAction();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.workflowList.getSelectedIndex() == -1) {
                this.clearWorkflowSelection();
            } else {
                this.setWorkflowSelection(this.workflowList.getSelectedIndex());
            }
        }
    }
}

