/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.model.AttributeField;
import org.openmicroscopy.shoola.agents.measurement.util.model.FigureTableModel;
import org.openmicroscopy.shoola.agents.measurement.util.ui.FigureTable;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ObjectInspector
extends JPanel {
    public static final int INDEX = 0;
    private static final List<String> COLUMN_NAMES = new ArrayList<String>(2);
    private static final int SHOW_TEXT_ROW = 3;
    private static final int SHOW_MEASUREMENT_ROW = 4;
    private static final String NAME = "Inspector";
    private FigureTable fieldTable;
    private MeasurementViewerControl controller;
    private MeasurementViewerModel model;

    private void initComponents() {
        ArrayList<AttributeField> l = new ArrayList<AttributeField>();
        l.add(new AttributeField(MeasurementAttributes.TEXT, "Text", true));
        l.add(new AttributeField(MeasurementAttributes.WIDTH, "Width", true));
        l.add(new AttributeField(MeasurementAttributes.HEIGHT, "Height", true));
        l.add(new AttributeField(MeasurementAttributes.SHOWTEXT, "Show Text", false));
        l.add(new AttributeField(MeasurementAttributes.SHOWMEASUREMENT, "Show Measurements", false));
        l.add(new AttributeField(MeasurementAttributes.FILL_COLOR, "Fill Colour", false));
        l.add(new AttributeField(MeasurementAttributes.STROKE_COLOR, "Line Colour", false));
        this.fieldTable = new FigureTable(new FigureTableModel(l, COLUMN_NAMES));
        this.fieldTable.getTableHeader().setReorderingAllowed(false);
        this.fieldTable.setRowHeight(26);
        this.fieldTable.setSelectionMode(0);
        this.fieldTable.setCellSelectionEnabled(true);
        this.fieldTable.setColumnSelectionAllowed(true);
        this.fieldTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int col = ObjectInspector.this.fieldTable.getSelectedColumn();
                int row = ObjectInspector.this.fieldTable.getSelectedRow();
                Object value = ObjectInspector.this.fieldTable.getValueAt(row, col);
                if (e.getClickCount() == 1) {
                    if (value instanceof Boolean) {
                        ObjectInspector.this.toggleValue();
                    }
                } else if (e.getClickCount() > 1) {
                    e.consume();
                    if (value instanceof Color) {
                        FigureTableModel ftm = (FigureTableModel)ObjectInspector.this.fieldTable.getModel();
                        ROIFigure figure = ftm.getFigure();
                        if (figure != null && !figure.isReadOnly()) {
                            ObjectInspector.this.controller.showColorPicker((Color)value);
                        }
                    } else if (value instanceof Boolean) {
                        ObjectInspector.this.toggleValue();
                    }
                }
            }
        });
    }

    private List<Double> strokeRange() {
        ArrayList<Double> sRange = new ArrayList<Double>();
        sRange.add(new Double(0.5));
        sRange.add(new Double(0.75));
        sRange.add(new Double(1.0));
        sRange.add(new Double(2.0));
        sRange.add(new Double(3.0));
        sRange.add(new Double(4.0));
        return sRange;
    }

    private List<Double> fontRange() {
        ArrayList<Double> fRange = new ArrayList<Double>();
        fRange.add(new Double(4.0));
        fRange.add(new Double(8.0));
        fRange.add(new Double(10.0));
        fRange.add(new Double(12.0));
        fRange.add(new Double(16.0));
        fRange.add(new Double(24.0));
        return fRange;
    }

    private void toggleValue() {
        int col = this.fieldTable.getSelectedColumn();
        int row = this.fieldTable.getSelectedRow();
        Boolean value = (Boolean)this.fieldTable.getModel().getValueAt(row, col);
        boolean newValue = value == false;
        this.fieldTable.getModel().setValueAt(newValue, row, col);
        this.model.getDrawingView().repaint();
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.fieldTable), "Center");
    }

    ObjectInspector(MeasurementViewerControl controller, MeasurementViewerModel model) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(1);
    }

    void setCellColor(Color c) {
        int col = this.fieldTable.getSelectedColumn();
        int row = this.fieldTable.getSelectedRow();
        this.fieldTable.getModel().setValueAt(c, row, col);
    }

    boolean isShowText() {
        if (this.fieldTable == null) {
            return false;
        }
        int n = this.fieldTable.getRowCount();
        if (n > 3) {
            return (Boolean)this.fieldTable.getModel().getValueAt(3, 1);
        }
        return false;
    }

    boolean isShowMeasurement() {
        if (this.fieldTable == null) {
            return false;
        }
        int n = this.fieldTable.getRowCount();
        if (n > 4) {
            return (Boolean)this.fieldTable.getModel().getValueAt(4, 1);
        }
        return false;
    }

    void setModelData(ROIFigure figure) {
        FigureTableModel tableModel = (FigureTableModel)this.fieldTable.getModel();
        tableModel.setData(figure);
        this.fieldTable.repaint();
    }

    void removeROIFigure(ROIFigure figure) {
        if (figure == null) {
            return;
        }
        FigureTableModel tm = (FigureTableModel)this.fieldTable.getModel();
        ROIFigure value = tm.getFigure();
        if (value == null) {
            return;
        }
        if (value.getROI().getID() == figure.getROI().getID()) {
            tm.clearData();
        }
    }

    void removeROIFigures(List<ROIFigure> figures) {
        if (figures == null || figures.size() == 0) {
            return;
        }
        FigureTableModel tm = (FigureTableModel)this.fieldTable.getModel();
        ROIFigure value = tm.getFigure();
        if (value == null) {
            return;
        }
        for (ROIFigure figure : figures) {
            if (value.getROI().getID() != figure.getROI().getID()) continue;
            tm.clearData();
        }
        this.fieldTable.repaint();
    }

    void setSelectedFigures(List<ROIShape> l) {
        FigureTableModel tableModel = (FigureTableModel)this.fieldTable.getModel();
        Iterator<ROIShape> i = l.iterator();
        try {
            TableCellEditor editor = this.fieldTable.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            while (i.hasNext()) {
                ROIShape shape = i.next();
                tableModel.setData(shape.getFigure());
                this.fieldTable.repaint();
            }
        }
        catch (Exception e) {
            MeasurementAgent.getRegistry().getLogger().info((Object)this, "Figures selection" + e);
        }
    }

    static {
        COLUMN_NAMES.add("Field");
        COLUMN_NAMES.add("Value");
    }
}

