/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.agents.measurement.view.StatusBar;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import pojos.WorkflowData;

class WorkflowDialog
extends JDialog
implements ActionListener {
    private MeasurementViewerUI view;
    private MeasurementViewerModel model;
    private JLabel namespaceLabel;
    private JLabel keywordsLabel;
    private JTextField namespace;
    private JTextField keywords;
    private JButton createButton;
    private JButton cancelButton;
    private StatusBar statusBar;

    private void init() {
        this.namespaceLabel = new JLabel("Namespace");
        this.keywordsLabel = new JLabel("Keywords");
        this.namespace = new JTextField();
        this.keywords = new JTextField();
        this.createButton = new JButton("Create");
        this.createButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.statusBar = new StatusBar();
    }

    private void buildUI() {
        this.setSize(500, 350);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.namespaceLabel);
        panel.add(Box.createVerticalGlue());
        Dimension d = new Dimension(300, 30);
        this.namespace.setSize(d);
        this.namespace.setMaximumSize(d);
        this.namespace.setMinimumSize(d);
        panel.add(this.wrap(this.namespace, d));
        panel.add(Box.createVerticalGlue());
        panel.add(this.keywordsLabel);
        panel.add(Box.createVerticalGlue());
        d = new Dimension(300, 80);
        panel.add(this.wrap(this.keywords, d));
        panel.add(Box.createVerticalGlue());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.createButton);
        buttonPanel.add(this.cancelButton);
        panel.add(buttonPanel);
        panel.add(this.statusBar);
        Container container = this.getContentPane();
        container.add((Component)this.createInfoPanel(), "North");
        container.add((Component)panel, "Center");
    }

    private JPanel wrap(JComponent comp, Dimension d) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalStrut(10));
        panel.add(comp);
        panel.add(Box.createHorizontalStrut(10));
        panel.setMaximumSize(d);
        panel.setSize(d);
        panel.setMinimumSize(d);
        return panel;
    }

    private JPanel createInfoPanel() {
        TitlePanel infoPanel = new TitlePanel("Workflow Panel", "The workflow panel allows you to create a new workflow\n that associates a namespace and keywords with an ROI.\nThe keywords should be separated by  a comma e.g. interphase, metaphase, anaphase", IconManager.getInstance().getIcon(10));
        return infoPanel;
    }

    private void createWorkflow() {
        WorkflowData workflow = new WorkflowData(this.namespace.getText(), this.keywords.getText());
        this.model.addWorkflow(workflow);
        this.view.updateWorkflow();
        this.statusBar.setStatus("Workflow " + this.namespace.getText() + " created.");
        this.clearFields();
    }

    private void clearFields() {
        this.namespace.setText("");
        this.keywords.setText("");
    }

    WorkflowDialog(MeasurementViewerUI view, MeasurementViewerModel model) {
        this.view = view;
        this.model = model;
        this.init();
        this.buildUI();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Create") {
            this.createWorkflow();
        }
    }
}

