/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.AdminView;
import org.openmicroscopy.shoola.env.data.views.DataManagerView;
import org.openmicroscopy.shoola.env.data.views.ImageDataView;
import org.openmicroscopy.shoola.env.data.views.MetadataHandlerView;
import org.openmicroscopy.shoola.env.log.LogMessage;
import pojos.ExperimenterData;

public abstract class EditorLoader
extends DSCallAdapter {
    protected final Editor viewer;
    protected final Registry registry;
    protected final MetadataHandlerView mhView;
    protected final DataManagerView dmView;
    protected final ImageDataView imView;
    protected final AdminView adminView;
    protected long userID;
    protected long groupID;

    void setIds() {
        ExperimenterData exp = MetadataViewerAgent.getUserDetails();
        this.userID = this.viewer.getUserID();
        this.groupID = exp.getDefaultGroup().getId();
        int level = MetadataViewerAgent.getRegistry().getAdminService().getPermissionLevel();
        switch (level) {
            case 102: 
            case 104: {
                this.userID = -1L;
            }
        }
    }

    public EditorLoader(Editor viewer) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        this.viewer = viewer;
        this.registry = MetadataViewerAgent.getRegistry();
        this.mhView = (MetadataHandlerView)this.registry.getDataServicesView(MetadataHandlerView.class);
        this.dmView = (DataManagerView)this.registry.getDataServicesView(DataManagerView.class);
        this.imView = (ImageDataView)this.registry.getDataServicesView(ImageDataView.class);
        this.adminView = (AdminView)this.registry.getDataServicesView(AdminView.class);
        this.userID = -1L;
        this.groupID = -1L;
    }

    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
    }

    public void handleException(Throwable exc) {
        this.viewer.setStatus(false);
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
    }

    public abstract void load();

    public abstract void cancel();
}

