/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerFactory;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.UserGroupSwitched;
import org.openmicroscopy.shoola.env.data.util.AgentSaveInfo;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import pojos.ExperimenterData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataViewerAgent
implements Agent,
AgentEventListener {
    private static Registry registry;

    public static Registry getRegistry() {
        return registry;
    }

    public static ExperimenterData getUserDetails() {
        return (ExperimenterData)registry.lookup("/current_user/details");
    }

    public static Set getAvailableUserGroups() {
        return (Set)registry.lookup("/userGroup/details");
    }

    public static boolean isAdministrator() {
        Boolean b = (Boolean)registry.lookup("/users/administrator");
        if (b == null) {
            return false;
        }
        return b;
    }

    public static boolean isFastConnection() {
        int value = (Integer)registry.lookup("/connection/speed");
        return value == 0;
    }

    public static String getOmeroHome() {
        Environment env = (Environment)registry.lookup("/env");
        String omeroDir = env.getOmeroHome();
        File home = new File(omeroDir);
        if (!home.exists()) {
            home.mkdir();
        }
        return omeroDir;
    }

    public static String getOmeroFilesHome() {
        Environment env = (Environment)registry.lookup("/env");
        String omeroDir = env.getOmeroFilesHome();
        File home = new File(omeroDir);
        if (!home.exists()) {
            home.mkdir();
        }
        return omeroDir;
    }

    public static ExperimenterData getExperimenter(long expID) {
        List l = (List)registry.lookup("/users/details");
        if (l == null) {
            return null;
        }
        for (ExperimenterData exp : l) {
            if (exp.getId() != expID) continue;
            return exp;
        }
        return null;
    }

    public static boolean isBinaryAvailable() {
        Boolean b = (Boolean)registry.lookup("/services/SERVER/BinaryAvailable");
        if (b == null) {
            return true;
        }
        return b;
    }

    private void handleUserGroupSwitched(UserGroupSwitched evt) {
        if (evt == null) {
            return;
        }
        Environment env = (Environment)registry.lookup("/env");
        if (!env.isServerAvailable()) {
            return;
        }
        MetadataViewerFactory.onGroupSwitched(evt.isSuccessful());
    }

    @Override
    public void activate() {
    }

    @Override
    public void terminate() {
    }

    @Override
    public void setContext(Registry ctx) {
        registry = ctx;
        registry.getEventBus().register((AgentEventListener)this, UserGroupSwitched.class);
    }

    @Override
    public boolean canTerminate() {
        return true;
    }

    @Override
    public AgentSaveInfo getDataToSave() {
        List<Object> instances = MetadataViewerFactory.getInstancesToSave();
        if (instances == null || instances.size() == 0) {
            return null;
        }
        return new AgentSaveInfo("Edition", instances);
    }

    @Override
    public void save(List<Object> instances) {
        MetadataViewerFactory.saveInstances(instances);
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof UserGroupSwitched) {
            this.handleUserGroupSwitched((UserGroupSwitched)e);
        }
    }
}

