/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.browser;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserVisitor;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

public abstract class TreeBrowserDisplay
extends DefaultMutableTreeNode {
    private TreeBrowserDisplay parentDisplay;
    protected Set<TreeBrowserDisplay> childrenDisplay;
    private boolean expanded;
    private Icon defaultIcon;
    private boolean menuNode;

    private String getNodeName() {
        Object obj = this.getUserObject();
        if (obj instanceof ProjectData) {
            return ((ProjectData)obj).getName();
        }
        if (obj instanceof DatasetData) {
            return ((DatasetData)obj).getName();
        }
        if (obj instanceof ImageData) {
            return ((ImageData)obj).getName();
        }
        if (obj instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)obj;
            return EditorUtil.formatExperimenter(exp);
        }
        if (obj instanceof ScreenData) {
            return ((ScreenData)obj).getName();
        }
        if (obj instanceof PlateData) {
            return ((PlateData)obj).getName();
        }
        if (obj instanceof TagAnnotationData) {
            return ((TagAnnotationData)obj).getTagValue();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "";
    }

    protected TreeBrowserDisplay(Object hierarchyObject) {
        this(hierarchyObject, null, false);
    }

    protected TreeBrowserDisplay(Object hierarchyObject, Icon defaultIcon, boolean menuNode) {
        if (hierarchyObject == null) {
            throw new NullPointerException("No hierarchy object.");
        }
        this.setUserObject(hierarchyObject);
        this.childrenDisplay = new HashSet<TreeBrowserDisplay>();
        this.defaultIcon = defaultIcon;
        this.menuNode = menuNode;
    }

    public boolean isMenuNode() {
        return this.menuNode;
    }

    public Icon getDefaultIcon() {
        return this.defaultIcon;
    }

    public boolean hasChildrenDisplay() {
        return this.childrenDisplay.size() != 0;
    }

    public TreeBrowserDisplay getParentDisplay() {
        return this.parentDisplay;
    }

    public Set getChildrenDisplay() {
        return Collections.unmodifiableSet(this.childrenDisplay);
    }

    public void addChildDisplay(TreeBrowserDisplay child) {
        if (child == null) {
            throw new NullPointerException("No child.");
        }
        if (this.childrenDisplay.contains(child)) {
            return;
        }
        if (child.parentDisplay != null) {
            child.parentDisplay.removeChildDisplay(child);
        }
        child.parentDisplay = this;
        this.childrenDisplay.add(child);
    }

    public void removeChildDisplay(TreeBrowserDisplay child) {
        if (child == null) {
            throw new NullPointerException("No child.");
        }
        if (this.childrenDisplay.contains(child)) {
            child.parentDisplay.childrenDisplay.remove(child);
            child.parentDisplay = null;
        }
    }

    public void removeAllChildrenDisplay() {
        Iterator<TreeBrowserDisplay> i = this.childrenDisplay.iterator();
        HashSet<TreeBrowserDisplay> toRemove = new HashSet<TreeBrowserDisplay>(this.childrenDisplay.size());
        while (i.hasNext()) {
            toRemove.add(i.next());
        }
        i = toRemove.iterator();
        while (i.hasNext()) {
            this.removeChildDisplay(i.next());
        }
    }

    public void removeChildrenDisplay(List children) {
        if (children == null) {
            return;
        }
        Iterator i = children.iterator();
        while (i.hasNext()) {
            this.removeChildDisplay((TreeBrowserDisplay)i.next());
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public String toString() {
        return this.getNodeName();
    }

    public final boolean equals(Object x) {
        return this == x;
    }

    protected abstract void doAccept(TreeBrowserVisitor var1);

    public abstract boolean isChildrenLoaded();

    public abstract void setChildrenLoaded(Boolean var1);
}

