/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Cursor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.DocComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.agents.metadata.editor.OriginalMetadataComponent;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.util.FigureDialog;
import org.openmicroscopy.shoola.agents.metadata.util.ScriptingDialog;
import org.openmicroscopy.shoola.agents.util.SelectionWizard;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.ExportActivityParam;
import org.openmicroscopy.shoola.env.data.model.ROIResult;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.AnnotationData;
import pojos.ChannelAcquisitionData;
import pojos.ChannelData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.ImageAcquisitionData;
import pojos.ImageData;
import pojos.InstrumentData;
import pojos.PixelsData;
import pojos.PlateData;
import pojos.TagAnnotationData;
import pojos.WellSampleData;

class EditorComponent
extends AbstractComponent
implements Editor {
    private EditorModel model;
    private EditorControl controller;
    private EditorUI view;

    private void showSelectionWizard(Class type, Collection available, Collection selected, boolean addCreation) {
        IconManager icons = IconManager.getInstance();
        Registry reg = MetadataViewerAgent.getRegistry();
        String title = "";
        String text = "";
        Icon icon = null;
        if (TagAnnotationData.class.equals((Object)type)) {
            title = "Tags Selection";
            text = "Select the Tags to add or remove, \nor Create new Tags";
            icon = icons.getIcon(24);
        } else if (FileAnnotationData.class.equals((Object)type)) {
            title = "Attachments Selection";
            text = "Select the Attachments to add or remove.";
            icon = icons.getIcon(42);
        }
        long userID = MetadataViewerAgent.getUserDetails().getId();
        SelectionWizard wizard = new SelectionWizard(reg.getTaskBar().getFrame(), available, selected, type, addCreation, userID);
        wizard.setImmutableElements(this.model.getImmutableAnnotation());
        if (this.model.isMultiSelection()) {
            wizard.setAcceptButtonText("Save");
        }
        wizard.setTitle(title, text, icon);
        wizard.addPropertyChangeListener(this.controller);
        UIUtilities.centerAndShow(wizard);
    }

    EditorComponent(EditorModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.view = new EditorUI();
        this.controller = new EditorControl();
    }

    void initialize() {
        this.controller.initialize(this, this.view);
        this.view.initialize(this.model, this.controller);
        this.model.getObservable().addPropertyChangeListener(this.controller);
    }

    public JComponent getUI() {
        return this.view;
    }

    public void setStructuredDataResults() {
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.view.layoutUI();
        if (this.model.hasBeenViewedBy() && !this.model.isThumbnailsLoaded()) {
            this.model.loadThumbnails();
        }
    }

    public void setRootObject(Object refObject) {
        if (refObject == null) {
            throw new IllegalArgumentException("Root object not valid.");
        }
        this.model.setRootObject(refObject);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.view.setRootObject();
        if (this.model.getRndIndex() == 1) {
            if (!this.model.isRendererLoaded()) {
                this.loadRenderingControl(0);
            }
        } else if (this.view.getSelectedTab() == 2) {
            this.loadRenderingControl(0);
        }
    }

    public void setParentRootObject(Object parentRefObject, Object grandParent) {
        this.model.setParentRootObject(parentRefObject, grandParent);
        this.view.setParentRootObject();
    }

    public void setExistingTags(Collection tags) {
        this.model.setExistingTags(tags);
        List<TagAnnotationData> setTags = this.view.getCurrentTagsSelection();
        Iterator k = setTags.iterator();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (k.hasNext()) {
            TagAnnotationData tag = (TagAnnotationData)k.next();
            if (!this.model.isAnnotationUsedByUser(tag)) continue;
            ids.add(tag.getId());
        }
        ArrayList<TagAnnotationData> available = new ArrayList<TagAnnotationData>();
        if (tags != null) {
            for (TagAnnotationData data : tags) {
                String ns = data.getNameSpace();
                if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                    Set l = data.getTags();
                    if (l == null) continue;
                    for (TagAnnotationData tag : l) {
                        if (ids.contains(tag.getId())) continue;
                        available.add(tag);
                    }
                    continue;
                }
                if (ids.contains(data.getId())) continue;
                available.add(data);
            }
        }
        if (this.controller.getFigureDialog() != null) {
            ArrayList<TagAnnotationData> all = new ArrayList<TagAnnotationData>();
            all.addAll(available);
            if (setTags != null && setTags.size() > 0) {
                all.addAll(setTags);
            }
            this.controller.getFigureDialog().setTags(all);
            return;
        }
        this.showSelectionWizard(TagAnnotationData.class, available, setTags, true);
        this.setStatus(false);
    }

    public void setChannelsData(Map channels, boolean updateView) {
        this.model.setChannelData(channels);
        if (updateView) {
            this.view.showChannelData();
        }
    }

    public boolean hasDataToSave() {
        return this.view.hasDataToSave();
    }

    public void setDiskSpace(List list) {
        if (list == null || list.size() != 2) {
            return;
        }
        this.view.setDiskSpace(list);
        this.view.layoutUI();
    }

    public void passwordChanged(boolean changed) {
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        if (changed) {
            un.notifyInfo("Password change", "The password has been successfully modified.");
        } else {
            un.notifyInfo("Password change", "The password could not be modified. Please try again.");
        }
        this.view.passwordChanged();
    }

    public void loadChannelData() {
        if (this.model.isNumerousChannel()) {
            return;
        }
        if (this.model.getRndIndex() == 0) {
            if (this.model.getChannelData() == null) {
                this.model.loadChannelData();
            }
        } else {
            this.view.showChannelData();
        }
    }

    public Map getChannelData() {
        return this.model.getChannelData();
    }

    public void setExistingAttachements(Collection attachments) {
        if (attachments == null) {
            return;
        }
        this.model.setExistingAttachments(attachments);
        List<FileAnnotationData> setAttachments = this.view.getCurrentAttachmentsSelection();
        Iterator k = setAttachments.iterator();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (k.hasNext()) {
            ids.add(((FileAnnotationData)k.next()).getId());
        }
        ArrayList<FileAnnotationData> available = new ArrayList<FileAnnotationData>();
        if (attachments != null) {
            for (FileAnnotationData data : attachments) {
                if (ids.contains(data.getId())) continue;
                available.add(data);
            }
        }
        this.showSelectionWizard(FileAnnotationData.class, available, setAttachments, true);
        this.setStatus(false);
    }

    public void setSelectionMode(boolean single) {
        this.view.repaint();
    }

    public void loadParents() {
        this.model.loadParents();
    }

    public void setStatus(boolean busy) {
        this.view.setStatus(busy);
    }

    public void loadExistingTags() {
        this.model.loadExistingTags();
        this.setStatus(true);
    }

    public void deleteAnnotation(AnnotationData data) {
        if (data == null) {
            return;
        }
        String s = null;
        if (data instanceof FileAnnotationData) {
            s = "Do you want to delete the attachment?";
        }
        if (s == null) {
            return;
        }
        JFrame owner = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        MessageBox msg = new MessageBox(owner, "Delete", s);
        int option = msg.centerMsgBox();
        if (option == 1) {
            ArrayList<AnnotationData> toRemove = new ArrayList<AnnotationData>(1);
            toRemove.add(data);
        }
    }

    public void setImageAcquisitionData(ImageAcquisitionData map) {
        if (map == null) {
            return;
        }
        this.model.setImageAcquisitionData(map);
        this.view.setImageAcquisitionData();
        this.view.setStatus(false);
    }

    public void loadImageAcquisitionData() {
        Object refObject = this.model.getRefObject();
        if (refObject instanceof ImageData || refObject instanceof WellSampleData) {
            ImageAcquisitionData data = this.model.getImageAcquisitionData();
            if (data != null) {
                return;
            }
            this.model.fireImagAcquisitionDataLoading();
            this.view.setStatus(true);
        }
    }

    public void loadChannelAcquisitionData(ChannelData channel) {
        Object refObject = this.model.getRefObject();
        if (refObject instanceof ImageData || refObject instanceof WellSampleData) {
            if (channel == null) {
                return;
            }
            ChannelAcquisitionData data = this.model.getChannelAcquisitionData(channel.getIndex());
            if (data != null) {
                return;
            }
            this.model.fireChannelAcquisitionDataLoading(channel);
            this.view.setStatus(true);
        }
    }

    public void loadInstrumentData() {
        ImageData img;
        long id;
        Object refObject = this.model.getRefObject();
        if (refObject instanceof WellSampleData) {
            WellSampleData wsd = (WellSampleData)refObject;
            refObject = wsd.getImage();
        }
        if (refObject instanceof ImageData && (id = (img = (ImageData)refObject).getInstrumentId()) > 0L) {
            this.model.fireInstrumentDataLoading(id);
            this.view.setStatus(true);
        }
    }

    public void setChannelEnumerations(Map map) {
        this.model.setChannelEnumerations(map);
    }

    public void setImageEnumerations(Map map) {
        this.model.setImageEnumerations(map);
    }

    public void setChannelAcquisitionData(int index, ChannelAcquisitionData data) {
        this.model.setChannelAcquisitionData(index, data);
        this.view.setChannelAcquisitionData(index);
        this.view.setStatus(false);
    }

    public void loadExistingAttachments() {
        this.model.loadExistingAttachments();
        this.setStatus(true);
    }

    public void download(File folder) {
        this.model.download(folder);
    }

    public void setPlaneInfo(Collection result, long pixelsID, int channel) {
        Object ref = this.model.getRefObject();
        if (!(ref instanceof ImageData)) {
            return;
        }
        ImageData img = (ImageData)ref;
        if (pixelsID != img.getDefaultPixels().getId()) {
            return;
        }
        FigureDialog d = this.controller.getFigureDialog();
        if (channel >= 0) {
            this.model.setPlaneInfo(channel, result);
            this.view.setStatus(false);
        }
        if (d != null) {
            d.setPlaneInfo(this.model.getChannelPlaneInfo(0));
        } else {
            this.view.setPlaneInfo(channel);
        }
    }

    public void setRenderingControl(RenderingControl rndControl) {
        boolean loaded = this.model.isRendererLoaded();
        this.setStatus(false);
        if (rndControl == null) {
            this.setSelectedTab(0);
            return;
        }
        FigureDialog d = this.controller.getFigureDialog();
        PixelsData data = this.model.getPixels();
        if (data == null) {
            this.setSelectedTab(0);
            return;
        }
        if (data.getId() != rndControl.getPixelsID()) {
            this.setSelectedTab(0);
            return;
        }
        this.model.setRenderingControl(rndControl);
        if (loaded) {
            this.view.onSettingsApplied(false);
        }
        if (d == null) {
            this.view.setRenderer();
        }
        if (this.model.getRndIndex() == 1) {
            this.loadChannelData();
        }
        this.model.getRenderer().addPropertyChangeListener(this.controller);
        this.model.onRndLoaded(false);
        if (d != null) {
            d.setRenderer(this.model.getRenderer());
            if (d.getDialogType() == 4) {
                this.model.firePlaneInfoLoading(0, 0);
            }
        }
    }

    public void loadRenderingControl(int index) {
        int value;
        if (this.model.getRenderer() == null && index == 1) {
            return;
        }
        ImageData image = this.model.getImage();
        if (image == null) {
            return;
        }
        if (image.getId() < 0L) {
            return;
        }
        PixelsData pixels = image.getDefaultPixels();
        if (pixels == null) {
            return;
        }
        switch (index) {
            case 0: 
            case 1: {
                value = index;
                break;
            }
            default: {
                value = index;
            }
        }
        this.setStatus(this.model.fireRenderingControlLoading(pixels.getId(), value));
    }

    public void setLoadedFile(FileAnnotationData data, File file, Object uiView) {
        if (file == null) {
            return;
        }
        if (uiView instanceof DocComponent) {
            DocComponent doc = (DocComponent)uiView;
            if (doc.getData() == data) {
                doc.setThumbnail(file.getAbsolutePath());
                file.delete();
            }
        } else if (uiView instanceof OriginalMetadataComponent) {
            ((OriginalMetadataComponent)uiView).setOriginalFile(file);
        }
    }

    public Renderer getRenderer() {
        return this.model.getRenderer();
    }

    public void setInstrumentData(InstrumentData data) {
        if (data == null) {
            return;
        }
        this.model.setInstrumentData(data);
        this.view.setInstrumentData();
        this.view.setStatus(false);
    }

    public void refresh() {
        switch (this.view.getSelectedTab()) {
            case 0: {
                this.model.refresh();
                break;
            }
            case 2: {
                Renderer rnd = this.getRenderer();
                if (rnd == null) break;
                rnd.refresh();
                break;
            }
            case 1: {
                this.view.refreshAcquisition();
            }
        }
    }

    public void exportImageAsOMETIFF(File folder) {
        Object refObject = this.model.getRefObject();
        ImageData image = null;
        if (refObject instanceof ImageData) {
            image = (ImageData)refObject;
        } else if (refObject instanceof WellSampleData) {
            image = ((WellSampleData)refObject).getImage();
        }
        if (image == null) {
            return;
        }
        if (folder == null) {
            folder = UIUtilities.getDefaultFolder();
        }
        ExportActivityParam param = new ExportActivityParam(folder, image, 0);
        IconManager icons = IconManager.getInstance();
        param.setIcon(icons.getIcon(76));
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        un.notifyActivity(param);
    }

    public void onChannelColorChanged(int index) {
        this.view.onChannelColorChanged(index);
    }

    public void setSelectedTab(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                this.view.setSelectedTab(index);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void createFigure(int index) {
        if (this.controller.getFigureDialog() == null) {
            String name = this.model.getRefObjectName();
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            PixelsData pixels = this.model.getPixels();
            boolean b = this.view.isNumerousChannel();
            switch (index) {
                case 0: {
                    if (pixels == null) {
                        un.notifyInfo("Split View Figure", "Image not valid. Cannot create figure.");
                        return;
                    }
                    if (b) {
                        un.notifyInfo("Split View Figure", "The selected type of figure is not available for the image.");
                        return;
                    }
                    FigureDialog dialog = this.controller.createFigureDialog(name, pixels, 0);
                    if (!this.model.isRendererLoaded()) {
                        this.loadRenderingControl(0);
                    } else {
                        dialog.setRenderer(this.model.getRenderer());
                    }
                    dialog.centerDialog();
                    break;
                }
                case 1: {
                    if (b) {
                        un.notifyInfo("ROI Split Figure", "The selected type of figure is not available for the image.");
                        return;
                    }
                    this.model.fireROILoading(1);
                    break;
                }
                case 3: {
                    Object ref = this.model.getRefObject();
                    if (ref instanceof WellSampleData || ref instanceof PlateData) {
                        un.notifyInfo("Thumbnails Figure", "Script not available for Wells or Plate");
                        return;
                    }
                    Collection tags = this.model.getExistingTags();
                    FigureDialog dialog = this.controller.createFigureDialog(name, pixels, 3);
                    dialog.setParentRef(this.model.getParentRootObject());
                    if (tags != null) {
                        dialog.setTags(tags);
                    } else {
                        this.model.loadExistingTags();
                    }
                    dialog.centerDialog();
                    break;
                }
                case 2: {
                    if (pixels == null) {
                        un.notifyInfo("Movie Figure", "Image not valid. Cannot create figure.");
                        return;
                    }
                    Collection planes = this.model.getChannelPlaneInfo(0);
                    FigureDialog dialog = this.controller.createFigureDialog(name, pixels, 2);
                    if (planes != null) {
                        dialog.setPlaneInfo(planes);
                    } else {
                        this.model.firePlaneInfoLoading(0, 0);
                    }
                    dialog.centerDialog();
                    break;
                }
                case 4: {
                    this.model.fireROILoading(4);
                }
            }
        }
    }

    public void setROI(Collection rois, long imageID, int index) {
        if (index != 1 && index != 4) {
            return;
        }
        ImageData img = this.model.getImage();
        if (img == null || img.getId() != imageID) {
            return;
        }
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        if (rois == null || rois.size() == 0) {
            un.notifyInfo("ROI Split Figure", "The primary select does not have Region of Interests.");
            return;
        }
        Iterator r = rois.iterator();
        int count = 0;
        try {
            while (r.hasNext()) {
                ROIResult result = (ROIResult)r.next();
                Collection list = result.getROIs();
                if (list.size() <= 0) continue;
                ++count;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (count == 0) {
            un.notifyInfo("ROI Split Figure", "The primary select does not have Region of Interests.");
            return;
        }
        if (this.controller.getFigureDialog() == null) {
            PixelsData pixels = this.model.getPixels();
            if (pixels == null) {
                un.notifyInfo("ROI Split Figure", "Image not valid. Cannot create figure.");
                return;
            }
            String name = this.model.getRefObjectName();
            FigureDialog dialog = this.controller.createFigureDialog(name, pixels, index);
            if (dialog == null) {
                return;
            }
            dialog.setROIs(rois);
            if (!this.model.isRendererLoaded()) {
                this.loadRenderingControl(0);
            } else {
                dialog.setRenderer(this.model.getRenderer());
                if (index == 4) {
                    this.model.firePlaneInfoLoading(0, 0);
                }
            }
            dialog.centerDialog();
        }
    }

    public void setScripts(List scripts) {
        this.model.setScripts(scripts);
        this.view.setScripts();
    }

    public long getUserID() {
        return this.model.getUserID();
    }

    public void loadScript(long scriptID) {
        if (scriptID < 0L) {
            return;
        }
        this.model.loadScript(scriptID);
        this.setStatus(true);
    }

    public void setScript(ScriptObject script) {
        if (script == null) {
            throw new IllegalArgumentException("No script.");
        }
        this.model.setScript(script);
        this.setStatus(false);
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        ScriptingDialog dialog = new ScriptingDialog(f, this.model.getScript(script.getScriptID()));
        dialog.addPropertyChangeListener(this.controller);
        UIUtilities.centerAndShow(dialog);
    }

    public void setUserPhoto(BufferedImage photo, long experimenterID) {
        ExperimenterData exp;
        if (photo == null) {
            return;
        }
        Object o = this.model.getRefObject();
        if (o instanceof ExperimenterData && (exp = (ExperimenterData)o).getId() == experimenterID) {
            this.view.setUserPhoto(photo);
        }
    }

    public boolean isWritable() {
        return this.model.isWritable();
    }
}

