/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.model.OriginalFile;
import omero.model.PlaneInfo;
import org.openmicroscopy.shoola.agents.metadata.AcquisitionDataLoader;
import org.openmicroscopy.shoola.agents.metadata.AttachmentsLoader;
import org.openmicroscopy.shoola.agents.metadata.ChannelDataLoader;
import org.openmicroscopy.shoola.agents.metadata.DiskSpaceLoader;
import org.openmicroscopy.shoola.agents.metadata.EditorLoader;
import org.openmicroscopy.shoola.agents.metadata.EnumerationLoader;
import org.openmicroscopy.shoola.agents.metadata.FileLoader;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.InstrumentDataLoader;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.PasswordEditor;
import org.openmicroscopy.shoola.agents.metadata.PlaneInfoLoader;
import org.openmicroscopy.shoola.agents.metadata.ROILoader;
import org.openmicroscopy.shoola.agents.metadata.RenderingControlLoader;
import org.openmicroscopy.shoola.agents.metadata.ScriptLoader;
import org.openmicroscopy.shoola.agents.metadata.ScriptsLoader;
import org.openmicroscopy.shoola.agents.metadata.TagsLoader;
import org.openmicroscopy.shoola.agents.metadata.UserPhotoLoader;
import org.openmicroscopy.shoola.agents.metadata.UserPhotoUploader;
import org.openmicroscopy.shoola.agents.metadata.browser.Browser;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererFactory;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.data.model.DownloadArchivedActivityParam;
import org.openmicroscopy.shoola.env.data.model.EnumerationObject;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.ObservableComponent;
import pojos.AnnotationData;
import pojos.BooleanAnnotationData;
import pojos.ChannelAcquisitionData;
import pojos.ChannelData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.FileData;
import pojos.GroupData;
import pojos.ImageAcquisitionData;
import pojos.ImageData;
import pojos.InstrumentData;
import pojos.MultiImageData;
import pojos.PermissionData;
import pojos.PixelsData;
import pojos.PlateAcquisitionData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.RatingAnnotationData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.TextualAnnotationData;
import pojos.WellData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EditorModel {
    static final int DEFAULT_CHANNEL = 0;
    static final String ORIGINAL_METADATA_NAME = "original_metadata.txt";
    private MetadataViewer parent;
    private Editor component;
    private Object refObject;
    private Object parentRefObject;
    private Object gpRefObject;
    private Map<Long, List> textualAnnotationsByUsers;
    private List textualAnnotationsByDate;
    private List<EditorLoader> loaders;
    private Map<Long, BufferedImage> thumbnails;
    private Collection existingTags;
    private Collection existingAttachments;
    private Map emissionsWavelengths;
    private ViewerSorter sorter;
    private Browser browser;
    private ImageAcquisitionData imageAcquisitionData;
    private InstrumentData instrumentData;
    private Map<String, List<EnumerationObject>> channelEnumerations;
    private Map<String, List<EnumerationObject>> imageEnumerations;
    private Map<Integer, ChannelAcquisitionData> channelAcquisitionDataMap;
    private Map<Integer, Collection> channelPlaneInfoMap;
    private Renderer renderer;
    private List<AnnotationData> toDelete;
    private Map<Long, ScriptObject> scripts;
    private List<ScriptObject> scriptsWithUI;
    private FileAnnotationData originalMetadata;

    private void downloadFiles(File folder) {
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        FileAnnotationData fa = (FileAnnotationData)this.getRefObject();
        OriginalFile f = (OriginalFile)fa.getContent();
        IconManager icons = IconManager.getInstance();
        DownloadActivityParam activity = new DownloadActivityParam(f, folder, icons.getIcon(77));
        un.notifyActivity(activity);
        List l = this.parent.getRelatedNodes();
        if (l == null) {
            return;
        }
        for (Object o : l) {
            if (!(o instanceof FileAnnotationData)) continue;
            fa = (FileAnnotationData)o;
            f = (OriginalFile)fa.getContent();
            if (f.isLoaded()) {
                activity = new DownloadActivityParam(f, folder, icons.getIcon(77));
            } else {
                long id = fa.getId();
                Environment env = (Environment)MetadataViewerAgent.getRegistry().lookup("/env");
                String path = env.getOmeroFilesHome();
                path = path + File.separator + fa.getFileName();
                activity = new DownloadActivityParam(id, 1, new File(path), icons.getIcon(77));
            }
            activity.setFileName(fa.getFileName());
            un.notifyActivity(activity);
        }
    }

    private void downloadImages(File folder) {
        ImageData img;
        ArrayList<ImageData> images = new ArrayList<ImageData>();
        List l = this.parent.getRelatedNodes();
        if (l != null) {
            for (Object o : l) {
                if (!(o instanceof ImageData) || !(img = (ImageData)o).isArchived()) continue;
                images.add(img);
            }
        }
        if ((img = (ImageData)this.getRefObject()).isArchived()) {
            images.add(img);
        }
        if (images.size() > 0) {
            Iterator i = images.iterator();
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            IconManager icons = IconManager.getInstance();
            String path = folder.getAbsolutePath();
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            while (i.hasNext()) {
                img = (ImageData)i.next();
                DownloadArchivedActivityParam p = new DownloadArchivedActivityParam(path, img, icons.getIcon(77));
                un.notifyActivity(p);
            }
        }
    }

    private void sortAnnotationByDate(List annotations) {
        if (annotations == null || annotations.size() == 0) {
            return;
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                Timestamp t1 = ((AnnotationData)o1).getLastModified();
                Timestamp t2 = ((AnnotationData)o2).getLastModified();
                long n1 = t1.getTime();
                long n2 = t2.getTime();
                int v = 0;
                if (n1 < n2) {
                    v = -1;
                } else if (n1 > n2) {
                    v = 1;
                }
                return -v;
            }
        };
        Collections.sort(annotations, c);
    }

    private List sortPlane(Collection nodes) {
        ArrayList l = new ArrayList();
        if (nodes == null) {
            return l;
        }
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            l.add(i.next());
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                PlaneInfo i1 = (PlaneInfo)o1;
                PlaneInfo i2 = (PlaneInfo)o2;
                int t1 = i1.getTheT().getValue();
                int t2 = i2.getTheT().getValue();
                int v = 0;
                if (t1 < t2) {
                    v = -1;
                } else if (t1 > t2) {
                    v = 1;
                }
                return v;
            }
        };
        Collections.sort(l, c);
        return l;
    }

    private void sortEnumerations(List<EnumerationObject> enumerations) {
        if (enumerations == null || enumerations.size() == 0) {
            return;
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((EnumerationObject)o1).getValue();
                String s2 = ((EnumerationObject)o2).getValue();
                int v = 0;
                int result = s1.toLowerCase().compareTo(s2.toLowerCase());
                if (result < 0) {
                    v = -1;
                } else if (result > 0) {
                    v = 1;
                }
                return v;
            }
        };
        Collections.sort(enumerations, c);
    }

    EditorModel(Object refObject, MetadataViewer parent) {
        if (refObject == null) {
            throw new IllegalArgumentException("No object set.");
        }
        this.parent = parent;
        this.refObject = refObject;
        this.loaders = new ArrayList<EditorLoader>();
        this.sorter = new ViewerSorter();
    }

    void deleteAnnotation(AnnotationData annotation) {
        if (annotation == null) {
            return;
        }
        if (this.toDelete == null) {
            this.toDelete = new ArrayList<AnnotationData>();
        }
        this.toDelete.add(annotation);
    }

    List<AnnotationData> getAnnotationToDelete() {
        return this.toDelete;
    }

    boolean isMultiSelection() {
        return !this.parent.isSingleMode();
    }

    ObservableComponent getObservable() {
        return this.parent;
    }

    void setBrowser(Browser browser) {
        this.browser = browser;
    }

    Browser getBrowser() {
        return this.browser;
    }

    void initialize(Editor component) {
        this.component = component;
    }

    boolean isPermissionsShowable() {
        Object ref = this.getRefObject();
        if (ref == null) {
            return false;
        }
        return ref instanceof ProjectData || ref instanceof DatasetData;
    }

    PermissionData getRefObjectPermissions() {
        Object ref = this.getRefObject();
        if (ref instanceof DataObject) {
            return ((DataObject)ref).getPermissions();
        }
        return null;
    }

    String getRefObjectName() {
        String name = "";
        Object ref = this.getPrimarySelect();
        if (ref instanceof ImageData) {
            name = ((ImageData)ref).getName();
        } else if (ref instanceof DatasetData) {
            name = ((DatasetData)ref).getName();
        } else if (ref instanceof ProjectData) {
            name = ((ProjectData)ref).getName();
        } else if (ref instanceof TagAnnotationData) {
            name = ((TagAnnotationData)ref).getTagValue();
        } else if (ref instanceof ScreenData) {
            name = ((ScreenData)ref).getName();
        } else if (ref instanceof PlateData) {
            name = ((PlateData)ref).getName();
        } else if (ref instanceof PlateAcquisitionData) {
            name = ((PlateAcquisitionData)ref).getLabel();
        } else if (ref instanceof FileAnnotationData) {
            name = ((FileAnnotationData)ref).getFileName();
        } else if (ref instanceof WellSampleData) {
            WellSampleData ws = (WellSampleData)ref;
            ImageData img = ws.getImage();
            if (img != null && img.getId() >= 0L) {
                name = img.getName();
            }
        } else if (ref instanceof FileData) {
            name = ((FileData)ref).getName();
        } else if (ref instanceof MultiImageData) {
            name = ((MultiImageData)ref).getName();
        }
        if (name == null) {
            return "";
        }
        return name.trim();
    }

    String getRefObjectDescription() {
        String description = "";
        Object ref = this.getPrimarySelect();
        if (ref instanceof ImageData) {
            description = ((ImageData)ref).getDescription();
        } else if (ref instanceof DatasetData) {
            description = ((DatasetData)ref).getDescription();
        } else if (ref instanceof ProjectData) {
            description = ((ProjectData)ref).getDescription();
        } else if (ref instanceof ScreenData) {
            description = ((ScreenData)ref).getDescription();
        } else if (ref instanceof PlateData) {
            description = ((PlateData)ref).getDescription();
        } else if (ref instanceof TagAnnotationData) {
            description = ((TagAnnotationData)ref).getTagDescription();
        } else if (ref instanceof WellSampleData) {
            if (this.parentRefObject instanceof WellData) {
                WellData ws = (WellData)this.parentRefObject;
                description = ws.getWellType();
            }
        } else if (ref instanceof FileData) {
            description = null;
        }
        if (description == null) {
            return "";
        }
        return description.trim();
    }

    long getRefObjectID() {
        Object ref = this.getRefObject();
        if (ref instanceof DataObject) {
            return ((DataObject)ref).getId();
        }
        return -1L;
    }

    Object getRefObject() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return this.refObject;
        }
        Object o = data.getRelatedObject();
        return this.refObject;
    }

    Object getPrimarySelect() {
        if (!this.isMultiSelection()) {
            return this.getRefObject();
        }
        List list = this.parent.getRelatedNodes();
        if (list == null || list.size() == 0) {
            return this.getRefObject();
        }
        return list.get(0);
    }

    boolean isWritable() {
        boolean b = this.isUserOwner(this.refObject);
        if (b) {
            return b;
        }
        int level = MetadataViewerAgent.getRegistry().getAdminService().getPermissionLevel();
        switch (level) {
            case 102: 
            case 104: {
                return true;
            }
        }
        return false;
    }

    boolean isValidGroup(GroupData g) {
        if (g == null) {
            return false;
        }
        String name = g.getName();
        return !"user".equals(name) && !"default".equals(name);
    }

    boolean isUserOwner(Object object) {
        DataObject f;
        long id = MetadataViewerAgent.getUserDetails().getId();
        if (object == null) {
            return false;
        }
        if (object instanceof ExperimenterData) {
            return ((ExperimenterData)object).getId() == id;
        }
        if (!(object instanceof DataObject)) {
            return false;
        }
        if ((object instanceof FileData || object instanceof ImageData) && (f = (DataObject)object).getId() < 0L) {
            return id == this.getUserID();
        }
        return EditorUtil.isUserOwner(object, id);
    }

    boolean isLinkOwner(Object annotation) {
        StructuredDataResults data = this.parent.getStructuredData();
        if (!(annotation instanceof DataObject)) {
            return false;
        }
        if (data == null) {
            return false;
        }
        Map m = data.getLinks();
        if (m == null) {
            return false;
        }
        long id = MetadataViewerAgent.getUserDetails().getId();
        Iterator i = m.entrySet().iterator();
        DataObject ann = (DataObject)annotation;
        while (i.hasNext()) {
            ExperimenterData exp;
            Map.Entry entry = i.next();
            DataObject o = (DataObject)entry.getKey();
            if (o.getId() != ann.getId() || id != (exp = (ExperimenterData)entry.getValue()).getId()) continue;
            return true;
        }
        return false;
    }

    List<ExperimenterData> getAnnotators(Object annotation) {
        ArrayList<ExperimenterData> list = new ArrayList<ExperimenterData>();
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return list;
        }
        Map m = data.getLinks();
        if (m == null) {
            return list;
        }
        long id = MetadataViewerAgent.getUserDetails().getId();
        Iterator i = m.entrySet().iterator();
        DataObject ann = (DataObject)annotation;
        ArrayList<Long> ids = new ArrayList<Long>();
        while (i.hasNext()) {
            ExperimenterData exp;
            Map.Entry entry = i.next();
            DataObject o = (DataObject)entry.getKey();
            if (o.getId() != ann.getId() || ids.contains((exp = (ExperimenterData)entry.getValue()).getId())) continue;
            list.add(exp);
            ids.add(exp.getId());
        }
        return list;
    }

    boolean isAnnotationUsedByUser(Object annotation) {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return false;
        }
        Map m = data.getLinks();
        if (m == null) {
            return false;
        }
        long id = MetadataViewerAgent.getUserDetails().getId();
        Iterator i = m.entrySet().iterator();
        DataObject ann = (DataObject)annotation;
        while (i.hasNext()) {
            ExperimenterData exp;
            Map.Entry entry = i.next();
            DataObject o = (DataObject)entry.getKey();
            if (o.getId() != ann.getId() || (exp = (ExperimenterData)entry.getValue()).getId() != id) continue;
            return true;
        }
        return false;
    }

    Collection getImmutableAnnotation() {
        ArrayList<DataObject> list = new ArrayList<DataObject>();
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return list;
        }
        Map m = data.getLinks();
        if (m == null) {
            return list;
        }
        long id = MetadataViewerAgent.getUserDetails().getId();
        for (Map.Entry entry : m.entrySet()) {
            DataObject o = (DataObject)entry.getKey();
            ExperimenterData exp = (ExperimenterData)entry.getValue();
            if (id == exp.getId()) continue;
            list.add(o);
        }
        return list;
    }

    List<Long> getImmutableAnnotationIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        Collection l = this.getImmutableAnnotation();
        for (DataObject data : l) {
            ids.add(data.getId());
        }
        return ids;
    }

    boolean isGroupLeader() {
        ExperimenterData exp = MetadataViewerAgent.getUserDetails();
        Set groups = MetadataViewerAgent.getAvailableUserGroups();
        if (groups == null) {
            return false;
        }
        long groupID = exp.getDefaultGroup().getId();
        Iterator i = groups.iterator();
        Set leaders = null;
        while (i.hasNext()) {
            GroupData g = (GroupData)i.next();
            if (g.getId() != groupID) continue;
            leaders = g.getLeaders();
            break;
        }
        if (leaders == null) {
            return false;
        }
        for (ExperimenterData data : leaders) {
            if (data.getId() != exp.getId()) continue;
            return true;
        }
        return false;
    }

    String formatOwner(DataObject object) {
        if (object == null) {
            return "";
        }
        if (object instanceof ExperimenterData) {
            return EditorUtil.formatExperimenter((ExperimenterData)object);
        }
        return this.formatOwner((DataObject)object.getOwner());
    }

    String formatDate(DataObject object) {
        String date = "";
        Timestamp time = null;
        if (object == null) {
            return date;
        }
        time = object instanceof AnnotationData ? ((AnnotationData)object).getLastModified() : (object instanceof ImageData ? EditorUtil.getAcquisitionTime((ImageData)object) : object.getCreated());
        if (time != null) {
            date = UIUtilities.formatShortDateTime(time);
        }
        return date;
    }

    int getTermsCount() {
        Collection urls = this.getTerms();
        if (urls == null) {
            return 0;
        }
        return urls.size();
    }

    Collection getTerms() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return null;
        }
        return data.getTerms();
    }

    int getTagsCount() {
        Collection tags = this.getTags();
        if (tags == null) {
            return 0;
        }
        return tags.size();
    }

    Collection getTags() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return new ArrayList();
        }
        Collection tags = data.getTags();
        if (tags == null || tags.size() == 0) {
            return new ArrayList();
        }
        return this.sorter.sort(tags);
    }

    Collection getCompanionFiles() {
        StructuredDataResults data = this.parent.getStructuredData();
        ArrayList<FileAnnotationData> list = new ArrayList<FileAnnotationData>();
        if (data == null) {
            return list;
        }
        Collection attachements = data.getAttachments();
        if (attachements == null) {
            return list;
        }
        for (FileAnnotationData f : attachements) {
            String ns = f.getNameSpace();
            if (!"openmicroscopy.org/omero/import/companionFile".equals(ns) || f == this.originalMetadata) continue;
            list.add(f);
        }
        return this.sorter.sort(list);
    }

    Collection getAttachments() {
        StructuredDataResults data = this.parent.getStructuredData();
        ArrayList<FileAnnotationData> l = new ArrayList<FileAnnotationData>();
        if (data == null) {
            return l;
        }
        Collection attachements = data.getAttachments();
        if (attachements == null) {
            return l;
        }
        for (FileAnnotationData f : attachements) {
            String ns = f.getNameSpace();
            if ("openmicroscopy.org/omero/import/companionFile".equals(ns)) {
                String name = f.getFileName();
                if (!name.contains(ORIGINAL_METADATA_NAME)) continue;
                this.originalMetadata = f;
                continue;
            }
            l.add(f);
        }
        return this.sorter.sort(l);
    }

    FileAnnotationData getOriginalMetadata() {
        return this.originalMetadata;
    }

    int getViewedByCount() {
        Collection viewedBy = this.getViewedBy();
        if (viewedBy == null) {
            return 0;
        }
        return viewedBy.size();
    }

    Collection getViewedBy() {
        return null;
    }

    int getRatingCount() {
        StructuredDataResults data = this.parent.getStructuredData();
        Collection ratings = data.getRatings();
        if (ratings == null || ratings.size() == 0) {
            return 0;
        }
        int n = 0;
        Iterator i = ratings.iterator();
        long id = MetadataViewerAgent.getUserDetails().getId();
        while (i.hasNext()) {
            RatingAnnotationData rate = (RatingAnnotationData)i.next();
            if (rate.getOwner().getId() == id) continue;
            ++n;
        }
        return n;
    }

    RatingAnnotationData getUserRatingAnnotation() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return null;
        }
        Collection ratings = data.getRatings();
        if (ratings == null || ratings.size() == 0) {
            return null;
        }
        Iterator i = ratings.iterator();
        long id = MetadataViewerAgent.getUserDetails().getId();
        while (i.hasNext()) {
            RatingAnnotationData rate = (RatingAnnotationData)i.next();
            if (rate.getOwner().getId() != id) continue;
            return rate;
        }
        return null;
    }

    BooleanAnnotationData getPublishedAnnotation() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return null;
        }
        Collection c = data.getPublished();
        if (c == null || c.size() == 0) {
            return null;
        }
        Iterator i = c.iterator();
        long id = MetadataViewerAgent.getUserDetails().getId();
        while (i.hasNext()) {
            BooleanAnnotationData b = (BooleanAnnotationData)i.next();
            if (b.getOwner().getId() != id) continue;
            return b;
        }
        return null;
    }

    int getUserRating() {
        RatingAnnotationData data = this.getUserRatingAnnotation();
        if (data == null) {
            return 0;
        }
        return data.getRating();
    }

    int getRatingAverage() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return 0;
        }
        Collection ratings = data.getRatings();
        if (ratings == null || ratings.size() == 0) {
            return 0;
        }
        int n = 0;
        Iterator i = ratings.iterator();
        int value = 0;
        long id = MetadataViewerAgent.getUserDetails().getId();
        while (i.hasNext()) {
            RatingAnnotationData rate = (RatingAnnotationData)i.next();
            if (rate.getOwner().getId() == id) continue;
            value += rate.getRating();
            ++n;
        }
        if (n == 0) {
            return 0;
        }
        return value / n;
    }

    int getTextualAnnotationCount() {
        Collection annotations = this.getTextualAnnotations();
        if (annotations == null) {
            return 0;
        }
        return annotations.size();
    }

    Collection getTextualAnnotations() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return null;
        }
        return data.getTextualAnnotations();
    }

    List getTextualAnnotationsByDate() {
        if (this.textualAnnotationsByDate != null) {
            return this.textualAnnotationsByDate;
        }
        this.textualAnnotationsByDate = (List)this.getTextualAnnotations();
        this.sortAnnotationByDate(this.textualAnnotationsByDate);
        return this.textualAnnotationsByDate;
    }

    TextualAnnotationData getLastUserAnnotation() {
        long userID;
        Map<Long, List> m = this.getTextualAnnotationByOwner();
        List l = m.get(userID = MetadataViewerAgent.getUserDetails().getId());
        if (l == null || l.size() == 0) {
            return null;
        }
        return (TextualAnnotationData)l.get(0);
    }

    Map<Long, List> getTextualAnnotationByOwner() {
        if (this.textualAnnotationsByUsers != null && this.textualAnnotationsByUsers.size() > 0) {
            return this.textualAnnotationsByUsers;
        }
        this.textualAnnotationsByUsers = new HashMap<Long, List>();
        Collection original = this.getTextualAnnotations();
        if (original == null) {
            return this.textualAnnotationsByUsers;
        }
        for (AnnotationData annotation : original) {
            Long ownerID = annotation.getOwner().getId();
            ArrayList<AnnotationData> userAnnos = this.textualAnnotationsByUsers.get(ownerID);
            if (userAnnos == null) {
                userAnnos = new ArrayList<AnnotationData>();
                this.textualAnnotationsByUsers.put(ownerID, userAnnos);
            }
            userAnnos.add(annotation);
        }
        for (Long ownerID : this.textualAnnotationsByUsers.keySet()) {
            this.sortAnnotationByDate(this.textualAnnotationsByUsers.get(ownerID));
        }
        return this.textualAnnotationsByUsers;
    }

    boolean isSameObject(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.refObject.getClass())) {
            return false;
        }
        if (object instanceof DataObject && this.refObject instanceof DataObject) {
            DataObject d1 = (DataObject)object;
            DataObject d2 = (DataObject)this.refObject;
            return d1.getId() == d2.getId();
        }
        return false;
    }

    void setRootObject(Object refObject) {
        boolean b = this.isSameObject(refObject);
        this.refObject = refObject;
        this.parentRefObject = null;
        if (this.existingTags != null) {
            this.existingTags.clear();
        }
        this.existingTags = null;
        if (this.textualAnnotationsByUsers != null) {
            this.textualAnnotationsByUsers.clear();
        }
        this.textualAnnotationsByUsers = null;
        if (this.textualAnnotationsByDate != null) {
            this.textualAnnotationsByDate.clear();
        }
        this.textualAnnotationsByDate = null;
        if (this.existingAttachments != null) {
            this.existingAttachments.clear();
        }
        this.existingAttachments = null;
        if (!b) {
            if (this.emissionsWavelengths != null) {
                this.emissionsWavelengths.clear();
            }
            this.emissionsWavelengths = null;
            if (this.channelAcquisitionDataMap != null) {
                this.channelAcquisitionDataMap.clear();
            }
            if (this.channelPlaneInfoMap != null) {
                this.channelPlaneInfoMap.clear();
            }
            this.imageAcquisitionData = null;
            this.instrumentData = null;
            this.originalMetadata = null;
            if (refObject instanceof ImageData || refObject instanceof WellSampleData) {
                this.fireChannelEnumerationsLoading();
                this.fireImageEnumerationsLoading();
            } else if (refObject instanceof ExperimenterData) {
                this.fireExperimenterPhotoLoading();
            }
            if (this.renderer != null) {
                this.renderer.discard();
                this.renderer = null;
            }
        }
    }

    void setParentRootObject(Object parentRefObject, Object gpRefObject) {
        this.parentRefObject = parentRefObject;
        this.gpRefObject = gpRefObject;
    }

    Object getParentRootObject() {
        return this.parentRefObject;
    }

    Object getGrandParentRootObject() {
        return this.gpRefObject;
    }

    ExperimenterData getRefObjectOwner() {
        Object ref = this.getRefObject();
        if (ref instanceof DataObject) {
            return this.getOwner((DataObject)ref);
        }
        return null;
    }

    boolean isThumbnailsLoaded() {
        return this.thumbnails != null;
    }

    void setThumbnails(Map<Long, BufferedImage> thumbnails) {
    }

    Map<Long, BufferedImage> getThumbnails() {
        return this.thumbnails;
    }

    void loadThumbnails() {
    }

    void cancelThumbnailsLoading() {
    }

    void loadExistingTags() {
        boolean exist = false;
        for (EditorLoader l : this.loaders) {
            if (!(l instanceof TagsLoader)) continue;
            exist = true;
            break;
        }
        if (exist) {
            return;
        }
        TagsLoader loader = new TagsLoader(this.component);
        loader.load();
        this.loaders.add(loader);
    }

    void loadExistingAttachments() {
        boolean exist = false;
        for (EditorLoader l : this.loaders) {
            if (!(l instanceof AttachmentsLoader)) continue;
            exist = true;
            break;
        }
        if (exist) {
            return;
        }
        AttachmentsLoader loader = new AttachmentsLoader(this.component);
        loader.load();
        this.loaders.add(loader);
    }

    void cancelExistingTagsLoading() {
        Iterator<EditorLoader> i = this.loaders.iterator();
        ArrayList<EditorLoader> toKeep = new ArrayList<EditorLoader>();
        while (i.hasNext()) {
            EditorLoader loader = i.next();
            if (loader instanceof TagsLoader) {
                loader.cancel();
                continue;
            }
            toKeep.add(loader);
        }
        this.loaders.clear();
        this.loaders.addAll(toKeep);
    }

    void loadChannelData() {
        WellSampleData wsd;
        Object refObject = this.getRefObject();
        ImageData data = null;
        if (refObject instanceof ImageData) {
            data = (ImageData)refObject;
        } else if (refObject instanceof WellSampleData && ((data = (wsd = (WellSampleData)refObject).getImage()) == null || data.getId() < 0L)) {
            data = null;
        }
        try {
            PixelsData pixs = data.getDefaultPixels();
            ChannelDataLoader loader = new ChannelDataLoader(this.component, pixs.getId(), this.parent.getUserID());
            loader.load();
            this.loaders.add(loader);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void cancelChannelDataLoading() {
        Iterator<EditorLoader> i = this.loaders.iterator();
        ArrayList<EditorLoader> toKeep = new ArrayList<EditorLoader>();
        while (i.hasNext()) {
            EditorLoader loader = i.next();
            if (loader instanceof ChannelDataLoader) {
                loader.cancel();
                continue;
            }
            toKeep.add(loader);
        }
        this.loaders.clear();
        this.loaders.addAll(toKeep);
    }

    void setExistingTags(Collection tags) {
        if (tags != null) {
            this.existingTags = this.sorter.sort(tags);
        }
        Iterator<EditorLoader> i = this.loaders.iterator();
        EditorLoader toRemove = null;
        while (i.hasNext()) {
            EditorLoader loader = i.next();
            if (!(loader instanceof TagsLoader)) continue;
            toRemove = loader;
            break;
        }
        if (toRemove != null) {
            this.loaders.remove(toRemove);
        }
    }

    Collection getExistingTags() {
        return this.existingTags;
    }

    void setExistingAttachments(Collection attachments) {
        if (attachments != null) {
            this.existingAttachments = this.sorter.sort(attachments);
        }
        Iterator<EditorLoader> i = this.loaders.iterator();
        EditorLoader toRemove = null;
        while (i.hasNext()) {
            EditorLoader loader = i.next();
            if (!(loader instanceof AttachmentsLoader)) continue;
            toRemove = loader;
            break;
        }
        if (toRemove != null) {
            this.loaders.remove(toRemove);
        }
    }

    Collection getExistingAttachments() {
        return this.existingAttachments;
    }

    void setChannelData(Map data) {
        List l = this.sorter.sort(data.keySet());
        this.emissionsWavelengths = new LinkedHashMap();
        for (Object channel : l) {
            this.emissionsWavelengths.put(channel, data.get(channel));
        }
    }

    Map getChannelData() {
        if (this.getRndIndex() == 1 && this.renderer != null) {
            List<ChannelData> l = this.renderer.getChannelData();
            LinkedHashMap<ChannelData, Color> m = new LinkedHashMap<ChannelData, Color>();
            for (ChannelData data : l) {
                m.put(data, this.renderer.getChannelColor(data.getIndex()));
            }
            return m;
        }
        return this.emissionsWavelengths;
    }

    void fireAnnotationSaving(List<AnnotationData> toAdd, List<AnnotationData> toRemove, List<Object> metadata, boolean asynch) {
        Object ref = this.getRefObject();
        if (ref instanceof DataObject) {
            DataObject data = (DataObject)ref;
            if (data instanceof WellSampleData) {
                data = ((WellSampleData)ref).getImage();
            }
            this.parent.saveData(toAdd, toRemove, this.toDelete, metadata, data, asynch);
        }
    }

    void fireAdminSaving(Object data, boolean asynch) {
        if (data instanceof ExperimenterData || data instanceof AdminObject) {
            this.parent.updateAdminObject(data, asynch);
        }
    }

    boolean isArchived() {
        Object ref = this.getRefObject();
        if (!(ref instanceof ImageData)) {
            return false;
        }
        ImageData img = (ImageData)ref;
        if (img.isArchived()) {
            return true;
        }
        List l = this.parent.getRelatedNodes();
        if (l == null || l.size() == 0) {
            return false;
        }
        for (Object o : l) {
            if (!(o instanceof ImageData) || !(img = (ImageData)o).isArchived()) continue;
            return true;
        }
        return false;
    }

    void download(File folder) {
        Object ref = this.getRefObject();
        if (this.refObject instanceof ImageData) {
            this.downloadImages(folder);
        } else if (this.refObject instanceof FileAnnotationData) {
            this.downloadFiles(folder);
        }
    }

    void loadDiskSpace(long id) {
        DiskSpaceLoader loader = new DiskSpaceLoader(this.component, id);
        loader.load();
        this.loaders.add(loader);
    }

    void cancelDiskSpaceLoading() {
        Iterator<EditorLoader> i = this.loaders.iterator();
        ArrayList<EditorLoader> toKeep = new ArrayList<EditorLoader>();
        while (i.hasNext()) {
            EditorLoader loader = i.next();
            if (loader instanceof DiskSpaceLoader) {
                loader.cancel();
                continue;
            }
            toKeep.add(loader);
        }
        this.loaders.clear();
        this.loaders.addAll(toKeep);
    }

    void changePassword(String old, String confirm) {
        PasswordEditor loader = new PasswordEditor(this.component, old, confirm);
        ((EditorLoader)loader).load();
        this.loaders.add(loader);
    }

    boolean hasTagsAsChildren() {
        Object ref = this.getRefObject();
        if (!(ref instanceof TagAnnotationData)) {
            return false;
        }
        TagAnnotationData tag = (TagAnnotationData)ref;
        Set tags = tag.getTags();
        return tags != null && tags.size() > 0;
    }

    ExperimenterData getOwner(DataObject data) {
        if (data == null) {
            return null;
        }
        long id = data.getOwner().getId();
        return MetadataViewerAgent.getExperimenter(id);
    }

    void loadParents() {
        this.parent.loadParents();
    }

    void cancelParentsLoading() {
    }

    boolean hasBeenViewedBy() {
        if (!(this.getRefObject() instanceof ImageData)) {
            return false;
        }
        return this.getViewedByCount() != 0;
    }

    void fireImageEnumerationsLoading() {
        EnumerationLoader loader = new EnumerationLoader(this.component, 0);
        loader.load();
    }

    void fireChannelEnumerationsLoading() {
        EnumerationLoader loader = new EnumerationLoader(this.component, 1);
        loader.load();
    }

    void fireImagAcquisitionDataLoading() {
        Object ref = this.getRefObject();
        ImageData data = null;
        if (ref instanceof WellSampleData) {
            data = ((WellSampleData)ref).getImage();
        } else if (ref instanceof ImageData) {
            data = (ImageData)ref;
        }
        if (data == null) {
            return;
        }
        AcquisitionDataLoader loader = new AcquisitionDataLoader(this.component, data);
        loader.load();
    }

    void fireChannelAcquisitionDataLoading(ChannelData channel) {
        AcquisitionDataLoader loader = new AcquisitionDataLoader(this.component, channel);
        loader.load();
    }

    void fireInstrumentDataLoading(long instrumentID) {
        InstrumentDataLoader loader = new InstrumentDataLoader(this.component, instrumentID);
        loader.load();
    }

    void setImageAcquisitionData(ImageAcquisitionData data) {
        this.imageAcquisitionData = data;
    }

    ImageAcquisitionData getImageAcquisitionData() {
        return this.imageAcquisitionData;
    }

    void setChannelAcquisitionData(int index, ChannelAcquisitionData data) {
        if (this.channelAcquisitionDataMap == null) {
            this.channelAcquisitionDataMap = new HashMap<Integer, ChannelAcquisitionData>();
        }
        this.channelAcquisitionDataMap.put(index, data);
    }

    ChannelAcquisitionData getChannelAcquisitionData(int index) {
        if (this.channelAcquisitionDataMap == null) {
            return null;
        }
        return this.channelAcquisitionDataMap.get(index);
    }

    void setPlaneInfo(int index, Collection data) {
        if (this.channelPlaneInfoMap == null) {
            this.channelPlaneInfoMap = new HashMap<Integer, Collection>();
        }
        this.channelPlaneInfoMap.put(index, this.sortPlane(data));
    }

    Collection getChannelPlaneInfo(int index) {
        if (this.channelPlaneInfoMap == null) {
            return null;
        }
        return this.channelPlaneInfoMap.get(index);
    }

    List<EnumerationObject> getImageEnumerations(String name) {
        if (this.imageEnumerations != null) {
            return this.imageEnumerations.get(name);
        }
        return new ArrayList<EnumerationObject>();
    }

    List<EnumerationObject> getChannelEnumerations(String name) {
        if (this.channelEnumerations != null) {
            return this.channelEnumerations.get(name);
        }
        return new ArrayList<EnumerationObject>();
    }

    Object getImageEnumerationSelected(String name, String value) {
        List<EnumerationObject> l = this.getImageEnumerations(name);
        if (l.size() == 0) {
            return null;
        }
        Iterator<EnumerationObject> i = l.iterator();
        value = value.trim();
        while (i.hasNext()) {
            EnumerationObject o = i.next();
            String v = o.getValue();
            if (!(v = v.trim()).equals(value)) continue;
            return o;
        }
        return null;
    }

    Object getChannelEnumerationSelected(String name, String value) {
        if (value == null) {
            return null;
        }
        List<EnumerationObject> l = this.getChannelEnumerations(name);
        if (l.size() == 0) {
            return null;
        }
        Iterator<EnumerationObject> i = l.iterator();
        value = value.trim();
        while (i.hasNext()) {
            EnumerationObject o = i.next();
            String v = o.getValue();
            if (!(v = v.trim()).equals(value)) continue;
            return o;
        }
        return null;
    }

    void setChannelEnumerations(Map enumerations) {
        this.channelEnumerations = new HashMap<String, List<EnumerationObject>>();
        Set set = enumerations.entrySet();
        for (Map.Entry entry : set) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            this.sortEnumerations(values);
            this.channelEnumerations.put(key, values);
        }
    }

    void setImageEnumerations(Map enumerations) {
        this.imageEnumerations = new HashMap<String, List<EnumerationObject>>();
        Set set = enumerations.entrySet();
        for (Map.Entry entry : set) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            this.sortEnumerations(values);
            this.imageEnumerations.put(key, values);
        }
    }

    String getTagDescription(TagAnnotationData tag) {
        if (tag == null) {
            return "";
        }
        return tag.getTagDescription();
    }

    boolean isSingleMode() {
        return this.parent.isSingleMode();
    }

    String getObjectPath() {
        return this.parent.getObjectPath();
    }

    void firePlaneInfoLoading(int channel, int z) {
        Object ref = this.getRefObject();
        if (ref instanceof WellSampleData) {
            WellSampleData wsd = (WellSampleData)ref;
            ref = wsd.getImage();
        }
        if (!(ref instanceof ImageData)) {
            return;
        }
        ImageData img = (ImageData)ref;
        PlaneInfoLoader loader = new PlaneInfoLoader(this.component, img.getDefaultPixels().getId(), channel, z);
        loader.load();
    }

    void makeMovie(int scaleBar, Color overlayColor) {
        this.parent.makeMovie(scaleBar, overlayColor);
    }

    void analyse(int index) {
        this.parent.analyse(index);
    }

    boolean isRendererLoaded() {
        return this.renderer != null;
    }

    boolean fireRenderingControlLoading(long pixelsID, int index) {
        if (this.isRendererLoaded() && index == 0) {
            return false;
        }
        RenderingControlLoader loader = new RenderingControlLoader(this.component, pixelsID, index);
        loader.load();
        return true;
    }

    void setRenderingControl(RenderingControl rndControl) {
        if (this.renderer != null) {
            this.renderer.onSettingsApplied(rndControl);
        } else {
            this.renderer = RendererFactory.createRenderer(rndControl, this.getImage(), this.getRndIndex());
        }
    }

    Renderer getRenderer() {
        return this.renderer;
    }

    int getRndIndex() {
        return this.parent.getRndIndex();
    }

    boolean hasBeenPublished() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return false;
        }
        return this.getPublishedAnnotation() != null;
    }

    void loadFile(FileAnnotationData data, Object uiView) {
        FileLoader loader = new FileLoader(this.component, data, uiView);
        loader.load();
    }

    void loadFiles(Map<FileAnnotationData, Object> files) {
        if (!MetadataViewerAgent.isBinaryAvailable()) {
            return;
        }
        FileLoader loader = new FileLoader(this.component, files);
        loader.load();
    }

    void onRndLoaded(boolean reload) {
        if (this.renderer == null) {
            return;
        }
        this.parent.onRndLoaded(reload);
    }

    void setInstrumentData(InstrumentData data) {
        this.instrumentData = data;
    }

    InstrumentData getInstrumentData() {
        return this.instrumentData;
    }

    void sortDataObjectByID(List values) {
        if (values == null || values.size() == 0) {
            return;
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                long n1 = ((DataObject)o1).getId();
                long n2 = ((DataObject)o2).getId();
                int v = 0;
                if (n1 < n2) {
                    v = -1;
                } else if (n1 > n2) {
                    v = 1;
                }
                return -v;
            }
        };
        Collections.sort(values, c);
    }

    void upgradePermissions() {
    }

    Color getChannelColor(int index) {
        if (this.renderer == null) {
            return null;
        }
        return this.renderer.getChannelColor(index);
    }

    boolean isNumerousChannel() {
        if (!(this.refObject instanceof ImageData) && !(this.refObject instanceof WellSampleData)) {
            return false;
        }
        if (this.renderer != null) {
            return this.renderer.getPixelsDimensionsC() >= 10;
        }
        ImageData img = null;
        if (this.refObject instanceof WellSampleData) {
            img = ((WellSampleData)this.refObject).getImage();
        }
        if (this.refObject instanceof ImageData) {
            img = (ImageData)this.refObject;
        }
        PixelsData pixels = null;
        try {
            pixels = img.getDefaultPixels();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pixels == null) {
            return false;
        }
        return pixels.getSizeC() >= 10;
    }

    boolean isPreviewAvailable() {
        if (!(this.refObject instanceof ImageData) && !(this.refObject instanceof WellSampleData)) {
            return false;
        }
        if (!MetadataViewerAgent.isBinaryAvailable()) {
            return false;
        }
        ImageData img = null;
        if (this.refObject instanceof WellSampleData) {
            img = ((WellSampleData)this.refObject).getImage();
        }
        if (this.refObject instanceof ImageData) {
            img = (ImageData)this.refObject;
        }
        if (img.getId() < 0L) {
            return false;
        }
        PixelsData pixels = null;
        try {
            pixels = img.getDefaultPixels();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pixels == null) {
            return false;
        }
        int size = 1500;
        return pixels.getSizeX() <= size && pixels.getSizeY() <= size;
    }

    void createFigure(Object value) {
        this.parent.createFigure(value);
    }

    void manageScript(ScriptObject script, int index) {
        this.parent.manageScript(script, index);
    }

    PixelsData getPixels() {
        ImageData img = this.getImage();
        if (img == null) {
            return null;
        }
        return img.getDefaultPixels();
    }

    ImageData getImage() {
        Object object = this.getPrimarySelect();
        ImageData img = null;
        if (object instanceof WellSampleData) {
            img = ((WellSampleData)object).getImage();
        }
        if (object instanceof ImageData) {
            img = (ImageData)object;
        }
        return img;
    }

    void fireROILoading(int index) {
        ImageData img = this.getImage();
        if (img == null) {
            return;
        }
        long userID = MetadataViewerAgent.getUserDetails().getId();
        ROILoader loader = new ROILoader(this.component, img.getId(), userID, index);
        loader.load();
    }

    void discardRenderer() {
        if (this.renderer != null) {
            this.renderer.discard();
        }
        this.renderer = null;
    }

    void refresh() {
        this.parent.setRootObject(this.getRefObject(), this.getUserID());
    }

    void setScripts(List scripts) {
        if (scripts == null) {
            this.scripts = null;
            return;
        }
        LinkedHashMap<Long, ScriptObject> map = new LinkedHashMap<Long, ScriptObject>();
        if (scripts == null) {
            return;
        }
        List l = this.sorter.sort(scripts);
        for (ScriptObject s : l) {
            map.put(s.getScriptID(), s);
        }
        this.scripts = map;
    }

    Collection<ScriptObject> getScripts() {
        if (this.scripts == null) {
            return null;
        }
        return this.scripts.values();
    }

    void loadScript(long scriptID) {
        ScriptLoader loader = new ScriptLoader(this.component, scriptID);
        loader.load();
        this.loaders.add(loader);
    }

    void setScript(ScriptObject script) {
        if (this.scripts == null || this.scripts.size() == 0) {
            return;
        }
        ScriptObject sc = this.scripts.get(script.getScriptID());
        if (sc != null) {
            sc.setJobParams(script.getParameters());
        }
    }

    ScriptObject getScript(long scriptID) {
        return this.scripts.get(scriptID);
    }

    void loadScripts() {
        ScriptsLoader loader = new ScriptsLoader(this.component, false);
        loader.load();
        this.loaders.add(loader);
    }

    long getUserID() {
        return this.parent.getUserID();
    }

    String getOwnerName() {
        Object o = this.getRefObject();
        if (o == null) {
            return null;
        }
        if (o instanceof ExperimenterData || o instanceof GroupData) {
            return null;
        }
        if (o instanceof DataObject) {
            DataObject data = (DataObject)o;
            long id = MetadataViewerAgent.getUserDetails().getId();
            if (data.getId() < 0L) {
                return null;
            }
            if (!((DataObject)o).isLoaded()) {
                return null;
            }
            try {
                ExperimenterData owner = data.getOwner();
                if (owner.getId() == id) {
                    return null;
                }
                return owner.getFirstName() + " " + owner.getLastName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    void resetPassword(String newPass) {
        if (this.refObject instanceof ExperimenterData && MetadataViewerAgent.isAdministrator()) {
            this.parent.resetPassword(newPass);
        }
    }

    void uploadPicture(File photo, String format) {
        if (this.refObject instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)this.refObject;
            UserPhotoUploader loader = new UserPhotoUploader(this.component, exp, photo, format);
            loader.load();
        }
    }

    void fireExperimenterPhotoLoading() {
        if (this.refObject instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)this.refObject;
            UserPhotoLoader loader = new UserPhotoLoader(this.component, exp);
            loader.load();
        }
    }

    void uploadScript() {
        this.parent.uploadScript();
    }

    private List<ScriptObject> getScriptsWithUI() {
        if (this.scriptsWithUI != null) {
            return this.scriptsWithUI;
        }
        try {
            OmeroImageService svc = MetadataViewerAgent.getRegistry().getImageService();
            this.scriptsWithUI = svc.loadAvailableScriptsWithUI();
            return this.scriptsWithUI;
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print("Scripts with UI");
            msg.print(e);
            MetadataViewerAgent.getRegistry().getLogger().error((Object)this, msg);
            return new ArrayList<ScriptObject>();
        }
    }

    ScriptObject getScriptFromName(String name) {
        List<ScriptObject> scripts = this.getScriptsWithUI();
        for (ScriptObject script : scripts) {
            if (!name.contains(script.getName())) continue;
            return script;
        }
        return null;
    }

    GroupData loadGroup(long groupID) {
        try {
            AdminService svc = MetadataViewerAgent.getRegistry().getAdminService();
            List<GroupData> groups = svc.loadGroups(groupID);
            for (GroupData g : groups) {
                if (g.getId() != groupID) continue;
                return g;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    boolean isAnnotationToDelete(AnnotationData annotation) {
        if (this.toDelete == null || this.toDelete.size() == 0) {
            return false;
        }
        for (AnnotationData data : this.toDelete) {
            if (data.getId() != annotation.getId()) continue;
            return true;
        }
        return false;
    }

    List<FileAnnotationData> getTabularData() {
        StructuredDataResults data = this.parent.getStructuredData();
        ArrayList<FileAnnotationData> l = new ArrayList<FileAnnotationData>();
        if (data == null) {
            return l;
        }
        Collection attachements = data.getAttachments();
        if (attachements == null) {
            return l;
        }
        for (FileAnnotationData f : attachements) {
            String ns = f.getNameSpace();
            if (!"openmicroscopy.org/omero/bulk_annotations".equals(ns)) continue;
            l.add(f);
        }
        return l;
    }
}

