/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.events.editor.ShowEditorEvent;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.AcquisitionDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.GeneralPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.GroupProfile;
import org.openmicroscopy.shoola.agents.metadata.editor.ToolBar;
import org.openmicroscopy.shoola.agents.metadata.editor.UserUI;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.AnnotationData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EditorUI
extends JPanel {
    static final int TO_ADD = 0;
    static final int TO_REMOVE = 1;
    static final int TO_DELETE = 2;
    static final int GENERAL_INDEX = 0;
    static final int ACQUISITION_INDEX = 1;
    static final int RND_INDEX = 2;
    private static final String RENDERER_NAME = "Preview";
    private static final String RENDERER_DESCRIPTION = "Preview the image";
    private static final String RENDERER_NAME_SPECIFIC = "Settings";
    private static final String RENDERER_DESCRIPTION_SPECIFIC = "Adjust the rendering settings";
    private EditorControl controller;
    private EditorModel model;
    private GeneralPaneUI generalPane;
    private AcquisitionDataUI acquisitionPane;
    private UserUI userUI;
    private GroupProfile groupUI;
    private ToolBar toolBar;
    private boolean saved;
    private JTabbedPane tabPane;
    private JComponent userTabbedPane;
    private JComponent groupTabbedPane;
    private JComponent component;
    private JPanel defaultPane;
    private JPanel dummyPanel;

    private void populateTabbedPane(boolean init) {
        this.tabPane.addTab("General", null, this.generalPane, "General Information.");
        this.tabPane.addTab("Acquisition", null, new JScrollPane(this.acquisitionPane), "Acquisition Metadata.");
        if (init) {
            if (this.model.getRndIndex() == 1) {
                this.tabPane.addTab(RENDERER_NAME_SPECIFIC, null, this.dummyPanel, RENDERER_DESCRIPTION_SPECIFIC);
            } else {
                this.tabPane.addTab(RENDERER_NAME, null, this.dummyPanel, RENDERER_DESCRIPTION);
            }
        }
    }

    private void initComponents() {
        this.dummyPanel = new JPanel();
        this.groupUI = new GroupProfile(this.model);
        this.groupUI.addPropertyChangeListener(this.controller);
        this.userUI = new UserUI(this.model, this.controller);
        this.toolBar = new ToolBar(this.model, this.controller);
        this.generalPane = new GeneralPaneUI(this, this.model, this.controller);
        this.acquisitionPane = new AcquisitionDataUI(this, this.model, this.controller);
        this.tabPane = new JTabbedPane();
        this.tabPane.addChangeListener(this.controller);
        this.tabPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.populateTabbedPane(true);
        this.tabPane.setEnabledAt(1, false);
        this.defaultPane = new JPanel();
        this.defaultPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.component = this.defaultPane;
        this.userTabbedPane = new JScrollPane(this.userUI);
        this.groupTabbedPane = new JScrollPane(this.groupUI);
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.component, "Center");
    }

    EditorUI() {
    }

    void initialize(EditorModel model, EditorControl controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Controller cannot be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void layoutUI() {
        Object uo = this.model.getRefObject();
        this.remove(this.component);
        this.setDataToSave(false);
        boolean add = true;
        if (uo instanceof ExperimenterData) {
            this.toolBar.buildUI();
            this.userUI.buildUI();
            this.userUI.repaint();
            this.component = this.userTabbedPane;
        } else if (uo instanceof GroupData) {
            this.toolBar.buildUI();
            this.groupUI.buildUI();
            this.groupUI.repaint();
            this.component = this.groupTabbedPane;
        } else if (!(uo instanceof DataObject)) {
            this.toolBar.buildUI();
            this.component = this.defaultPane;
        } else {
            this.toolBar.buildUI();
            this.toolBar.setControls();
            this.generalPane.layoutUI();
            this.acquisitionPane.layoutCompanionFiles();
            this.component = this.tabPane;
        }
        if (add) {
            this.add((Component)this.component, "Center");
        }
        this.validate();
        this.repaint();
    }

    void setParentRootObject() {
        this.generalPane.setParentRootObject();
    }

    void setRootObject() {
        Object uo = this.model.getRefObject();
        this.tabPane.setComponentAt(2, this.dummyPanel);
        this.setDataToSave(false);
        this.toolBar.setRootObject();
        this.toolBar.buildUI();
        this.tabPane.setToolTipTextAt(2, "");
        boolean preview = false;
        int selected = this.getSelectedTab();
        if (!(uo instanceof DataObject)) {
            this.setDataToSave(false);
            this.toolBar.setStatus(false);
            this.toolBar.buildUI();
            this.remove(this.component);
            this.component = this.defaultPane;
            this.add((Component)this.component, "Center");
            this.revalidate();
            this.repaint();
        } else if (uo instanceof ExperimenterData) {
            this.userUI.clearData();
            this.toolBar.setStatus(false);
            this.layoutUI();
        } else {
            boolean load = false;
            if (this.model.isMultiSelection()) {
                this.tabPane.setSelectedIndex(0);
                this.tabPane.setEnabledAt(1, false);
                this.tabPane.setEnabledAt(2, false);
            } else {
                if (uo instanceof ImageData) {
                    load = true;
                    ImageData img = (ImageData)uo;
                    this.tabPane.setEnabledAt(1, img.getId() > 0L);
                    preview = this.model.isPreviewAvailable();
                    this.tabPane.setEnabledAt(2, preview);
                    if (!preview) {
                        this.tabPane.setToolTipTextAt(2, "Only available for image of size <= 1024x1024");
                    }
                    if (selected == 2) {
                        this.tabPane.setComponentAt(2, this.dummyPanel);
                        if (!preview && this.model.getRndIndex() != 1) {
                            this.tabPane.setSelectedIndex(0);
                        }
                    }
                } else if (uo instanceof WellSampleData) {
                    ImageData img = ((WellSampleData)uo).getImage();
                    if (this.tabPane.getSelectedIndex() == 2) {
                        this.tabPane.setComponentAt(2, this.dummyPanel);
                        if (this.model.isWritable()) {
                            this.tabPane.setSelectedIndex(0);
                        }
                    }
                    if (img != null && img.getId() >= 0L) {
                        load = true;
                        this.tabPane.setEnabledAt(1, true);
                        preview = this.model.isPreviewAvailable();
                        this.tabPane.setEnabledAt(2, preview);
                        if (!preview) {
                            this.tabPane.setToolTipTextAt(2, "Only available for image of size <= 1024x1024");
                        }
                        if (selected == 2) {
                            this.tabPane.setComponentAt(2, this.dummyPanel);
                            if (!preview) {
                                this.tabPane.setSelectedIndex(0);
                            }
                        }
                    } else {
                        this.tabPane.setSelectedIndex(0);
                        this.tabPane.setEnabledAt(1, false);
                        this.tabPane.setEnabledAt(2, false);
                    }
                } else {
                    this.tabPane.setSelectedIndex(0);
                    this.tabPane.setEnabledAt(1, false);
                    this.tabPane.setEnabledAt(2, false);
                }
                load = true;
            }
            this.generalPane.setRootObject();
            this.acquisitionPane.setRootObject(load);
        }
    }

    void saveData(boolean async) {
        this.saved = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.toolBar.setDataToSave(false);
        if (this.model.getRefObject() instanceof ExperimenterData) {
            Object exp = this.userUI.getExperimenterToSave();
            this.model.fireAdminSaving(exp, async);
            return;
        }
        if (this.model.getRefObject() instanceof GroupData) {
            AdminObject o = this.groupUI.getAdminObject();
            if (o == null) {
                this.saved = false;
                this.setCursor(Cursor.getDefaultCursor());
                this.toolBar.setDataToSave(true);
                return;
            }
            this.model.fireAdminSaving(o, async);
            return;
        }
        Map<Integer, List<AnnotationData>> m = this.generalPane.prepareDataToSave();
        List<AnnotationData> toAdd = m.get(0);
        List<AnnotationData> toRemove = m.get(1);
        List<Object> metadata = null;
        Object refObject = this.model.getRefObject();
        if (refObject instanceof ImageData) {
            metadata = this.acquisitionPane.prepareDataToSave();
        }
        this.model.fireAnnotationSaving(toAdd, toRemove, metadata, async);
    }

    List<TagAnnotationData> getCurrentTagsSelection() {
        return this.generalPane.getCurrentTagsSelection();
    }

    List<FileAnnotationData> getCurrentAttachmentsSelection() {
        return this.generalPane.getCurrentAttachmentsSelection();
    }

    void showChannelData() {
        this.generalPane.setChannelData();
        this.acquisitionPane.setChannelData();
    }

    void setDataToSave(boolean b) {
        this.toolBar.setDataToSave(b);
    }

    boolean hasDataToSave() {
        if (this.saved) {
            return false;
        }
        Object ref = this.model.getRefObject();
        if (!(ref instanceof DataObject)) {
            return false;
        }
        if (ref instanceof ExperimenterData) {
            return this.userUI.hasDataToSave();
        }
        if (ref instanceof GroupData) {
            return this.groupUI.hasDataToSave();
        }
        boolean b = this.generalPane.hasDataToSave();
        if (b) {
            return b;
        }
        return this.acquisitionPane.hasDataToSave();
    }

    void clearData() {
        this.saved = false;
        this.generalPane.clearData();
        this.tabPane.setComponentAt(2, this.dummyPanel);
        this.tabPane.repaint();
        this.setCursor(Cursor.getDefaultCursor());
    }

    void passwordChanged() {
        this.userUI.passwordChanged();
    }

    void setDiskSpace(List space) {
        this.userUI.setDiskSpace(space);
    }

    void handleTaskPaneCollapsed(JXTaskPane source) {
        this.generalPane.handleTaskPaneCollapsed(source);
    }

    void setStatus(boolean busy) {
        this.toolBar.setStatus(busy);
    }

    Collection getExistingTags() {
        return this.model.getExistingTags();
    }

    void attachFile(File file) {
        if (file == null) {
            return;
        }
        this.generalPane.attachFile(file);
        this.saveData(true);
    }

    void removeTag(TagAnnotationData tag) {
        if (tag == null) {
            return;
        }
        this.generalPane.removeTag(tag);
        if (tag.getId() >= 0L) {
            this.saveData(true);
        }
    }

    void removeTags() {
        List<TagAnnotationData> list = this.generalPane.removeTags();
        if (list.size() > 0) {
            this.saveData(true);
        }
    }

    void handleObjectsSelection(Class type, Collection objects) {
        if (objects == null) {
            return;
        }
        this.generalPane.handleObjectsSelection(type, objects);
        this.saveData(true);
    }

    void removeAttachedFile(Object file) {
        FileAnnotationData fa;
        if (file == null) {
            return;
        }
        this.generalPane.removeAttachedFile(file);
        if (file instanceof FileAnnotationData && (fa = (FileAnnotationData)file).getId() >= 0L) {
            this.saveData(true);
        }
    }

    void removeAttachedFiles() {
        List<FileAnnotationData> list = this.generalPane.removeAttachedFiles();
        if (list.size() > 0) {
            this.saveData(true);
        }
    }

    void deleteAnnotation(AnnotationData annotation) {
        this.model.deleteAnnotation(annotation);
    }

    void setImageAcquisitionData() {
        this.acquisitionPane.setImageAcquisitionData();
    }

    void setChannelAcquisitionData(int index) {
        this.acquisitionPane.setChannelAcquisitionData(index);
    }

    void setPlaneInfo(int index) {
        this.acquisitionPane.setPlaneInfo(index);
    }

    boolean isSingleMode() {
        return this.model.isSingleMode();
    }

    void createNewExperiment() {
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        String name = this.model.getObjectPath();
        Object object = this.model.getRefObject();
        if ((object instanceof ProjectData || object instanceof DatasetData || object instanceof ImageData || object instanceof ScreenData || object instanceof PlateData) && name != null && name.trim().length() > 0) {
            name = name + "_exp";
            ShowEditorEvent event = new ShowEditorEvent((DataObject)object, name, 0);
            bus.post(event);
        }
    }

    void makeMovie(int scaleBar, Color overlayColor) {
        this.model.makeMovie(scaleBar, overlayColor);
    }

    void setRenderer() {
        this.tabPane.removeAll();
        this.populateTabbedPane(false);
        if (this.model.getRndIndex() == 1) {
            this.tabPane.addTab(RENDERER_NAME_SPECIFIC, null, new JScrollPane(this.model.getRenderer().getUI()), RENDERER_DESCRIPTION_SPECIFIC);
        } else {
            this.tabPane.addTab(RENDERER_NAME, null, new JScrollPane(this.model.getRenderer().getUI()), RENDERER_DESCRIPTION);
        }
        this.setSelectedTab(2);
        this.model.getRenderer().renderPreview();
    }

    void setSelectedTab(int index) {
        this.tabPane.removeChangeListener(this.controller);
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                this.tabPane.setSelectedIndex(index);
            }
        }
        this.tabPane.addChangeListener(this.controller);
    }

    void analyse(int index) {
        this.model.analyse(index);
    }

    void setInstrumentData() {
        this.acquisitionPane.setInstrumentData();
    }

    int getSelectedTab() {
        return this.tabPane.getSelectedIndex();
    }

    void onChannelColorChanged(int index) {
        this.acquisitionPane.onChannelColorChanged(index);
    }

    String getRefObjectName() {
        return this.model.getRefObjectName();
    }

    Object getRefObject() {
        return this.model.getRefObject();
    }

    void onSettingsApplied(boolean cleanup) {
        if (cleanup) {
            this.tabPane.setComponentAt(2, this.dummyPanel);
        } else {
            this.tabPane.setComponentAt(2, new JScrollPane(this.model.getRenderer().getUI()));
        }
    }

    void activityOptions(Component source, Point p, int index) {
        this.toolBar.launchOptions(source, p, index);
    }

    void createFigure(Object value) {
        this.model.createFigure(value);
    }

    void manageScript(ScriptObject script, int index) {
        this.model.manageScript(script, index);
    }

    void discardRenderer(Object ref) {
        if (ref != this.model.getRefObject()) {
            // empty if block
        }
        this.model.discardRenderer();
        this.clearData();
    }

    void refreshAcquisition() {
    }

    void setScripts() {
        this.toolBar.setScripts();
    }

    void setUserPhoto(BufferedImage photo) {
        if (this.userUI != null) {
            this.userUI.setUserPhoto(photo);
        }
    }

    void uploadScript() {
        this.model.uploadScript();
    }

    void reloadScript() {
        this.model.setScripts(null);
        this.model.loadScripts();
        this.toolBar.setStatus(true);
    }

    ScriptObject getScriptFromName(String name) {
        return this.model.getScriptFromName(name);
    }

    boolean isNumerousChannel() {
        return this.model.isNumerousChannel();
    }
}

