/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Font;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.metadata.editor.AcquisitionDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.DataComponent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.EnumerationObject;
import org.openmicroscopy.shoola.util.ui.JLabelButton;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.OMEComboBox;
import org.openmicroscopy.shoola.util.ui.OMETextArea;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilterComponent
extends JPanel
implements PropertyChangeListener {
    static final String EMISSION_FILTER = "Emission Filter";
    static final String EXCITATION_FILTER = "Excitation Filter";
    private OMEComboBox filterBox;
    private Map<String, DataComponent> fieldsFilter;
    private JLabelButton unsetFilter;
    private boolean unsetFilterShown;
    private AcquisitionDataUI parent;
    private EditorModel model;

    private void resetBoxes() {
        int i = 0;
        List<EnumerationObject> l = this.model.getChannelEnumerations(Editor.FILTER_TYPE);
        Object[] array = new EnumerationObject[l.size() + 1];
        Iterator<EnumerationObject> j = l.iterator();
        i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.filterBox = EditorUtil.createComboBox(array);
    }

    private void initComponents() {
        this.resetBoxes();
        this.fieldsFilter = new LinkedHashMap<String, DataComponent>();
        this.unsetFilter = null;
        this.unsetFilterShown = false;
    }

    private void displayUnsetFilterFields() {
        this.unsetFilterShown = !this.unsetFilterShown;
        String s = "Show unset fields";
        if (this.unsetFilterShown) {
            s = "Hide unset fields";
        }
        this.unsetFilter.setText(s);
        this.parent.layoutFields(this, this.unsetFilter, this.fieldsFilter, this.unsetFilterShown);
    }

    private void transformFilterSource(Map<String, Object> details) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unsetFilter == null) {
            this.unsetFilter = this.parent.formatUnsetFieldsControl();
            this.unsetFilter.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            JComponent area;
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            if (value instanceof Number) {
                String v;
                area = UIUtilities.createComponent(NumericalTextField.class, null);
                if (value instanceof Double) {
                    v = "" + UIUtilities.roundTwoDecimals(((Number)value).doubleValue());
                    ((NumericalTextField)area).setNumberType(Double.class);
                } else if (value instanceof Float) {
                    v = "" + UIUtilities.roundTwoDecimals(((Number)value).doubleValue());
                    ((NumericalTextField)area).setNumberType(Float.class);
                } else {
                    v = "" + value;
                }
                ((NumericalTextField)area).setText(v);
                ((NumericalTextField)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else if ("Type".equals(key)) {
                Object selected = this.model.getChannelEnumerationSelected(Editor.FILTER_TYPE, (String)value);
                if (selected != null) {
                    this.filterBox.setSelectedItem(selected);
                } else {
                    set = false;
                    notSet.add(key);
                    this.filterBox.setSelectedIndex(this.filterBox.getItemCount() - 1);
                }
                this.filterBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.filterBox;
            } else {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                if (value == null || value.equals("")) {
                    value = "None";
                }
                ((OMETextArea)area).setEditable(false);
                ((OMETextArea)area).setText((String)value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            }
            area.setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(!notSet.contains(key));
            this.fieldsFilter.put(key, comp);
        }
    }

    private void buildGUI(String title) {
        this.setBorder(BorderFactory.createTitledBorder(title));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new GridBagLayout());
    }

    FilterComponent(AcquisitionDataUI parent, EditorModel model, String title) {
        this.parent = parent;
        this.model = model;
        if (title == null || title.trim().length() == 0) {
            title = "Filter";
        }
        this.initComponents();
        this.buildGUI(title);
    }

    void displayFilter(Map<String, Object> details) {
        this.resetBoxes();
        this.fieldsFilter.clear();
        this.transformFilterSource(details);
        this.parent.layoutFields(this, this.unsetFilter, this.fieldsFilter, this.unsetFilterShown);
        this.parent.attachListener(this.fieldsFilter);
    }

    boolean hasDataToSave() {
        return this.parent.hasDataToSave(this.fieldsFilter);
    }

    void prepareDataToSave() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selected".equals(name)) {
            this.displayUnsetFilterFields();
        }
    }
}

