/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.metadata.editor.AcquisitionDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.ObjectiveComponent;
import org.openmicroscopy.shoola.agents.util.DataComponent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.JLabelButton;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.OMETextArea;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageAcquisitionData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageAcquisitionComponent
extends JPanel
implements PropertyChangeListener {
    private static final int STAGE = 0;
    private static final int ENVIRONMENT = 1;
    private EditorModel model;
    private AcquisitionDataUI parent;
    private Map<String, DataComponent> fieldsEnv;
    private Map<String, DataComponent> fieldsStage;
    private boolean init;
    private ObjectiveComponent objectivePane;
    private JLabelButton unsetEnv;
    private boolean unsetEnvShown;
    private JPanel envPane;
    private JLabelButton unsetStage;
    private boolean unsetStageShown;
    private JPanel stagePane;

    private void displayUnsetEnvFields() {
        this.unsetEnvShown = !this.unsetEnvShown;
        String s = "Show unset fields";
        if (this.unsetEnvShown) {
            s = "Hide unset fields";
        }
        this.unsetEnv.setText(s);
        this.parent.layoutFields(this.envPane, this.unsetEnv, this.fieldsEnv, this.unsetEnvShown);
    }

    private void displayUnsetStageFields() {
        this.unsetStageShown = !this.unsetStageShown;
        String s = "Show unset fields";
        if (this.unsetStageShown) {
            s = "Hide unset fields";
        }
        this.unsetStage.setText(s);
        this.parent.layoutFields(this.stagePane, this.unsetStage, this.fieldsStage, this.unsetStageShown);
    }

    private void initComponents() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new BoxLayout(this, 1));
        this.fieldsEnv = new LinkedHashMap<String, DataComponent>();
        this.fieldsStage = new LinkedHashMap<String, DataComponent>();
        this.objectivePane = new ObjectiveComponent(this.parent, this.model);
        this.unsetEnv = null;
        this.unsetEnvShown = false;
        this.envPane = new JPanel();
        this.parent.format(this.envPane, "Environment");
        this.unsetStage = null;
        this.unsetStageShown = false;
        this.stagePane = new JPanel();
        this.parent.format(this.stagePane, "Position");
    }

    private void transformStage(Map<String, Object> details) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unsetStage == null) {
            this.unsetStage = this.parent.formatUnsetFieldsControl();
            this.unsetStage.setActionID(0L);
            this.unsetStage.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            JComponent area;
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            if (value instanceof String) {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                if (value == null || value.equals("")) {
                    value = "None";
                    set = false;
                }
                ((OMETextArea)area).setText((String)value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else {
                area = UIUtilities.createComponent(NumericalTextField.class, null);
                ((NumericalTextField)area).setNegativeAccepted(true);
                if (value instanceof Double) {
                    ((NumericalTextField)area).setNumberType(Double.class);
                } else if (value instanceof Float) {
                    ((NumericalTextField)area).setNumberType(Float.class);
                }
                ((NumericalTextField)area).setText("" + value);
                ((NumericalTextField)area).setEditedColor(UIUtilities.EDITED_COLOR);
            }
            area.setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(!notSet.contains(key));
            this.fieldsStage.put(key, comp);
        }
    }

    private void transformEnv(Map<String, Object> details) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unsetEnv == null) {
            this.unsetEnv = this.parent.formatUnsetFieldsControl();
            this.unsetEnv.setActionID(1L);
            this.unsetEnv.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            JComponent area;
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            if (value instanceof Number) {
                area = UIUtilities.createComponent(NumericalTextField.class, null);
                if (value instanceof Double) {
                    ((NumericalTextField)area).setNumberType(Double.class);
                } else if (value instanceof Float) {
                    ((NumericalTextField)area).setNumberType(Float.class);
                }
                if ("Temperature (\u2103)".equals(key)) {
                    ((NumericalTextField)area).setMinimum(-1.7976931348623157E308);
                }
                ((NumericalTextField)area).setText("" + value);
                ((NumericalTextField)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                if (value == null || value.equals("")) {
                    value = "None";
                    set = false;
                }
                ((OMETextArea)area).setText((String)value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            }
            area.setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(set);
            this.fieldsEnv.put(key, comp);
        }
    }

    private void buildGUI() {
        this.removeAll();
        if (this.objectivePane.isVisible()) {
            this.add(this.objectivePane);
        }
        if (this.envPane.isVisible()) {
            this.parent.layoutFields(this.envPane, this.unsetEnv, this.fieldsEnv, this.unsetEnvShown);
            this.add(this.envPane);
            this.parent.attachListener(this.fieldsEnv);
        }
        if (this.stagePane.isVisible()) {
            this.parent.layoutFields(this.stagePane, this.unsetStage, this.fieldsStage, this.unsetStageShown);
            this.add(this.stagePane);
            this.parent.attachListener(this.fieldsStage);
        }
    }

    ImageAcquisitionComponent(AcquisitionDataUI parent, EditorModel model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("No parent.");
        }
        this.parent = parent;
        this.model = model;
        this.initComponents();
    }

    void setImageAcquisitionData() {
        if (this.init) {
            return;
        }
        this.init = true;
        this.fieldsEnv.clear();
        this.fieldsStage.clear();
        ImageAcquisitionData data = this.model.getImageAcquisitionData();
        Map<String, Object> details = EditorUtil.transformObjectiveAndSettings(data);
        List notSet = (List)details.get("NotSet");
        this.objectivePane.setVisible(false);
        if (notSet.size() != 14) {
            this.objectivePane.displayObjective(details);
            this.objectivePane.setVisible(true);
        }
        details = EditorUtil.transformImageEnvironment(data);
        notSet = (List)details.get("NotSet");
        this.envPane.setVisible(false);
        if (notSet.size() != 4) {
            this.transformEnv(details);
            this.envPane.setVisible(true);
        }
        details = EditorUtil.transformStageLabel(data);
        notSet = (List)details.get("NotSet");
        this.stagePane.setVisible(false);
        if (notSet.size() != 4) {
            this.transformStage(details);
            this.stagePane.setVisible(true);
        }
        this.buildGUI();
    }

    void setRootObject() {
        this.init = false;
        this.removeAll();
    }

    boolean hasDataToSave() {
        boolean b = this.objectivePane.hasDataToSave();
        if (b) {
            return true;
        }
        b = this.parent.hasDataToSave(this.fieldsEnv);
        if (b) {
            return true;
        }
        b = this.parent.hasDataToSave(this.fieldsStage);
        return b;
    }

    ImageAcquisitionData prepareDataToSave() {
        Number number;
        Object value;
        DataComponent comp;
        String key;
        if (!this.hasDataToSave()) {
            return null;
        }
        ImageAcquisitionData data = this.model.getImageAcquisitionData();
        this.objectivePane.prepareDataToSave();
        for (Map.Entry<String, DataComponent> entry : this.fieldsEnv.entrySet()) {
            float v;
            key = entry.getKey();
            comp = entry.getValue();
            if (!comp.isDirty()) continue;
            value = comp.getAreaValue();
            if ("Temperature (\u2103)".equals(key)) {
                number = UIUtilities.extractNumber((String)value, Float.class);
                if (number == null) continue;
                data.setTemperature((double)((Float)number).floatValue());
                continue;
            }
            if ("Air Pressure (mb)".equals(key)) {
                number = UIUtilities.extractNumber((String)value, Float.class);
                if (number == null) continue;
                data.setAirPressure((double)((Float)number).floatValue());
                continue;
            }
            if ("Humidy (%)".equals(key)) {
                number = UIUtilities.extractNumber((String)value, Float.class);
                if (number == null) continue;
                v = ((Float)number).floatValue() / 100.0f;
                data.setHumidity((double)v);
                continue;
            }
            if (!"CO2 Percent (%)".equals(key) || (number = UIUtilities.extractNumber((String)value, Float.class)) == null) continue;
            v = ((Float)number).floatValue() / 100.0f;
            data.setCo2Percent((double)v);
        }
        for (Map.Entry<String, DataComponent> entry : this.fieldsStage.entrySet()) {
            key = entry.getKey();
            comp = entry.getValue();
            if (!comp.isDirty()) continue;
            value = comp.getAreaValue();
            if ("Name".equals(key)) {
                data.setLabelName((String)value);
                continue;
            }
            if ("Position X".equals(key)) {
                number = UIUtilities.extractNumber((String)value, Float.class);
                if (number == null) continue;
                data.setPositionX((double)((Float)number).floatValue());
                continue;
            }
            if ("Position Y".equals(key)) {
                number = UIUtilities.extractNumber((String)value, Float.class);
                if (number == null) continue;
                data.setPositionY((double)((Float)number).floatValue());
                continue;
            }
            if (!"Position Z".equals(key) || (number = UIUtilities.extractNumber((String)value, Float.class)) == null) continue;
            data.setPositionZ((double)((Float)number).floatValue());
        }
        return data;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selected".equals(name)) {
            int id = ((Long)evt.getNewValue()).intValue();
            switch (id) {
                case 0: {
                    this.displayUnsetStageFields();
                    break;
                }
                case 1: {
                    this.displayUnsetEnvFields();
                }
            }
        }
    }
}

