/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.AnalysisDialog;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.PublishingDialog;
import org.openmicroscopy.shoola.agents.metadata.util.ScriptSubMenu;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.util.filter.file.CppFilter;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;
import org.openmicroscopy.shoola.util.filter.file.JavaFilter;
import org.openmicroscopy.shoola.util.filter.file.MatlabFilter;
import org.openmicroscopy.shoola.util.filter.file.PythonFilter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.WellSampleData;

class ToolBar
extends JPanel {
    private static final String EXPORT_AS_OME_TIFF_TOOLTIP = "Export the image as OME-TIFF.";
    private JButton saveButton;
    private JButton downloadButton;
    private JButton rndButton;
    private JButton refreshButton;
    private JButton analysisButton;
    private JButton publishingButton;
    private JButton scriptsButton;
    private JButton exportAsOmeTiffButton;
    private JButton uploadScriptButton;
    private JXBusyLabel busyLabel;
    private EditorControl controller;
    private EditorModel model;
    private Point location;
    private PublishingDialog publishingDialog;
    private AnalysisDialog analysisDialog;

    private void checkBinaryAvailability() {
        if (MetadataViewerAgent.isBinaryAvailable()) {
            return;
        }
        this.downloadButton.setEnabled(false);
        this.rndButton.setEnabled(false);
        this.publishingButton.setEnabled(false);
        this.analysisButton.setEnabled(false);
    }

    private void initComponents() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        IconManager icons = IconManager.getInstance();
        this.saveButton = new JButton(icons.getIcon(37));
        this.saveButton.setToolTipText("Save changes back to the server.");
        this.saveButton.addActionListener(this.controller);
        this.saveButton.setActionCommand("3");
        this.saveButton.setEnabled(false);
        this.saveButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.downloadButton = new JButton(icons.getIcon(18));
        this.downloadButton.setToolTipText("Download the Archived File(s).");
        this.downloadButton.addActionListener(this.controller);
        this.downloadButton.setActionCommand("4");
        this.downloadButton.setEnabled(false);
        this.downloadButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.rndButton = new JButton(icons.getIcon(68));
        this.rndButton.setToolTipText("Rendering control for the primary selected image.");
        this.rndButton.addActionListener(this.controller);
        this.rndButton.setActionCommand("8");
        this.rndButton.setEnabled(false);
        this.rndButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.refreshButton = new JButton(icons.getIcon(0));
        this.refreshButton.setToolTipText("Refresh the selected tab.");
        this.refreshButton.addActionListener(this.controller);
        this.refreshButton.setActionCommand("10");
        this.refreshButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.publishingButton = new JButton(icons.getIcon(79));
        this.publishingButton.setToolTipText("Display the publishing options.");
        this.publishingButton.setEnabled(false);
        this.publishingButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.publishingButton.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                ToolBar.this.launchOptions((Component)e.getSource(), e.getPoint(), 100);
            }
        });
        this.analysisButton = new JButton(icons.getIcon(82));
        this.analysisButton.setToolTipText("Display the analysis options.");
        this.analysisButton.setEnabled(false);
        this.analysisButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.analysisButton.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                ToolBar.this.launchOptions((Component)e.getSource(), e.getPoint(), 101);
            }
        });
        this.scriptsButton = new JButton(icons.getIcon(107));
        this.scriptsButton.setToolTipText("Display the available scripts.");
        this.scriptsButton.setEnabled(false);
        this.scriptsButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.scriptsButton.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (ToolBar.this.model.getScripts() == null) {
                    ToolBar.this.location = e.getPoint();
                    ToolBar.this.scriptsButton.setEnabled(false);
                    ToolBar.this.model.loadScripts();
                    ToolBar.this.setStatus(true);
                } else {
                    ToolBar.this.launchOptions((Component)e.getSource(), e.getPoint(), 102);
                }
            }
        });
        this.exportAsOmeTiffButton = new JButton(icons.getIcon(73));
        this.exportAsOmeTiffButton.setEnabled(false);
        this.exportAsOmeTiffButton.setToolTipText(EXPORT_AS_OME_TIFF_TOOLTIP);
        this.exportAsOmeTiffButton.addActionListener(this.controller);
        this.exportAsOmeTiffButton.setActionCommand("11");
        this.exportAsOmeTiffButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.uploadScriptButton = new JButton(icons.getIcon(97));
        this.uploadScriptButton.setToolTipText("Upload a script to the server.");
        this.uploadScriptButton.addActionListener(this.controller);
        this.uploadScriptButton.setActionCommand("17");
        this.uploadScriptButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        UIUtilities.unifiedButtonLookAndFeel(this.uploadScriptButton);
        UIUtilities.unifiedButtonLookAndFeel(this.saveButton);
        UIUtilities.unifiedButtonLookAndFeel(this.downloadButton);
        UIUtilities.unifiedButtonLookAndFeel(this.rndButton);
        UIUtilities.unifiedButtonLookAndFeel(this.refreshButton);
        UIUtilities.unifiedButtonLookAndFeel(this.exportAsOmeTiffButton);
        UIUtilities.unifiedButtonLookAndFeel(this.publishingButton);
        UIUtilities.unifiedButtonLookAndFeel(this.analysisButton);
        UIUtilities.unifiedButtonLookAndFeel(this.scriptsButton);
        Dimension d = new Dimension(16, 16);
        this.busyLabel = new JXBusyLabel(d);
        this.busyLabel.setEnabled(true);
        this.busyLabel.setVisible(false);
    }

    private JComponent buildGeneralBar() {
        JToolBar bar = new JToolBar();
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(this.saveButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.refreshButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.downloadButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.exportAsOmeTiffButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.publishingButton);
        if (MetadataViewerAgent.isAdministrator()) {
            bar.add(Box.createHorizontalStrut(5));
            bar.add(this.uploadScriptButton);
        }
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.scriptsButton);
        return bar;
    }

    private void buildGUI() {
        JPanel bars = new JPanel();
        bars.setBackground(UIUtilities.BACKGROUND_COLOR);
        bars.setLayout(new BoxLayout(bars, 0));
        bars.add(this.buildGeneralBar());
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BoxLayout(p, 0));
        JPanel pp = UIUtilities.buildComponentPanel(bars);
        pp.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(pp);
        pp = UIUtilities.buildComponentPanelRight((JComponent)this.busyLabel);
        pp.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(pp);
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.add(p);
        this.add(new JSeparator());
    }

    private void setScriptIcon(ScriptObject so) {
        if (so.getIcon() != null) {
            return;
        }
        Icon icon = null;
        Icon largeIcon = null;
        Iterator<CustomizedFileFilter> i = EditorUtil.SCRIPTS_FILTERS.iterator();
        IconManager icons = IconManager.getInstance();
        while (i.hasNext()) {
            CustomizedFileFilter filter = i.next();
            if (!filter.accept(so.getName())) continue;
            if (filter instanceof CppFilter) {
                largeIcon = icons.getIcon(93);
                icon = icons.getIcon(89);
                break;
            }
            if (filter instanceof MatlabFilter) {
                icon = icons.getIcon(89);
                largeIcon = icons.getIcon(92);
                break;
            }
            if (filter instanceof JavaFilter) {
                icon = icons.getIcon(88);
                largeIcon = icons.getIcon(91);
                break;
            }
            if (!(filter instanceof PythonFilter)) break;
            icon = icons.getIcon(87);
            largeIcon = icons.getIcon(90);
            break;
        }
        if (icon == null) {
            icon = icons.getIcon(82);
        }
        if (largeIcon == null) {
            largeIcon = icons.getIcon(94);
        }
        so.setIcon(icon);
        so.setIconLarge(largeIcon);
    }

    private JPopupMenu getScriptsMenu() {
        JPopupMenu menu = new JPopupMenu();
        Collection<ScriptObject> scripts = this.model.getScripts();
        if (scripts == null || scripts.size() == 0) {
            return menu;
        }
        IconManager icons = IconManager.getInstance();
        JMenuItem refresh = new JMenuItem(icons.getIcon(0));
        refresh.setText("Reload Scripts");
        refresh.setToolTipText("Reloads the existing scripts.");
        refresh.addActionListener(this.controller);
        refresh.setActionCommand("18");
        menu.add(refresh);
        menu.add(new JSeparator());
        Iterator<ScriptObject> i = scripts.iterator();
        HashMap<String, ScriptSubMenu> menus = new HashMap<String, ScriptSubMenu>();
        ArrayList<ScriptSubMenu> others = new ArrayList<ScriptSubMenu>();
        ArrayList<String> formattedName = new ArrayList<String>();
        while (i.hasNext()) {
            ScriptObject so = i.next();
            this.setScriptIcon(so);
            String path = so.getPath();
            ScriptSubMenu subMenu = (ScriptSubMenu)menus.get(path);
            if (subMenu == null) {
                subMenu = new ScriptSubMenu(path, formattedName);
                menus.put(path, subMenu);
                if (so.isOfficialScript()) {
                    menu.add(subMenu);
                } else {
                    others.add(subMenu);
                }
            }
            subMenu.addScript(so).addActionListener(this.controller);
        }
        if (others.size() > 0) {
            menu.add(new JSeparator());
            JMenu uploadedMenu = new JMenu("User Scripts");
            menu.add(uploadedMenu);
            Iterator j = others.iterator();
            while (j.hasNext()) {
                uploadedMenu.add((JMenuItem)j.next());
            }
        }
        return menu;
    }

    ToolBar(EditorModel model, EditorControl controller) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    void setControls() {
        if (this.model.getRefObject() instanceof FileAnnotationData) {
            this.downloadButton.setEnabled(true);
        } else {
            this.downloadButton.setEnabled(this.model.isArchived());
        }
        this.checkBinaryAvailability();
    }

    void setDataToSave(boolean b) {
        this.saveButton.setEnabled(b);
    }

    void setStatus(boolean busy) {
        this.busyLabel.setBusy(busy);
        this.busyLabel.setVisible(busy);
    }

    void buildUI() {
        Object refObject = this.model.getRefObject();
        this.rndButton.setEnabled(false);
        this.downloadButton.setEnabled(false);
        if (refObject instanceof ImageData || refObject instanceof WellSampleData) {
            this.rndButton.setEnabled(!this.model.isRendererLoaded());
            if (this.model.isNumerousChannel()) {
                this.rndButton.setEnabled(false);
            }
            if (refObject instanceof ImageData) {
                this.downloadButton.setEnabled(this.model.isArchived());
            }
        } else if (refObject instanceof FileAnnotationData) {
            this.downloadButton.setEnabled(true);
        }
        this.checkBinaryAvailability();
        this.revalidate();
        this.repaint();
    }

    void setRootObject() {
        Object ref = this.model.getRefObject();
        if (ref instanceof ExperimenterData || ref instanceof GroupData) {
            this.publishingButton.setEnabled(false);
            this.analysisButton.setEnabled(false);
            this.scriptsButton.setEnabled(false);
            return;
        }
        this.exportAsOmeTiffButton.setEnabled(false);
        if (this.model.isSingleMode()) {
            ImageData img = null;
            if (ref instanceof ImageData) {
                img = (ImageData)ref;
            } else if (ref instanceof WellSampleData) {
                img = ((WellSampleData)ref).getImage();
            }
            if (img != null) {
                try {
                    img.getDefaultPixels();
                    this.exportAsOmeTiffButton.setEnabled(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.publishingButton.setEnabled(true);
        this.analysisButton.setEnabled(true);
        this.scriptsButton.setEnabled(true);
        if (this.publishingDialog != null) {
            this.publishingDialog.setRootObject();
        }
        if (this.analysisDialog != null) {
            this.analysisDialog.setRootObject();
        }
        this.checkBinaryAvailability();
    }

    void launchOptions(Component source, Point p, int index) {
        if (p == null) {
            p = new Point(0, 0);
        }
        switch (index) {
            case 100: {
                if (this.publishingDialog == null) {
                    this.publishingDialog = new PublishingDialog(this.controller, this.model);
                }
                this.publishingDialog.show(source, p.x, p.y);
                break;
            }
            case 101: {
                if (this.analysisDialog == null) {
                    this.analysisDialog = new AnalysisDialog(this.controller, this.model);
                }
                this.analysisDialog.show(source, p.x, p.y);
                break;
            }
            case 102: {
                this.getScriptsMenu().show(source, p.x, p.y);
            }
        }
    }

    void setScripts() {
        this.scriptsButton.setEnabled(true);
        this.setStatus(false);
        this.launchOptions(this.scriptsButton, this.location, 102);
        this.location = null;
    }
}

