/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.metadata.rnd.GraphicsPane;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererModel;
import org.openmicroscopy.shoola.agents.util.ui.ChannelButton;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.slider.TextualTwoKnobsSlider;
import pojos.ChannelData;

class ChannelSlider
extends JPanel
implements PropertyChangeListener {
    static final Color GRADIENT_COLOR = Color.BLACK;
    static final Dimension DEFAULT_SIZE = new Dimension(16, 16);
    private RendererModel model;
    private RendererControl controller;
    private GraphicsPane uiParent;
    private ChannelData channel;
    private TextualTwoKnobsSlider slider;
    private ChannelButton channelSelection;

    private void initComponents() {
        int index = this.channel.getIndex();
        int f = this.model.getRoundFactor(index);
        int s = (int)(this.model.getWindowStart(index) * (double)f);
        int e = (int)(this.model.getWindowEnd(index) * (double)f);
        int min = (int)(this.channel.getGlobalMin() * (double)f);
        int max = (int)(this.channel.getGlobalMax() * (double)f);
        this.slider = new TextualTwoKnobsSlider();
        this.slider.layoutComponents(4);
        this.slider.setBackground(UIUtilities.BACKGROUND_COLOR);
        int absMin = (int)(this.model.getLowestValue(index) * (double)f);
        int absMax = (int)(this.model.getHighestValue(index) * (double)f);
        double range = (double)(max - min) * 0.2;
        int lowestBound = (int)((double)min - range);
        lowestBound = absMin;
        int highestBound = (int)((double)max + range);
        highestBound = absMax;
        this.slider.setValues(max, min, highestBound, lowestBound, max, min, s, e, f);
        this.slider.getSlider().setPaintLabels(false);
        this.slider.getSlider().setPaintEndLabels(false);
        this.slider.getSlider().setPaintTicks(false);
        this.slider.addPropertyChangeListener(this);
        Color c = this.model.getChannelColor(index);
        this.slider.setColourGradients(GRADIENT_COLOR, c);
        Font font = this.slider.getFont();
        this.slider.setFont(font.deriveFont(font.getStyle(), font.getSize() - 2));
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.channel.getChannelLabeling());
        list.add("min: " + min);
        list.add("max: " + max);
        this.slider.getSlider().setToolTipText(UIUtilities.formatToolTipText(list));
        if (!this.model.isGeneralIndex()) {
            this.channelSelection = new ChannelButton("", c, index);
            this.channelSelection.setPreferredSize(DEFAULT_SIZE);
            this.channelSelection.setSelected(this.model.isChannelActive(index));
            this.channelSelection.addPropertyChangeListener(this.controller);
        }
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new FlowLayout(0, 0, 0));
        if (!this.model.isGeneralIndex()) {
            this.add(this.channelSelection);
        }
        this.add(this.slider);
    }

    ChannelSlider(GraphicsPane uiParent, RendererModel model, RendererControl controller, ChannelData channel) {
        if (uiParent == null) {
            throw new IllegalArgumentException("UI cannot be null.");
        }
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("Control cannot be null.");
        }
        this.uiParent = uiParent;
        this.model = model;
        this.controller = controller;
        this.channel = channel;
        this.initComponents();
        this.buildGUI();
    }

    int getColumns() {
        return this.slider.getColumns();
    }

    void setColumns(int columns) {
        this.slider.setColumns(columns);
    }

    int getIndex() {
        return this.channel.getIndex();
    }

    void setInterval(int s, int e) {
        this.slider.setInterval(s, e);
    }

    void setInputRange(boolean absolute) {
        int index = this.channel.getIndex();
        int f = this.model.getRoundFactor(index);
        int s = (int)(this.model.getWindowStart(index) * (double)f);
        int e = (int)(this.model.getWindowEnd(index) * (double)f);
        int min = (int)(this.channel.getGlobalMin() * (double)f);
        int max = (int)(this.channel.getGlobalMax() * (double)f);
        int absMin = (int)(this.model.getLowestValue(index) * (double)f);
        int absMax = (int)(this.model.getHighestValue(index) * (double)f);
        if (absolute) {
            this.slider.getSlider().setValues(absMax, absMin, absMax, absMin, s, e);
        } else {
            this.slider.getSlider().setValues(max, min, max, min, s, e);
        }
    }

    void setColorModelChanged() {
        this.slider.setColourGradients(GRADIENT_COLOR, this.model.getChannelColor(this.getIndex()));
        this.setSelectedChannel();
    }

    void setChannelColor() {
        Color c = this.model.getChannelColor(this.getIndex());
        this.slider.setColourGradients(GRADIENT_COLOR, c);
        if (this.channelSelection != null) {
            this.channelSelection.setColor(c);
        }
    }

    void setSelectedChannel() {
        if (this.channelSelection == null) {
            return;
        }
        this.channelSelection.setSelected(this.model.isChannelActive(this.getIndex()));
        this.channelSelection.setColor(this.model.getChannelColor(this.getIndex()));
        this.channelSelection.setGrayedOut("greyscale".equals(this.model.getColorModel()));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (this.uiParent.isLiveUpdate()) {
            if ("leftMoved".equals(name) || "rightMoved".equals(name) || "knobReleased".equals(name)) {
                this.controller.setInputInterval(this.slider.getStartValue(), this.slider.getEndValue(), this.channel.getIndex());
            }
        } else if ("knobReleased".equals(name)) {
            this.controller.setInputInterval(this.slider.getStartValue(), this.slider.getEndValue(), this.channel.getIndex());
        }
    }
}

