/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import com.sun.opengl.util.texture.TextureData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import omero.romio.PlaneDef;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererModel;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererUI;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.ChannelData;
import pojos.ImageData;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RendererComponent
extends AbstractComponent
implements Renderer {
    private static final String ERROR = " An error occurred while modifying  the rendering settings.";
    private RendererModel model;
    private RendererControl controller;
    private RendererUI view;
    private List historyActiveChannels;

    private void handleException(Throwable e) {
        this.handleException(e, true);
    }

    private void handleException(Throwable e, boolean notify) {
        Logger logger = MetadataViewerAgent.getRegistry().getLogger();
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        if (e instanceof RenderingServiceException) {
            RenderingServiceException rse = (RenderingServiceException)e;
            LogMessage logMsg = new LogMessage();
            logMsg.print("Rendering Exception:");
            logMsg.println(rse.getExtendedMessage());
            logMsg.print(rse);
            logger.error((Object)this, logMsg);
            if (e.getCause() instanceof OutOfMemoryError) {
                un.notifyInfo("Image", "Due to an out of Memory error, \nit is not possible to render the image.");
            } else if (notify) {
                JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
                MessageBox box = new MessageBox(f, "Rendering Error", "An error occurred while modifying the settings.\nDo you want to reload the settings?");
                if (box.centerMsgBox() == 1) {
                    logger.debug((Object)this, "Reload rendering Engine.");
                    this.firePropertyChange("Reload", false, true);
                } else {
                    this.firePropertyChange("Reload", true, false);
                }
            }
        } else if (e instanceof DSOutOfServiceException) {
            logger.debug((Object)this, "Reload rendering Engine.");
            un.notifyError(ERROR, "Out of service.", e.getCause());
            this.model.discard();
            this.fireStateChange();
        }
    }

    RendererComponent(RendererModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new RendererControl();
        this.view = new RendererUI();
    }

    void initialize() {
        this.model.initialize(this);
        this.controller.initialize(this, this.view);
        this.view.initialize(this.controller, this.model);
        this.setSelectedChannel(-1);
    }

    @Override
    public void discard() {
        this.model.discard();
    }

    @Override
    public double getGlobalMax() {
        return this.model.getGlobalMax();
    }

    @Override
    public double getGlobalMin() {
        return this.model.getGlobalMin();
    }

    @Override
    public double getHighestValue() {
        return this.model.getHighestValue();
    }

    @Override
    public double getLowestValue() {
        return this.model.getLowestValue();
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public JComponent getUI() {
        return this.view;
    }

    @Override
    public double getWindowEnd() {
        return this.model.getWindowEnd();
    }

    @Override
    public double getWindowStart() {
        return this.model.getWindowStart();
    }

    @Override
    public void onStateChange(boolean b) {
        if (this.view != null) {
            this.view.onStateChange(b);
        }
    }

    @Override
    public void setBitResolution(int v) {
        try {
            this.model.setBitResolution(v);
            this.firePropertyChange("render_plane", false, true);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setChannelSelection(int index, boolean selected) {
        int selectedIndex = index;
        boolean render = true;
        try {
            if (this.model.isGeneralIndex()) {
                if ("greyscale".equals(this.model.getColorModel())) {
                    if (this.model.isChannelActive(index)) {
                        return;
                    }
                    for (int i = 0; i < this.model.getMaxC(); ++i) {
                        boolean c = i == index;
                        this.model.setChannelActive(i, c);
                    }
                } else {
                    this.model.setChannelActive(index, selected);
                }
            } else if ("greyscale".equals(this.model.getColorModel())) {
                if (this.model.isChannelActive(index)) {
                    return;
                }
                for (int i = 0; i < this.model.getMaxC(); ++i) {
                    boolean c;
                    boolean bl = c = i == index;
                    if (c) {
                        selectedIndex = index;
                    }
                    this.model.setChannelActive(i, c);
                }
            } else {
                this.model.setChannelActive(index, selected);
                List<Integer> active = this.model.getActiveChannels();
                if (!active.contains(index) && active.size() > 0) {
                    int oldSelected = this.model.getSelectedChannel();
                    if (active.contains(oldSelected)) {
                        selectedIndex = oldSelected;
                    } else {
                        int setIndex = this.model.createSelectedChannel();
                        if (setIndex >= 0) {
                            selectedIndex = setIndex;
                        }
                    }
                }
            }
            this.model.setSelectedChannel(selectedIndex);
            this.view.setSelectedChannel();
            if (render) {
                this.firePropertyChange("render_plane", false, true);
            }
            this.firePropertyChange("selectedChannel", -1, selectedIndex);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setCodomainInterval(int s, int e) {
        try {
            this.model.setCodomainInterval(s, e);
            this.firePropertyChange("render_plane", false, true);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setColorModelChanged() {
        this.view.setColorModelChanged();
    }

    @Override
    public void setCurveCoefficient(double k) {
        try {
            this.model.setCurveCoefficient(k);
            this.firePropertyChange("render_plane", false, true);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setFamily(String family) {
        try {
            this.model.setFamily(family);
            this.firePropertyChange("render_plane", false, true);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setInputInterval(double start, double end) {
        this.setChannelWindow(this.model.getSelectedChannel(), start, end);
    }

    @Override
    public void setNoiseReduction(boolean b) {
        try {
            this.model.setNoiseReduction(b);
            this.firePropertyChange("render_plane", false, true);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setSelectedChannel(int c) {
        List<Integer> active = this.model.getActiveChannels();
        if (!active.contains(c) && active.size() > 0) {
            int oldSelected = this.model.getSelectedChannel();
            if (active.contains(oldSelected)) {
                c = oldSelected;
            } else {
                int setIndex = this.model.createSelectedChannel();
                if (setIndex >= 0) {
                    c = setIndex;
                }
            }
        }
        this.model.setSelectedChannel(c);
        this.view.setSelectedChannel();
    }

    @Override
    public void setChannelColor(int index, Color color) {
        try {
            this.model.setChannelColor(index, color);
            this.view.setChannelColor(index);
            this.firePropertyChange("channelColor", -1, index);
            if ("greyscale".equals(this.model.getColorModel())) {
                this.setColorModel("rgb", true);
            } else {
                this.firePropertyChange("render_plane", false, true);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public String getColorModel() {
        return this.model.getColorModel();
    }

    @Override
    public void setColorModel(String index, boolean update) {
        try {
            List<Integer> active = this.model.getActiveChannels();
            this.model.setColorModel(index);
            if ("greyscale".equals(index)) {
                this.historyActiveChannels = this.model.getActiveChannels();
                if (active != null && active.size() >= 1) {
                    List<ChannelData> channels = this.model.getChannelData();
                    Iterator<Integer> i = channels.iterator();
                    boolean set = false;
                    while (i.hasNext()) {
                        ChannelData channel = (ChannelData)i.next();
                        int j = channel.getIndex();
                        if (!active.contains(j)) continue;
                        if (set) {
                            this.model.setChannelActive(j, false);
                            continue;
                        }
                        this.model.setChannelActive(j, true);
                        set = true;
                    }
                } else if (active == null || active.size() == 0) {
                    this.model.setChannelActive(0, true);
                }
                if (active != null) {
                    for (int j : active) {
                    }
                }
            } else if (this.historyActiveChannels != null && this.historyActiveChannels.size() > 0) {
                Iterator i = this.historyActiveChannels.iterator();
                while (i.hasNext()) {
                    int j = (Integer)i.next();
                    this.model.setChannelActive(j, true);
                }
            } else if (active == null || active.size() == 0) {
                this.model.setChannelActive(0, true);
            } else {
                for (int j : active) {
                    this.model.setChannelActive(j, true);
                }
            }
            this.view.setColorModelChanged();
            this.firePropertyChange("colorModel", false, true);
            if (update) {
                this.firePropertyChange("render_plane", false, true);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void setSelectedXYPlane(int z, int t, int bin) {
        int defaultZ = this.model.getDefaultZ();
        int defaultT = this.model.getDefaultT();
        try {
            if (bin > 0) {
                this.model.setSelectedBin(bin);
            } else {
                if (defaultZ == z && defaultT == t) {
                    return;
                }
                this.model.setSelectedXYPlane(z, t);
                if (defaultZ != z) {
                    this.firePropertyChange("zSelected", defaultZ, z);
                }
                if (defaultT != t) {
                    this.firePropertyChange("tSelected", defaultT, t);
                }
            }
            this.firePropertyChange("render_plane", false, true);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void applyToAll() {
        if (!this.model.isGeneralIndex()) {
            return;
        }
        try {
            this.saveCurrentSettings();
            this.firePropertyChange("applyToAll", false, true);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void onSettingsApplied(RenderingControl rndControl) {
        if (rndControl == null) {
            return;
        }
        this.model.setRenderingControl(rndControl);
    }

    @Override
    public int getDefaultT() {
        return this.model.getDefaultT();
    }

    @Override
    public int getDefaultZ() {
        return this.model.getDefaultZ();
    }

    @Override
    public int getPixelsDimensionsT() {
        return this.model.getMaxT();
    }

    @Override
    public int getPixelsDimensionsX() {
        return this.model.getMaxX();
    }

    @Override
    public int getPixelsDimensionsY() {
        return this.model.getMaxY();
    }

    @Override
    public int getPixelsDimensionsZ() {
        return this.model.getMaxZ();
    }

    @Override
    public List<ChannelData> getChannelData() {
        return this.model.getChannelData();
    }

    @Override
    public List<Integer> getActiveChannels() {
        return this.model.getActiveChannels();
    }

    @Override
    public Color getChannelColor(int index) {
        return this.model.getChannelColor(index);
    }

    @Override
    public int getCompressionLevel() {
        return this.model.getCompressionLevel();
    }

    @Override
    public int getPixelsDimensionsC() {
        return this.model.getMaxC();
    }

    @Override
    public double getPixelsSizeX() {
        return this.model.getPixelsSizeX();
    }

    @Override
    public double getPixelsSizeY() {
        return this.model.getPixelsSizeY();
    }

    @Override
    public double getPixelsSizeZ() {
        return this.model.getPixelsSizeZ();
    }

    @Override
    public RndProxyDef getRndSettingsCopy() {
        return this.model.getRndSettingsCopy();
    }

    @Override
    public boolean[] hasRGB() {
        boolean[] rgb = new boolean[]{this.model.hasActiveChannel(0), this.model.hasActiveChannel(1), this.model.hasActiveChannel(2)};
        return rgb;
    }

    @Override
    public boolean isChannelActive(int index) {
        return this.model.isChannelActive(index);
    }

    @Override
    public boolean isColorComponent(int band, int index) {
        return this.model.isColorComponent(band, index);
    }

    @Override
    public boolean isCompressed() {
        return this.model.isCompressed();
    }

    @Override
    public boolean isSameSettings(RndProxyDef def, boolean checkPlane) {
        return this.model.isSameSettings(def, checkPlane);
    }

    @Override
    public void resetSettings() {
        try {
            this.model.resetDefaults();
            this.view.resetDefaultRndSettings();
            this.firePropertyChange("render_plane", false, true);
            this.firePropertyChange("colorModel", false, true);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    public void resetSettings(RndProxyDef settings, boolean update) {
        try {
            this.model.resetSettings(settings);
            if (update) {
                this.view.resetDefaultRndSettings();
                this.firePropertyChange("render_plane", false, true);
                this.firePropertyChange("colorModel", false, true);
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    public RndProxyDef saveCurrentSettings() throws RenderingServiceException, DSOutOfServiceException {
        return this.model.saveCurrentSettings();
    }

    @Override
    public void setActive(int index, boolean active) {
        try {
            this.model.setActive(index, active);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    public void setChannelWindow(int index, double start, double end) {
        try {
            double s = this.model.getWindowStart(index);
            double e = this.model.getWindowEnd(index);
            if (start == s && end == e) {
                return;
            }
            this.model.setInputInterval(index, start, end);
            this.firePropertyChange("render_plane", false, true);
            this.firePropertyChange("inputInterval", false, true);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    public void setCompression(int compression) {
        this.model.setCompression(compression);
    }

    @Override
    public void setOriginalRndSettings() {
        try {
            this.model.setOriginalRndSettings();
            this.view.resetDefaultRndSettings();
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    public boolean validatePixels(PixelsData pixels) {
        if (pixels == null) {
            return false;
        }
        return this.model.validatePixels(pixels);
    }

    @Override
    public BufferedImage renderPlane(PlaneDef pDef) {
        if (pDef == null) {
            return null;
        }
        try {
            return this.model.renderPlane(pDef);
        }
        catch (Throwable e) {
            this.handleException(e, false);
            return null;
        }
    }

    @Override
    public TextureData renderPlaneAsTexture(PlaneDef pDef) {
        if (pDef == null) {
            return null;
        }
        try {
            return this.model.renderPlaneAsTexture(pDef);
        }
        catch (Throwable e) {
            this.handleException(e, false);
            return null;
        }
    }

    @Override
    public void setRangeAllChannels(boolean absolute) {
        try {
            for (int i = 0; i < this.model.getMaxC(); ++i) {
                double max;
                double min;
                if (absolute) {
                    min = this.model.getLowestValue(i);
                    max = this.model.getHighestValue(i);
                } else {
                    min = this.model.getGlobalMin(i);
                    max = this.model.getGlobalMax(i);
                }
                this.model.setInputInterval(i, min, max);
            }
            this.firePropertyChange("render_plane", false, true);
            this.firePropertyChange("inputInterval", false, true);
            this.firePropertyChange("rangeInput", !absolute, absolute);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    public boolean isMappedImageRGB(List channels) {
        return this.model.isMappedImageRGB(channels);
    }

    @Override
    public BufferedImage createSingleChannelImage(boolean color, int channel, PlaneDef pDef) {
        try {
            String cm = this.model.getColorModel();
            if (!color) {
                this.model.setColorModel("greyscale");
            }
            List<Integer> active = this.model.getActiveChannels();
            for (int i = 0; i < this.model.getMaxC(); ++i) {
                this.model.setActive(i, channel == i);
            }
            BufferedImage img = this.model.renderPlane(pDef);
            this.model.setActive(channel, false);
            if (active != null) {
                Iterator<Integer> i = active.iterator();
                while (i.hasNext()) {
                    this.model.setActive(i.next(), true);
                }
            }
            if (!color) {
                this.model.setColorModel(cm);
            }
            return img;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void setOverlays(long tableID, Map<Long, Integer> overlays) {
        try {
            this.model.setOverlays(tableID, overlays);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void refresh() {
        this.firePropertyChange("colorModel", null, this.model.getColorModel());
        this.view.resetDefaultRndSettings();
    }

    @Override
    public void renderPreview() {
        if (!this.model.isGeneralIndex()) {
            return;
        }
        this.view.renderPreview();
    }

    @Override
    public ImageData getRefImage() {
        return this.model.getRefImage();
    }

    @Override
    public RndProxyDef getInitialRndSettings() {
        return this.model.getInitialRndSettings();
    }

    @Override
    public void retrieveRelatedSettings(Component source, Point location) {
        ArrayList<Serializable> l = new ArrayList<Serializable>();
        l.add(source);
        l.add(location);
        this.firePropertyChange("ViewedBy", null, l);
    }

    @Override
    public void loadRndSettings(boolean loading, List results) {
        Action a = this.controller.getAction(RendererControl.RND_OWNER);
        a.setEnabled(loading);
        this.view.displayViewedBy(results);
    }
}

