/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import com.sun.opengl.util.texture.TextureData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.romio.PlaneDef;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ChannelData;
import pojos.ImageData;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RendererModel {
    static final int PREVIEW_WIDTH = 256;
    static final int PREVIEW_HEIGHT = 256;
    static final int CD_START = 0;
    static final int CD_END = 255;
    static final int DEPTH_1BIT = 1;
    static final int DEPTH_2BIT = 3;
    static final int DEPTH_3BIT = 7;
    static final int DEPTH_4BIT = 15;
    static final int DEPTH_5BIT = 31;
    static final int DEPTH_6BIT = 63;
    static final int DEPTH_7BIT = 127;
    static final int DEPTH_8BIT = 255;
    static final String LINEAR = "linear";
    static final String LOGARITHMIC = "logarithmic";
    static final String EXPONENTIAL = "exponential";
    static final String POLYNOMIAL = "polynomial";
    private Renderer component;
    private RenderingControl rndControl;
    private int state;
    private int selectedChannelIndex;
    private boolean visible;
    private int rndIndex;
    private List<ChannelData> sortedChannel;
    private Double globalMinChannels;
    private Double globalMaxChannels;
    private PlaneDef plane;
    private Dimension previewSize;
    private RndProxyDef rndDef;
    private ImageData image;

    RendererModel(RenderingControl rndControl, int rndIndex) {
        if (rndControl == null) {
            throw new NullPointerException("No rendering control.");
        }
        this.setRenderingControl(rndControl);
        this.rndIndex = rndIndex;
        this.visible = false;
        this.globalMaxChannels = null;
        this.globalMinChannels = null;
        this.plane = new PlaneDef();
        this.plane.slice = 0;
    }

    void setImage(ImageData image) {
        this.image = image;
    }

    void setRenderingControl(RenderingControl rndControl) {
        this.rndControl = rndControl;
        if (rndControl != null) {
            this.rndDef = rndControl.getRndSettingsCopy();
        }
    }

    ImageData getRefImage() {
        return this.image;
    }

    boolean hasSelectedChannel() {
        return this.selectedChannelIndex >= 0;
    }

    int createSelectedChannel() {
        List<Integer> active = this.getActiveChannels();
        List<ChannelData> list = this.getChannelData();
        Iterator<ChannelData> i = list.iterator();
        int setIndex = -1;
        while (i.hasNext()) {
            ChannelData channel = i.next();
            int index = channel.getIndex();
            if (!active.contains(index) || setIndex >= 0) continue;
            setIndex = index;
            break;
        }
        return setIndex;
    }

    Color getChannelColor(int index) {
        return this.rndControl.getRGBA(index);
    }

    boolean isVisible() {
        return this.visible;
    }

    void initialize(Renderer component) {
        this.component = component;
    }

    void discard() {
        if (this.rndControl == null) {
            return;
        }
        OmeroImageService svr = MetadataViewerAgent.getRegistry().getImageService();
        svr.shutDown(this.rndControl.getPixelsID());
    }

    int getState() {
        return this.state;
    }

    void setInputInterval(int index, double start, double end) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        if (this.getMaxC() > 10) {
            for (int i = 0; i < this.getMaxC(); ++i) {
                this.rndControl.setChannelWindow(i, start, end);
            }
        } else {
            this.rndControl.setChannelWindow(index, start, end);
        }
    }

    int getCodomainEnd() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getCodomainEnd();
    }

    int getCodomainStart() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getCodomainStart();
    }

    void setCodomainInterval(int s, int e) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setCodomainInterval(s, e);
    }

    void setBitResolution(int v) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setQuantumStrategy(v);
    }

    void setSelectedChannel(int index) {
        this.selectedChannelIndex = index;
    }

    void setFamily(String family) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        boolean b = this.rndControl.getChannelNoiseReduction(this.selectedChannelIndex);
        double k = this.rndControl.getChannelCurveCoefficient(this.selectedChannelIndex);
        this.rndControl.setQuantizationMap(this.selectedChannelIndex, family, k, b);
    }

    void setCurveCoefficient(double k) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        boolean b = this.rndControl.getChannelNoiseReduction(this.selectedChannelIndex);
        String family = this.rndControl.getChannelFamily(this.selectedChannelIndex);
        this.rndControl.setQuantizationMap(this.selectedChannelIndex, family, k, b);
    }

    void setNoiseReduction(boolean b) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        String family = this.rndControl.getChannelFamily(this.selectedChannelIndex);
        double k = this.rndControl.getChannelCurveCoefficient(this.selectedChannelIndex);
        this.rndControl.setQuantizationMap(this.selectedChannelIndex, family, k, b);
    }

    List getCodomainMaps() {
        if (this.rndControl == null) {
            return null;
        }
        return this.rndControl.getCodomainMaps();
    }

    int getSelectedChannel() {
        return this.selectedChannelIndex;
    }

    List getFamilies() {
        if (this.rndControl == null) {
            return null;
        }
        return this.rndControl.getFamilies();
    }

    String getFamily() {
        if (this.rndControl == null) {
            return null;
        }
        return this.rndControl.getChannelFamily(this.selectedChannelIndex);
    }

    double getCurveCoefficient() {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getChannelCurveCoefficient(this.selectedChannelIndex);
    }

    int getBitResolution() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getBitResolution();
    }

    boolean isNoiseReduction() {
        if (this.rndControl == null) {
            return false;
        }
        return this.rndControl.getChannelNoiseReduction(this.selectedChannelIndex);
    }

    List<ChannelData> getChannelData() {
        if (this.rndControl == null) {
            return null;
        }
        if (this.sortedChannel == null) {
            Object[] data = this.rndControl.getChannelData();
            ViewerSorter sorter = new ViewerSorter();
            this.sortedChannel = Collections.unmodifiableList(sorter.sort(data));
        }
        return this.sortedChannel;
    }

    double getGlobalMin() {
        if (this.getMaxC() > 10) {
            if (this.globalMinChannels == null) {
                double min = Double.MAX_VALUE;
                for (int i = 0; i < this.getMaxC(); ++i) {
                    double value = this.getGlobalMin(i);
                    if (!(value < min)) continue;
                    min = value;
                }
                this.globalMinChannels = min;
            }
            return this.globalMinChannels;
        }
        return this.getGlobalMin(this.selectedChannelIndex);
    }

    int getRoundFactor() {
        return this.getRoundFactor(this.selectedChannelIndex);
    }

    int getRoundFactor(int channel) {
        double min = this.getGlobalMin(channel);
        double max = this.getGlobalMax(channel);
        double rmin = UIUtilities.roundTwoDecimals(min);
        double rmax = UIUtilities.roundTwoDecimals(max);
        if (rmin == min && rmax == max) {
            return 1;
        }
        return 100;
    }

    double getGlobalMax() {
        if (this.getMaxC() > 10) {
            if (this.globalMaxChannels == null) {
                double max = Double.MIN_VALUE;
                for (int i = 0; i < this.getMaxC(); ++i) {
                    double value = this.getGlobalMax(i);
                    if (!(value > max)) continue;
                    max = value;
                }
                this.globalMaxChannels = max;
            }
            return this.globalMaxChannels;
        }
        return this.getGlobalMax(this.selectedChannelIndex);
    }

    double getGlobalMax(int index) {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getChannelData(index).getGlobalMax();
    }

    double getGlobalMin(int index) {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getChannelData(index).getGlobalMin();
    }

    double getLowestValue() {
        return this.getLowestValue(this.selectedChannelIndex);
    }

    double getLowestValue(int channel) {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getPixelsTypeLowerBound(channel);
    }

    double getHighestValue() {
        return this.getHighestValue(this.selectedChannelIndex);
    }

    double getHighestValue(int channel) {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getPixelsTypeUpperBound(channel);
    }

    double getWindowStart(int channel) {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getChannelWindowStart(channel);
    }

    double getWindowEnd(int channel) {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getChannelWindowEnd(channel);
    }

    double getWindowStart() {
        return this.getWindowStart(this.selectedChannelIndex);
    }

    double getWindowEnd() {
        return this.getWindowEnd(this.selectedChannelIndex);
    }

    boolean isGreyScale() {
        if (this.rndControl == null) {
            return false;
        }
        return this.rndControl.getModel().equals("greyscale");
    }

    void saveRndSettings() throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.saveCurrentSettings();
    }

    boolean isChannelActive(int w) {
        if (this.rndControl == null) {
            return false;
        }
        return this.rndControl.isActive(w);
    }

    List<Integer> getActiveChannels() {
        if (this.rndControl == null) {
            return null;
        }
        ArrayList<Integer> active = new ArrayList<Integer>();
        for (int i = 0; i < this.getMaxC(); ++i) {
            if (!this.rndControl.isActive(i)) continue;
            active.add(i);
        }
        return active;
    }

    int getMaxC() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getPixelsDimensionsC();
    }

    int getRndIndex() {
        return this.rndIndex;
    }

    boolean isGeneralIndex() {
        return this.getRndIndex() == 0;
    }

    void setChannelColor(int index, Color color) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setRGBA(index, color);
    }

    String getColorModel() {
        if (this.rndControl == null) {
            return null;
        }
        return this.rndControl.getModel();
    }

    void setColorModel(String colorModel) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setModel(colorModel);
    }

    int getMaxX() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getPixelsDimensionsX();
    }

    int getMaxY() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getPixelsDimensionsY();
    }

    int getMaxZ() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getPixelsDimensionsZ();
    }

    int getMaxT() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getPixelsDimensionsT();
    }

    int getDefaultZ() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getDefaultZ();
    }

    int getDefaultT() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getDefaultT();
    }

    void setSelectedXYPlane(int z, int t) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        if (t >= 0 && t != this.getDefaultT()) {
            this.rndControl.setDefaultT(t);
        }
        if (z >= 0 && z != this.getDefaultZ()) {
            this.rndControl.setDefaultZ(z);
        }
    }

    void setChannelActive(int index, boolean active) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setActive(index, active);
    }

    int getCompressionLevel() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getCompressionLevel();
    }

    double getPixelsSizeY() {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getPixelsPhysicalSizeY();
    }

    double getPixelsSizeX() {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getPixelsPhysicalSizeX();
    }

    double getPixelsSizeZ() {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getPixelsPhysicalSizeZ();
    }

    RndProxyDef getRndSettingsCopy() {
        if (this.rndControl == null) {
            return null;
        }
        return this.rndControl.getRndSettingsCopy();
    }

    RndProxyDef getInitialRndSettings() {
        return this.rndDef;
    }

    boolean hasActiveChannel(int band) {
        if (this.rndControl == null) {
            return false;
        }
        switch (band) {
            case 0: {
                return this.rndControl.hasActiveChannelRed();
            }
            case 1: {
                return this.rndControl.hasActiveChannelGreen();
            }
            case 2: {
                return this.rndControl.hasActiveChannelBlue();
            }
        }
        return false;
    }

    boolean isCompressed() {
        if (this.rndControl == null) {
            return false;
        }
        return this.rndControl.isCompressed();
    }

    boolean isColorComponent(int band, int index) {
        if (this.rndControl == null) {
            return false;
        }
        switch (band) {
            case 0: {
                return this.rndControl.isChannelRed(index);
            }
            case 1: {
                return this.rndControl.isChannelGreen(index);
            }
            case 2: {
                return this.rndControl.isChannelBlue(index);
            }
        }
        return false;
    }

    void resetDefaults() throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.resetDefaults();
    }

    void resetSettings(RndProxyDef settings) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.resetSettings(settings);
    }

    RndProxyDef saveCurrentSettings() throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return null;
        }
        return this.rndControl.saveCurrentSettings();
    }

    void setActive(int index, boolean active) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setActive(index, active);
    }

    void setCompression(int compression) {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setCompression(compression);
    }

    void setOriginalRndSettings() throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setOriginalRndSettings();
    }

    boolean validatePixels(PixelsData pixels) {
        if (this.rndControl == null) {
            return false;
        }
        return this.rndControl.validatePixels(pixels);
    }

    BufferedImage renderPlane(PlaneDef pDef) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return null;
        }
        return this.rndControl.renderPlane(pDef);
    }

    TextureData renderPlaneAsTexture(PlaneDef pDef) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return null;
        }
        return this.rndControl.renderPlaneAsTexture(pDef);
    }

    boolean isSameSettings(RndProxyDef def, boolean checkPlane) {
        if (this.rndControl == null) {
            return false;
        }
        return this.rndControl.isSameSettings(def, checkPlane);
    }

    boolean isMappedImageRGB(List channels) {
        if (this.rndControl == null) {
            return false;
        }
        return this.rndControl.isMappedImageRGB(channels);
    }

    void setOverlays(long tableID, Map<Long, Integer> overlays) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setOverlays(tableID, overlays);
    }

    BufferedImage renderImage() {
        this.plane.t = this.getDefaultT();
        this.plane.z = this.getDefaultZ();
        try {
            if (this.rndControl == null) {
                return null;
            }
            return this.rndControl.renderPlane(this.plane, 2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    Dimension getPreviewDimension() {
        if (this.previewSize != null) {
            return this.previewSize;
        }
        this.previewSize = Factory.computeThumbnailSize(256, 256, this.getMaxX(), this.getMaxY());
        return this.previewSize;
    }

    void resetRenderingSettings() throws RenderingServiceException, DSOutOfServiceException {
        this.rndControl.resetSettings(this.rndDef);
    }

    boolean isBigImage() {
        return this.getMaxX() > 512 || this.getMaxY() > 512;
    }

    int getMaxLifetimeBin() {
        if (this.isNumerousChannel()) {
            return this.getMaxC();
        }
        return 0;
    }

    boolean isNumerousChannel() {
        if (this.getMaxC() >= 10) {
            return true;
        }
        return this.image.isLifetime();
    }

    int getSelectedBin() {
        List<Integer> active = this.getActiveChannels();
        if (active == null || active.size() != 1) {
            return 0;
        }
        return active.get(0);
    }

    void setSelectedBin(int bin) throws RenderingServiceException, DSOutOfServiceException {
        List<ChannelData> channels = this.getChannelData();
        for (ChannelData channel : channels) {
            int index;
            this.setActive(index, (index = channel.getIndex()) == bin);
        }
    }
}

