/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.util;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;

class FigureCanvas
extends JPanel {
    private BufferedImage image;
    private boolean imageVisible;

    FigureCanvas() {
        this.setBackground(this.getBackground());
        this.setDoubleBuffered(true);
        this.imageVisible = true;
    }

    void setImage(BufferedImage image) {
        this.image = image;
        this.repaint();
    }

    void setImageVisible(boolean imageVisible) {
        this.imageVisible = imageVisible;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        ImagePaintingFactory.setGraphicRenderingSettings(g2D);
        if (this.image == null) {
            Rectangle r = this.getBounds();
            g2D.drawRect(0, 0, r.width - 1, r.height - 1);
            return;
        }
        if (!this.imageVisible) {
            g2D.drawRect(0, 0, this.image.getWidth() - 1, this.image.getHeight() - 1);
            return;
        }
        g2D.drawImage(this.image, null, 0, 0);
    }
}

