/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.util;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;

public class ScriptMenuItem
extends JMenuItem {
    public static final int ROI_FIGURE_SCRIPT = 0;
    public static final int THUMBNAIL_FIGURE_SCRIPT = 1;
    public static final int MOVIE_FIGURE_SCRIPT = 2;
    public static final int SPLIT_VIEW_FIGURE_SCRIPT = 3;
    public static final int MOVIE_EXPORT_SCRIPT = 4;
    private static final List<String> SCRIPTS_UI_AVAILABLE = new ArrayList<String>();
    private ScriptObject script;
    private boolean scriptWithUI;

    public ScriptMenuItem(ScriptObject script) {
        if (script == null) {
            throw new IllegalArgumentException("A script cannot be null.");
        }
        this.script = script;
        String text = "";
        if (script.getScriptID() >= 0L && !script.isOfficialScript()) {
            text = "ID: " + script.getScriptID() + " ";
        }
        text = text + script.getName();
        this.setText(script.getDisplayedName() + "...");
        this.setToolTipText(text);
        String path = script.getScriptLabel();
        this.scriptWithUI = SCRIPTS_UI_AVAILABLE.contains(path);
        if (this.scriptWithUI) {
            IconManager icons = IconManager.getInstance();
            script.setIcon(icons.getIcon(110));
            script.setIconLarge(icons.getIcon(111));
        }
        this.setIcon(script.getIcon());
    }

    public int getIndex() {
        if (!this.scriptWithUI) {
            return -1;
        }
        if (!MetadataViewerAgent.isBinaryAvailable()) {
            return -1;
        }
        String path = this.script.getScriptLabel();
        if ("/omero/figure_scripts/ROI_Split_Figure.py".equals(path)) {
            return 0;
        }
        if ("/omero/figure_scripts/Thumbnail_Figure.py".equals(path)) {
            return 1;
        }
        if ("/omero/figure_scripts/Movie_Figure.py".equals(path)) {
            return 2;
        }
        if ("/omero/figure_scripts/Split_View_Figure.py".equals(path)) {
            return 3;
        }
        if ("/omero/export_scripts/Make_Movie.py".equals(path)) {
            return 4;
        }
        return -1;
    }

    public boolean isScriptWithUI() {
        if (!MetadataViewerAgent.isBinaryAvailable()) {
            return false;
        }
        return this.scriptWithUI;
    }

    public ScriptObject getScript() {
        return this.script;
    }

    static {
        SCRIPTS_UI_AVAILABLE.add("/omero/figure_scripts/ROI_Split_Figure.py");
        SCRIPTS_UI_AVAILABLE.add("/omero/figure_scripts/Thumbnail_Figure.py");
        SCRIPTS_UI_AVAILABLE.add("/omero/figure_scripts/Movie_Figure.py");
        SCRIPTS_UI_AVAILABLE.add("/omero/figure_scripts/Split_View_Figure.py");
        SCRIPTS_UI_AVAILABLE.add("/omero/export_scripts/Make_Movie.py");
    }
}

