/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.view;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerComponent;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataViewerFactory
implements ChangeListener {
    private static final MetadataViewerFactory singleton = new MetadataViewerFactory();
    private List<MetadataViewer> viewers = new ArrayList<MetadataViewer>();

    public static MetadataViewer getViewer(List<Object> data, Class type) {
        if (data == null || data.size() == 0) {
            throw new IllegalArgumentException("No data to edit");
        }
        MetadataViewerModel model = new MetadataViewerModel(data, 0);
        model.setDataType(type);
        return singleton.createViewer(model);
    }

    public static MetadataViewer getViewer(Object refObject) {
        return MetadataViewerFactory.getViewer(refObject, 0);
    }

    public static MetadataViewer getViewer(Object refObject, int index) {
        MetadataViewerModel model = new MetadataViewerModel(refObject, index);
        return singleton.createViewer(model);
    }

    public static List<Object> getInstancesToSave() {
        if (MetadataViewerFactory.singleton.viewers.size() == 0) {
            return null;
        }
        ArrayList<Object> instances = new ArrayList<Object>();
        for (MetadataViewerComponent metadataViewerComponent : MetadataViewerFactory.singleton.viewers) {
            if (!metadataViewerComponent.hasDataToSave()) continue;
            instances.add(metadataViewerComponent);
        }
        return instances;
    }

    public static void saveInstances(List<Object> instances) {
        if (instances != null) {
            for (Object o : instances) {
                if (!(o instanceof MetadataViewerComponent)) continue;
                ((MetadataViewerComponent)o).saveBeforeClose();
            }
        }
    }

    public static void onGroupSwitched(boolean success) {
        if (!success) {
            return;
        }
    }

    private MetadataViewerFactory() {
    }

    private MetadataViewer createViewer(MetadataViewerModel model) {
        MetadataViewerComponent comp = new MetadataViewerComponent(model);
        model.initialize(comp);
        comp.initialize();
        comp.addChangeListener(this);
        this.viewers.add(comp);
        return comp;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        MetadataViewerComponent comp = (MetadataViewerComponent)e.getSource();
        if (comp.getState() == 4 && this.viewers.size() > 0) {
            this.viewers.remove(comp);
        }
    }
}

