/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.agents.treeviewer.DataTreeViewerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ImportObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ScreenData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImagesImporter
extends DataTreeViewerLoader {
    private CallHandle handle;
    private List<TreeImageDisplay> nodes;
    private List<ImportObject> files;
    private DataObject container;
    private boolean archived;
    private int loaderID;

    public ImagesImporter(TreeViewer viewer, TreeImageDisplay node, List<ImportObject> files, boolean archived, int loaderID) {
        super(viewer);
        if (files == null || files.size() == 0) {
            throw new IllegalArgumentException("No images to import.");
        }
        this.files = files;
        this.archived = archived;
        this.loaderID = loaderID;
        if (node != null) {
            this.nodes = new ArrayList<TreeImageDisplay>(1);
            Object ho = node.getUserObject();
            if (ho instanceof DatasetData || ho instanceof ScreenData) {
                this.nodes.add(node);
                this.container = (DataObject)ho;
            }
        }
    }

    public ImagesImporter(TreeViewer viewer, List<TreeImageDisplay> nodes, List<ImportObject> files, boolean archived, int loaderID) {
        super(viewer);
        if (files == null || files.size() == 0) {
            throw new IllegalArgumentException("No images to import.");
        }
        this.loaderID = loaderID;
        this.files = files;
        this.nodes = nodes;
        this.archived = archived;
        this.container = null;
    }

    @Override
    public void load() {
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        if (this.viewer.getState() == 5) {
            return;
        }
        Map m = (Map)fe.getPartialResult();
        if (m != null) {
            for (Map.Entry entry : m.entrySet()) {
                this.viewer.setImportedFiles((File)entry.getKey(), entry.getValue(), this.nodes, this.container, this.loaderID);
            }
        }
    }

    @Override
    public void handleException(Throwable exc) {
        String s = "File Import Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError("File Import Failure", s, exc);
    }

    @Override
    public void handleNullResult() {
    }
}

