/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.Collection;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.ExperimenterData;
import pojos.PlateData;
import pojos.ScreenData;

public class ScreenPlateLoader
extends DataBrowserLoader {
    public static final int SCREEN = 0;
    public static final int PLATE = 1;
    private Class rootType;
    private TreeImageSet parent;
    private TreeImageSet expNode;
    private CallHandle handle;

    private Class getClassType(int type) {
        switch (type) {
            case 0: {
                return ScreenData.class;
            }
            case 1: {
                return PlateData.class;
            }
        }
        return null;
    }

    public ScreenPlateLoader(Browser viewer, TreeImageSet expNode, int type, TreeImageSet parent) {
        super(viewer);
        if (expNode == null || !(expNode.getUserObject() instanceof ExperimenterData)) {
            throw new IllegalArgumentException("Experimenter node not valid.");
        }
        this.rootType = this.getClassType(type);
        this.expNode = expNode;
        this.parent = parent;
    }

    public ScreenPlateLoader(Browser viewer, TreeImageSet expNode, int type) {
        this(viewer, expNode, type, null);
    }

    public void load() {
        ExperimenterData exp = (ExperimenterData)this.expNode.getUserObject();
        if (this.parent == null) {
            this.handle = this.dmView.loadContainerHierarchy(ScreenData.class, null, false, exp.getId(), this.viewer.getUserGroupID(), this);
        }
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 16) {
            return;
        }
        if (this.parent == null) {
            this.viewer.setExperimenterData(this.expNode, (Collection)result);
        }
    }
}

