/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.io.File;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageNode;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheckNode;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.MultiImageData;
import pojos.PlateAcquisitionData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.WellData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeViewerTranslator {
    private static void formatToolTipFor(TreeImageDisplay node) {
        if (node == null) {
            throw new IllegalArgumentException("No node");
        }
        String toolTip = "";
        String title = null;
        Object uo = node.getUserObject();
        if (uo instanceof ImageData) {
            ImageData img = (ImageData)uo;
            Timestamp time = EditorUtil.getAcquisitionTime(img);
            title = time == null ? "Not available" : UIUtilities.formatTime(time);
            StringBuffer buf = new StringBuffer();
            buf.append("<html><body>");
            buf.append(UIUtilities.formatString(img.getName(), -1));
            buf.append("<br>");
            buf.append(title);
            toolTip = UIUtilities.formatToolTipText(buf.toString());
            node.setToolTip(toolTip);
        } else if (uo instanceof WellData) {
            toolTip = UIUtilities.formatToolTipText(((WellData)node.getUserObject()).getExternalDescription());
            node.setToolTip(toolTip);
        } else if (uo instanceof File) {
            // empty if block
        }
    }

    private static TreeCheckNode transformDatasetCheckNode(DatasetData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        IconManager im = IconManager.getInstance();
        TreeCheckNode node = new TreeCheckNode(data, im.getIcon(5), data.getName(), true);
        return node;
    }

    private static TreeCheckNode transformImageCheckNode(ImageData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        IconManager im = IconManager.getInstance();
        TreeCheckNode node = new TreeCheckNode(data, im.getIcon(6), data.getName(), true);
        return node;
    }

    private static TreeImageDisplay transformDataset(DatasetData data, long userID, long groupID) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageSet dataset = new TreeImageSet(data);
        Set images = data.getImages();
        if (images == null) {
            dataset.setNumberItems(-1L);
        } else {
            dataset.setChildrenLoaded(Boolean.TRUE);
            dataset.setNumberItems(images.size());
            for (DataObject tmp : images) {
                ImageData child;
                if (!(tmp instanceof ImageData) || !EditorUtil.isReadable(child = (ImageData)tmp, userID, groupID)) continue;
                dataset.addChildDisplay(TreeViewerTranslator.transformImage(child));
            }
        }
        TreeViewerTranslator.formatToolTipFor(dataset);
        return dataset;
    }

    private static TreeImageDisplay transformPlate(PlateData data, ScreenData screen, long userID, long groupID) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageSet plate = new TreeImageSet(data);
        Set acquisitions = data.getPlateAcquisitions();
        if (acquisitions != null && acquisitions.size() > 0) {
            Iterator i = acquisitions.iterator();
            long id = data.getId();
            while (i.hasNext()) {
                PlateAcquisitionData pa = (PlateAcquisitionData)i.next();
                pa.setRefPlateId(id);
                plate.addChildDisplay(new TreeImageSet(pa));
            }
            plate.setChildrenLoaded(true);
        }
        TreeViewerTranslator.formatToolTipFor(plate);
        return plate;
    }

    private static TreeImageDisplay transformWell(WellData data, long userID, long groupID) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageSet well = new TreeImageSet(data);
        TreeViewerTranslator.formatToolTipFor(well);
        return well;
    }

    private static TreeImageDisplay transformTag(TagAnnotationData data, long userID, long groupID) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageSet tag = new TreeImageSet(data);
        TreeViewerTranslator.formatToolTipFor(tag);
        if ("openmicroscopy.org/omero/insight/tagset".equals(data.getNameSpace())) {
            Set tags = data.getTags();
            if (tags != null && tags.size() > 0) {
                tag.setChildrenLoaded(Boolean.TRUE);
                for (TagAnnotationData tmp : tags) {
                    tag.addChildDisplay(TreeViewerTranslator.transformTag(tmp, userID, groupID));
                }
                tag.setNumberItems(tags.size());
                return tag;
            }
            tag.setChildrenLoaded(Boolean.TRUE);
            tag.setNumberItems(0L);
            return tag;
        }
        Set dataObjects = data.getDataObjects();
        if (dataObjects == null || dataObjects.size() == 0) {
            tag.setNumberItems(-1L);
        } else {
            tag.setChildrenLoaded(Boolean.TRUE);
            tag.setNumberItems(dataObjects.size());
            for (DataObject tmp : dataObjects) {
                if (!EditorUtil.isReadable(tmp, userID, groupID)) continue;
                if (tmp instanceof ImageData) {
                    tag.addChildDisplay(TreeViewerTranslator.transformImage((ImageData)tmp));
                    continue;
                }
                if (tmp instanceof DatasetData) {
                    tag.addChildDisplay(TreeViewerTranslator.transformDataset((DatasetData)tmp, userID, groupID));
                    continue;
                }
                if (!(tmp instanceof ProjectData)) continue;
                ProjectData p = (ProjectData)tmp;
                tag.addChildDisplay(TreeViewerTranslator.transformProject(p, p.getDatasets(), userID, groupID));
            }
        }
        return tag;
    }

    private static TreeImageDisplay transformFile(FileAnnotationData data, long userID, long groupID) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageNode node = new TreeImageNode(data);
        TreeViewerTranslator.formatToolTipFor(node);
        return node;
    }

    private static TreeImageDisplay transformProject(ProjectData data, Set datasets, long userID, long groupID) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageSet project = new TreeImageSet(data);
        if (datasets != null) {
            project.setChildrenLoaded(Boolean.TRUE);
            for (DatasetData child : datasets) {
                if (!EditorUtil.isReadable(child, userID, groupID)) continue;
                project.addChildDisplay(TreeViewerTranslator.transformDataset(child, userID, groupID));
            }
            project.setNumberItems(datasets.size());
        } else {
            project.setChildrenLoaded(Boolean.FALSE);
            project.setNumberItems(0L);
        }
        return project;
    }

    private static TreeImageDisplay transformScreen(ScreenData data, Set plates, long userID, long groupID) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageSet screen = new TreeImageSet(data);
        if (plates != null) {
            screen.setChildrenLoaded(Boolean.TRUE);
            for (PlateData child : plates) {
                if (!EditorUtil.isReadable(child, userID, groupID)) continue;
                screen.addChildDisplay(TreeViewerTranslator.transformPlate(child, data, userID, groupID));
            }
            screen.setNumberItems(plates.size());
        } else {
            screen.setChildrenLoaded(Boolean.FALSE);
            screen.setNumberItems(0L);
        }
        return screen;
    }

    public static TreeImageDisplay transformImage(ImageData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageNode node = new TreeImageNode(data);
        TreeViewerTranslator.formatToolTipFor(node);
        return node;
    }

    public static Set transformHierarchy(Collection dataObjects, long userID, long groupID) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<TreeImageDisplay> results = new HashSet<TreeImageDisplay>(dataObjects.size());
        for (DataObject ho : dataObjects) {
            TreeImageDisplay child;
            if (!EditorUtil.isReadable(ho, userID, groupID)) continue;
            if (ho instanceof ProjectData) {
                results.add(TreeViewerTranslator.transformProject((ProjectData)ho, ((ProjectData)ho).getDatasets(), userID, groupID));
                continue;
            }
            if (ho instanceof ImageData) {
                results.add(TreeViewerTranslator.transformImage((ImageData)ho));
                continue;
            }
            if (ho instanceof DatasetData) {
                child = TreeViewerTranslator.transformDataset((DatasetData)ho, userID, groupID);
                results.add(child);
                continue;
            }
            if (ho instanceof TagAnnotationData) {
                child = TreeViewerTranslator.transformTag((TagAnnotationData)ho, userID, groupID);
                results.add(child);
                continue;
            }
            if (ho instanceof ScreenData) {
                results.add(TreeViewerTranslator.transformScreen((ScreenData)ho, ((ScreenData)ho).getPlates(), userID, groupID));
                continue;
            }
            if (ho instanceof PlateData) {
                results.add(TreeViewerTranslator.transformPlate((PlateData)ho, null, userID, groupID));
                continue;
            }
            if (ho instanceof WellData) {
                results.add(TreeViewerTranslator.transformWell((WellData)ho, userID, groupID));
                continue;
            }
            if (!(ho instanceof FileAnnotationData)) continue;
            child = TreeViewerTranslator.transformFile((FileAnnotationData)ho, userID, groupID);
            results.add(child);
        }
        return results;
    }

    public static Set refreshHierarchy(Map nodes, Map expandedTopNodes, long userID, long groupID) {
        if (nodes == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<TreeImageDisplay> results = new HashSet<TreeImageDisplay>(nodes.size());
        Set set = nodes.entrySet();
        Iterator i = set.iterator();
        List expanded = null;
        while (i.hasNext()) {
            Set r;
            TreeImageDisplay display;
            Map.Entry entry = i.next();
            DataObject ho = (DataObject)entry.getKey();
            if (!EditorUtil.isReadable(ho, userID, groupID)) continue;
            if (ho instanceof ProjectData) {
                if (expandedTopNodes != null) {
                    expanded = (List)expandedTopNodes.get(ProjectData.class);
                }
                display = TreeViewerTranslator.transformProject((ProjectData)ho, (Set)entry.getValue(), userID, groupID);
                if (expanded != null) {
                    display.setExpanded(expanded.contains(ho.getId()));
                }
                results.add(display);
                continue;
            }
            if (ho instanceof DatasetData) {
                if (expandedTopNodes != null) {
                    expanded = (List)expandedTopNodes.get(DatasetData.class);
                }
                r = (Set)entry.getValue();
                for (DatasetData element : r) {
                    display = TreeViewerTranslator.transformDataset(element, userID, groupID);
                    if (expanded != null) {
                        display.setExpanded(expanded.contains(ho.getId()));
                    }
                    results.add(display);
                }
                continue;
            }
            if (ho instanceof TagAnnotationData) {
                if (expandedTopNodes != null) {
                    expanded = (List)expandedTopNodes.get(TagAnnotationData.class);
                }
                r = (Set)entry.getValue();
                for (DatasetData element : r) {
                    display = TreeViewerTranslator.transformTag((TagAnnotationData)element, userID, groupID);
                    if (expanded != null) {
                        display.setExpanded(expanded.contains(ho.getId()));
                    }
                    results.add(display);
                }
                continue;
            }
            if (ho instanceof ScreenData) {
                if (expandedTopNodes != null) {
                    expanded = (List)expandedTopNodes.get(ScreenData.class);
                }
                display = TreeViewerTranslator.transformScreen((ScreenData)ho, ((ScreenData)ho).getPlates(), userID, groupID);
                if (expanded != null) {
                    display.setExpanded(expanded.contains(ho.getId()));
                }
                results.add(display);
                continue;
            }
            if (!(ho instanceof PlateData)) continue;
            display = TreeViewerTranslator.transformPlate((PlateData)ho, null, userID, groupID);
            if (expanded != null) {
                display.setExpanded(expanded.contains(ho.getId()));
            }
            results.add(display);
        }
        return results;
    }

    public static TreeImageDisplay transformDataObject(DataObject object, long userID, long groupID) {
        if (object == null) {
            throw new IllegalArgumentException("No object.");
        }
        if (!EditorUtil.isReadable(object, userID, groupID)) {
            throw new IllegalArgumentException("Data object not readable.");
        }
        if (object instanceof ProjectData) {
            return TreeViewerTranslator.transformProject((ProjectData)object, ((ProjectData)object).getDatasets(), userID, groupID);
        }
        if (object instanceof DatasetData) {
            return TreeViewerTranslator.transformDataset((DatasetData)object, userID, groupID);
        }
        if (object instanceof ImageData) {
            return TreeViewerTranslator.transformImage((ImageData)object);
        }
        if (object instanceof ScreenData) {
            return TreeViewerTranslator.transformScreen((ScreenData)object, ((ScreenData)object).getPlates(), userID, groupID);
        }
        if (object instanceof PlateData) {
            return TreeViewerTranslator.transformPlate((PlateData)object, null, userID, groupID);
        }
        if (object instanceof TagAnnotationData) {
            return TreeViewerTranslator.transformTag((TagAnnotationData)object, userID, groupID);
        }
        throw new IllegalArgumentException("Data Type not supported.");
    }

    public static Set transformDataObjectsCheckNode(Set dataObjects, long userID, long groupID) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<TreeCheckNode> results = new HashSet<TreeCheckNode>(dataObjects.size());
        for (DataObject ho : dataObjects) {
            if (!(ho instanceof DatasetData)) continue;
            results.add(TreeViewerTranslator.transformDatasetCheckNode((DatasetData)ho));
        }
        return results;
    }

    public static Set transformIntoCheckNodes(Set paths, long userID, long groupID) {
        if (paths == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<TreeCheckNode> results = new HashSet<TreeCheckNode>();
        for (DataObject ho : paths) {
            if (ho instanceof DatasetData) {
                results.add(TreeViewerTranslator.transformDatasetCheckNode((DatasetData)ho));
                continue;
            }
            if (!(ho instanceof ImageData)) continue;
            results.add(TreeViewerTranslator.transformImageCheckNode((ImageData)ho));
        }
        return results;
    }

    public static boolean isVisible(DataObject data, ExperimenterData loggedUser) {
        if (data == null) {
            return false;
        }
        return data instanceof ExperimenterData || data instanceof GroupData;
    }

    public static Map<Integer, Set> refreshFolderHierarchy(Map nodes, long userID, long groupID) {
        if (nodes == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashMap<Integer, Set> r = new HashMap<Integer, Set>(nodes.size());
        Set set = nodes.entrySet();
        for (Map.Entry entry : set) {
            HashSet<TreeImageDisplay> converted;
            Set results;
            TreeImageDisplay node = (TreeImageDisplay)entry.getKey();
            if (node instanceof TreeImageTimeSet) {
                results = (Set)entry.getValue();
                converted = new HashSet<TreeImageDisplay>(results.size());
                for (DataObject ho : results) {
                    if (!EditorUtil.isReadable(ho, userID, groupID)) continue;
                    converted.add(TreeViewerTranslator.transformImage((ImageData)ho));
                }
                r.put(((TreeImageTimeSet)node).getIndex(), converted);
                continue;
            }
            if (!(node instanceof TreeFileSet)) continue;
            results = (Set)entry.getValue();
            converted = new HashSet(results.size());
            for (DataObject ho : results) {
                if (!EditorUtil.isReadable(ho, userID, groupID)) continue;
                converted.add(TreeViewerTranslator.transformFile((FileAnnotationData)ho, userID, groupID));
            }
            r.put(((TreeFileSet)node).getType(), converted);
        }
        return r;
    }

    public static Timestamp getAcquisitionTime(ImageData image) {
        if (image == null) {
            return null;
        }
        Timestamp date = null;
        try {
            date = image.getAcquisitionDate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static Set transformGroups(Collection groups) {
        HashSet<TreeImageSet> nodes = new HashSet<TreeImageSet>();
        if (groups == null) {
            return nodes;
        }
        for (GroupData g : groups) {
            TreeImageSet n = new TreeImageSet(g);
            Set l = g.getExperimenters();
            if (l != null && l.size() > 0) {
                n.setChildrenLoaded(true);
                Iterator j = l.iterator();
                while (j.hasNext()) {
                    n.addChildDisplay(new TreeImageNode(j.next()));
                }
                n.setNumberItems(l.size());
            } else {
                n.setNumberItems(0L);
            }
            nodes.add(n);
        }
        return nodes;
    }

    public static Set transformExperimenters(Collection list) {
        HashSet<TreeImageNode> nodes = new HashSet<TreeImageNode>();
        if (list == null) {
            return nodes;
        }
        for (Object ho : list) {
            if (!(ho instanceof ExperimenterData)) continue;
            ExperimenterData exp = (ExperimenterData)ho;
            TreeImageNode node = new TreeImageNode(exp);
            node.setToolTip("Login Name: " + exp.getUserName());
            nodes.add(node);
        }
        return nodes;
    }

    public static TreeImageDisplay transformMultiImage(MultiImageData object) {
        if (object == null) {
            return null;
        }
        List images = object.getComponents();
        if (images != null && images.size() > 0) {
            TreeImageSet node = new TreeImageSet(object);
            node.setChildrenLoaded(true);
            node.setNumberItems(images.size());
            Iterator i = images.iterator();
            while (i.hasNext()) {
                node.addChildDisplay(TreeViewerTranslator.transformImage((ImageData)i.next()));
            }
            return node;
        }
        return new TreeImageNode(object);
    }
}

