/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.DeleteCmd;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.PlateAcquisitionData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

public class BrowserDeleteAction
extends BrowserAction {
    private static final String NAME = "Delete";
    private static final String DESCRIPTION = "Delete the selected elements.";

    protected void onStateChange() {
        switch (this.model.getState()) {
            case 11: 
            case 12: 
            case 13: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(this.model.getLastSelectedDisplay());
            }
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof DatasetData || ho instanceof ProjectData || ho instanceof FileAnnotationData || ho instanceof TagAnnotationData || ho instanceof ScreenData || ho instanceof PlateData || ho instanceof PlateAcquisitionData) {
            TreeImageDisplay[] selected = this.model.getSelectedDisplays();
            int count = 0;
            boolean b = false;
            for (int i = 0; i < selected.length; ++i) {
                b = this.model.isUserOwner(selected[i].getUserObject());
                if (!b) continue;
                ++count;
            }
            this.setEnabled(count == selected.length);
        } else if (ho instanceof ExperimenterData) {
            if (this.model.getBrowserType() == 107) {
                this.setEnabled(false);
            } else {
                this.setEnabled(false);
            }
        } else if (ho instanceof GroupData) {
            this.setEnabled(false);
        } else if (ho instanceof ImageData) {
            int count = 0;
            boolean b = false;
            TreeImageDisplay[] selected = this.model.getSelectedDisplays();
            for (int i = 0; i < selected.length; ++i) {
                b = this.model.isUserOwner(selected[i].getUserObject());
                if (!b) continue;
                ++count;
            }
            this.setEnabled(count == selected.length);
        } else {
            this.setEnabled(false);
        }
    }

    public BrowserDeleteAction(Browser model) {
        super(model);
        this.setEnabled(true);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(26));
    }

    public void actionPerformed(ActionEvent e) {
        DeleteCmd cmd = new DeleteCmd(this.model);
        cmd.execute();
    }
}

