/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;

public class EditorAction
extends TreeViewerAction {
    public static final int NO_SELECTION = 0;
    public static final int WITH_SELECTION = 1;
    public static final int NEW_WITH_SELECTION = 2;
    private static final String NAME = "Launch Editor...";
    private static final String NAME_EXPERIMENT = "New Experiment...";
    private static final String DESCRIPTION = "Launch the Editor.";
    private int index;

    private void checkValue(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                this.index = index;
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    private boolean isEditorFile(FileAnnotationData fa) {
        if (fa == null) {
            return false;
        }
        String name = fa.getFileName();
        String ns = fa.getNameSpace();
        if (name == null) {
            return false;
        }
        return "openmicroscopy.org/omero/editor/experiment".equals(ns) || "openmicroscopy.org/omero/editor/protocol".equals(ns) || "openmicroscopy.org/omero/import/companionFile".equals(ns) || EditorUtil.isEditorFile(name);
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        this.onBrowserStateChange(this.model.getSelectedBrowser());
    }

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        int state = browser.getState();
        switch (this.index) {
            case 1: {
                if (state == 15) {
                    List l = browser.getSelectedDataObjects();
                    if (l == null || l.size() != 1) {
                        this.setEnabled(false);
                        break;
                    }
                    Object object = l.get(0);
                    if (object instanceof FileAnnotationData) {
                        FileAnnotationData fa = (FileAnnotationData)object;
                        this.setEnabled(this.isEditorFile(fa));
                        break;
                    }
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(false);
                break;
            }
            case 0: {
                this.setEnabled(state == 15);
                break;
            }
            case 2: {
                if (state == 15) {
                    List l = browser.getSelectedDataObjects();
                    if (l == null || l.size() != 1) {
                        this.setEnabled(false);
                        break;
                    }
                    Object ho = l.get(0);
                    if (ho instanceof ProjectData || ho instanceof DatasetData || ho instanceof ImageData || ho instanceof ScreenData || ho instanceof PlateData) {
                        this.setEnabled(this.model.isObjectWritable(ho));
                        break;
                    }
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(false);
            }
        }
    }

    public EditorAction(TreeViewer model, int index) {
        super(model);
        this.name = NAME;
        this.checkValue(index);
        if (index == 2) {
            this.name = NAME_EXPERIMENT;
        }
        IconManager icons = IconManager.getInstance();
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.putValue("SmallIcon", icons.getIcon(79));
    }

    public void actionPerformed(ActionEvent e) {
        this.model.openEditorFile(this.index);
    }
}

