/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.GroupData;

public class GroupSelectionAction
extends TreeViewerAction {
    private GroupData group;

    private void setPermissions() {
        IconManager im = IconManager.getInstance();
        Icon icon = im.getIcon(112);
        int level = TreeViewerAgent.getRegistry().getAdminService().getPermissionLevel(this.group);
        String desc = "";
        switch (level) {
            case 100: {
                desc = "Private Group";
                icon = im.getIcon(130);
                break;
            }
            case 101: {
                desc = "Collaborative Read-Only Group";
                icon = im.getIcon(131);
                break;
            }
            case 102: {
                desc = "Collaborative Group";
                icon = im.getIcon(132);
                break;
            }
            case 103: {
                desc = "Public";
                icon = im.getIcon(133);
                break;
            }
            case 104: {
                desc = "Public";
                icon = im.getIcon(133);
            }
        }
        this.putValue("SmallIcon", icon);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(desc));
    }

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        this.setEnabled(browser.getState() == 15);
    }

    public GroupSelectionAction(TreeViewer model, GroupData group) {
        super(model);
        if (group == null) {
            throw new IllegalArgumentException("No group specified.");
        }
        this.group = group;
        this.name = group.getName();
        this.putValue("Name", this.name);
        this.setPermissions();
    }

    public boolean isSameGroup(long groupID) {
        return this.group.getId() == groupID;
    }

    public void actionPerformed(ActionEvent e) {
        this.model.setUserGroup(this.group);
    }
}

